#!/usr/bin/perl

use strict;

my $line = "";
my $valueLine = "";
my $previousValue = 0;
my $currentValue = 0;
my $lineCount = 0;
my $consuming = 0;
my $dopamineHistory = "";
my $historyLength = 0;

my $positiveConsumed = 0;
my $negativeConsumed = 0;

my $S;
my $V;
open ($S, "grep visitedStates log.txt | ");
open ($V, "grep visitedValues log.txt | ");

my $skip = $ARGV[0];

if ($skip > 1)
{
	for (my $i = 0; $i < $skip; $i++)
	{
		$lineCount++;
		my $dummy1 = <$S>;
		my $dummy2 = <$V>;
	}
}

while ($line = <$S>)
{
$previousValue = $currentValue;
$valueLine = <$V>;
my (@valuePieces) = split(/\s/, $valueLine);
$currentValue = $valuePieces[3];

chop $line;
$lineCount++;
$line = substr($line, index($line,"["));
chop $line;
$line = substr($line, 1);
my (@pieces) = split(/,/, $line);

my $agentX = substr($pieces[0], 1+index($pieces[0], "="));
my $agentY = substr($pieces[1], 1+index($pieces[1], "="));
my $zapped = substr($pieces[2], 1+index($pieces[2], "="));
my $consumed = substr($pieces[11], 1+index($pieces[11], "="));

my $objectX = substr($pieces[7], 1+index($pieces[7], "="));
my $objectY = substr($pieces[8], 1+index($pieces[8], "="));
my $objectID = substr($pieces[9], 1+index($pieces[9],"="));
my $orient = substr($pieces[3], 1+index($pieces[3], "="));
my $shape = "?";

if ($orient eq "NORTH") { $shape = "^"; }
if ($orient eq "SOUTH") { $shape = "v"; }
if ($orient eq "EAST") { $shape = ">"; }
if ($orient eq "WEST") { $shape = "<"; }

system "clear";
print "linecount = $lineCount\t + = $positiveConsumed\t - = $negativeConsumed\n";
for (my $y = 0; $y < 5; $y++)
{
	for (my $x = 0; $x < 5; $x++)
	{
		if (($agentX eq $x) && ($agentY eq $y))
		{
			if ($consumed eq "true")
			{
				print "#"; $consuming = 1;
			}
			else
			{
				print $shape;
			}
		}
		elsif (($objectX eq $x) && ($objectY eq $y) && ($objectID ne "NOTHING"))
		{
			if ($objectID eq "POSITIVE") { print "+"; }
			if ($objectID eq "NEGATIVE") { print "-"; }
			if ($objectID eq "NEUTRAL") { print "o"; }
		}
		else
		{
			print ".";
		}
		print " ";
	}
	print "\n";
}
print $pieces[4]."\n";
print $pieces[5]."\n";

if ($zapped eq "true") { $dopamineHistory .= " =( "; }
elsif ($consumed eq "true") { $dopamineHistory .= " =) "; }
elsif ($pieces[4] eq "see=POSITIVE")  { $dopamineHistory .= "O_O+"; }
elsif ($pieces[4] eq "see=NEGATIVE") { $dopamineHistory .= "O_O-"; }
elsif ($pieces[4] eq "see=UNKNOWN") { $dopamineHistory .= " ?? "; }
else { $dopamineHistory .= "    "; }

$dopamineHistory .= "\tobjectID = " . $objectID . "\t(".$pieces[4].")\t " . $pieces[6]. "  \tdopamine = ".($previousValue-$currentValue)."\n";
$historyLength++;
print $dopamineHistory."\n";
select(undef, undef, undef, 0.05);
if ($consuming eq 1)
{
	select(undef, undef, undef, 0.15);
	# $dopamineHistory = "";
	if ($objectID eq "POSITIVE") { $positiveConsumed++; }	
	if ($objectID eq "NEGATIVE") { $negativeConsumed++; }	
}
if ($zapped eq "true") { $negativeConsumed++; }
if ($consumed eq "true") { $positiveConsumed++; }
$consuming = 0;
if ($historyLength eq 30)
{
	system "clear"; $dopamineHistory  = ""; $historyLength =0;
}

}
