#!/usr/bin/perl
# ---------------------------------------------------------
# aplot.pl -- ascii on-screen 2d plot
# ---------------------------------------------------------
# patryk@pakl.net -- December 7, 2001
#
# Copyright (C) 2001, 2002 Patryk Laurent
# This code is hereby released under GNU GPL.
# ---------------------------------------------------------
# Usage:
# Data is in a file whose name is the argument.
# $ chmod +x aplot.pl
# $ ./plot.pl data1
# where data1 is space-separated pairs x y
# -4 16
# -3 9
# -2 4
# -1 1
# 0 0
# 1 1
# 2 4
# 3 9
# 4 16
# 5 25
# 6 36
# 
# ---------------------------------------------------------

# 0 0 0 0 	=> free
# x1 y1 x2 y2 	=> restricted
# x,y


$connectFlag = 1;
$marker = "x";
$axis = 1;
$maxX = 50;
$maxY = 20;
$| = 1;
open (I, $ARGV[0]);
$i = 0;
while (<I>) {
  if (length>1) {
	s/  / /gsi;
	($dataX[$i], $dataY[$i]) = split;
	if ($dataY[$i] eq "") { $dataY[$i] = $dataX[$i]; $dataX[$i] = $i;  }
	# print $dataX[$i]."\t".$dataY[$i]."\n";
  }
  $i++;
}

sub max {
	(my @list) = @_;
	my $x = $list[0];
	for (my $i=0; $i <= $#list; $i++) {
		if ($list[$i] > $x) {
			$x = $list[$i];
		}
	}
	return $x;
}

sub min {
	(my @list) = @_;
	my $x = $list[0];
	for (my $i=0; $i <= $#list; $i++) {
		if ($list[$i] < $x) {
			$x = $list[$i];
		}
	}
	return $x;
}

# -----------------------------------------------

for ($y = 1; $y <= $maxY; $y++) {
 for ($x = 1; $x <= $maxX; $x++) {
  $pixelArray[$x][$y]=" ";
 }
 # print "\n";
}

if ($axis==1) {
	for ($y = 0; $y <= $maxY; $y++) {
		$pixelArray[0][$y] = "|";
	}
	for ($x = 0; $x <= $maxX; $x++) {
		$pixelArray[$x][0] = "-";
	}
}

#system "clear";

# no negative indices allowed onto the screen

$upsetX = 0 - min(@dataX);
$upsetY = 0 - min(@dataY);
if ($upsetY > 0) {
  for ($i = 0; $i <= $#dataY; $i++) {
	$dataY[$i] = $dataY[$i] + $upsetY;
  }
}
if ($upsetX > 0) {
  for ($i = 0; $i <= $#dataX; $i++) {
	$dataX[$i] = $dataX[$i] + $upsetX;
  }
}

$scaleY = $maxY / max(@dataY);
$scaleX = $maxX / max(@dataX);
# print "scaleY = $scaleY \n";
# print "scaleX = $scaleX \n";
for ($i = 0; $i <= $#dataX; $i++) {

	$pixelx = 1+ int ( ( $dataX[$i]-min(@dataX)) * $scaleX );
	$pixely = 1+ int ( ( $dataY[$i]-min(@dataY)) * $scaleY );
	$x = $pixelx;
	$y = $pixely;
	#print $dataX[$i].",". $dataY[$i]." -> $pixelx, $pixely \n";
	print ".";

	if ($connectFlag==1) {
		if ($prevX ne "") {
			# $x2 = max( ($prevX, $x) );
			# $x1 = min( ($prevX, $x) );
			# $y2 = max( ($prevY, $y) );
			# $y1 = min( ($prevY, $y) );
			$x2 = $x;
			$x1 = $prevX;
			$y2 = $y;
			$y1 = $prevY;
			if (($x2 - $x1) == 0) { $x2 = $x1 + 0.0001; }
			$m = ($y2-$y1)/($x2-$x1);
			$b = $y1 - $m*$x1;
			#print "slope =  ($y2-$y1)/($x2-$x1) = $m \n";
			#print "$x1, $y1 -> $x2, $y2 \n";
			for ($x = $x1+1; $x < ($x2); $x++) {
				if ($x1 > $x2) {
				$y = int ( $m*$x + ($b) );
				} else {
				$y = int ( $m*$x + ($b) );
				}
				
				$pixelArray[$x][$y] = ".";
				#print "$x,$y \n";
			}
		}
		$prevX = $pixelx;
		$prevY = $pixely;
	}

	$pixelArray[$pixelx][$pixely] = $marker;

}


for ($y = $maxY; $y >= 0; $y--) {
 for ($x = 0; $x <= $maxX; $x++) {
  print $pixelArray[$x][$y];
 }
 print "\n";
}

