/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.io.Serializable;

public class Word
implements Serializable {
    private String text;
    private double frequency;
    private Word preceedingWord;
    private double predictabilityFromPreceedingWord;
    private int id;
    private int identificationTime = 15;
    private int manuallySetLength = 0;
    private boolean stringLengthOverridden = false;

    public Word(String wordText) {
        this.text = wordText;
    }

    public Word(String wordText, double frequency) {
        this.text = wordText;
        this.frequency = frequency;
    }

    public Word(String wordText, double frequency, Word preceedingWord, double predictability) {
        this.text = wordText;
        this.frequency = frequency;
        this.preceedingWord = preceedingWord;
        this.predictabilityFromPreceedingWord = predictability;
    }

    public boolean equals(Object o) {
        if (o instanceof Word) {
            Word other = (Word)o;
            if (this.getID() != other.getID()) {
                return false;
            }
            return this.getText().equals(other.getText());
        }
        return false;
    }

    public Word() {
    }

    public String toString() {
        return "[" + this.text + ",aid=" + this.getIdentificationTime() + "ms]";
    }

    public int getID() {
        return this.id;
    }

    public Word setID(int id) {
        this.id = id;
        return this;
    }

    public void setLengthOverride(int newLength) {
        this.manuallySetLength = newLength;
        this.stringLengthOverridden = true;
    }

    public void unsetLengthOverride() {
        this.stringLengthOverridden = false;
    }

    public int getLength() {
        return this.text.length();
    }

    public int getPsychologicalLength() {
        if (this.stringLengthOverridden) {
            return this.manuallySetLength;
        }
        return this.text.length();
    }

    public boolean hasPreceedingWord() {
        return this.preceedingWord != null;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public void setFrequency(double frequency) {
        this.frequency = frequency;
    }

    public void setFrequency(Double frequencyObject) {
        this.frequency = frequencyObject;
    }

    public Word getPreceedingWord() {
        return this.preceedingWord;
    }

    public void setPreceedingWord(Word preceedingWord) {
        this.preceedingWord = preceedingWord;
    }

    public double getPredictabilityFromPreceedingWord() {
        return this.predictabilityFromPreceedingWord;
    }

    public void setPredictabilityFromPreceedingWord(double predictabilityFromPreceedingWord) {
        this.predictabilityFromPreceedingWord = predictabilityFromPreceedingWord;
    }

    public void setPredictabilityFromPreceedingWord(Double predictabilityFromPreceedingWordObject) {
        this.predictabilityFromPreceedingWord = predictabilityFromPreceedingWordObject;
    }

    public int getIdentificationTime() {
        return this.identificationTime;
    }

    public void setIdentificationTime(int identificationTime) {
        this.identificationTime = identificationTime;
    }
}

