/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import net.pakl.rl.Action;
import net.pakl.rl.State;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.ReadingStateFactory;
import org.eyelanguage.rl.reading.ReadingStateParallelRelative;
import org.eyelanguage.rl.reading.SentenceWorld;
import org.eyelanguage.rl.reading.Word;

public class SentenceWorldParallel
extends SentenceWorld {
    private static final String VERSION = "20060130-1029";
    static final long serialVersionUID = -7282356923040031291L;
    public static int PARALLEL_ATTENDABLE_WORDS = 4;
    public static int CENTER_OF_ATTENTION = 1;
    public static int MAX_WORDS_IN_SENTENCE = 10;
    public static int TIME_GRANULARITY = 5;
    public static boolean UNIFORM_ATTENTION = true;
    public static boolean LINEAR_ATTENTION_GRADIENT = false;
    public static boolean DIVIDED_ATTENTION = false;
    public static boolean LEXICAL_PROCESSING_RIGHTAFTER_ATTN_SHIFT = true;
    public boolean PARALLEL_ATTENTION_ALWAYS_POSITIVE = false;
    private boolean EXHAUSTIVE_MODE = true;

    public SentenceWorldParallel() {
        super("parallel", 1L);
        System.out.println("SentenceWorldParallel VERSION 20060130-1029");
        this.setupReadingStateFactory(ReadingStateFactory.RELATIVE_PARALLEL_READING_STATES);
    }

    public SentenceWorldParallel(String name, long seed) {
        super(name, seed);
        System.out.println("SentenceWorldParallel VERSION 20060130-1029");
        this.setupReadingStateFactory(ReadingStateFactory.RELATIVE_PARALLEL_READING_STATES);
    }

    private boolean saccadicEyeMovementJustOccured(ReadingState oldState, ReadingState newState) {
        return oldState.isProgrammingSaccade() && !newState.isProgrammingSaccade();
    }

    public State getNewState(State oldGenericState, Action genericAction) {
        throw new RuntimeException("Not yet implemented.");
    }

    private void addSaccadicTimePenaltyToParallelAttendance(ReadingStateParallelRelative newState) {
        for (int i = 0; i < PARALLEL_ATTENDABLE_WORDS; ++i) {
            newState.setParallelTimeAttended(i, newState.getParallelTimeAttended(i) + this.SACCADE_TIME_PENALTY);
        }
    }

    public void applyAcuityAdjustmentsParallel(ReadingStateParallelRelative previousState, ReadingStateParallelRelative newState) {
        int[] adjustments = this.acuityAdjustmentParallel(previousState.getEyePosition(), newState);
        for (int i = 0; i < PARALLEL_ATTENDABLE_WORDS; ++i) {
            int newAttendedTime = newState.getParallelTimeAttended(i) + adjustments[i];
            newState.setParallelTimeAttended(i, newAttendedTime);
        }
    }

    public static void main(String[] args) {
    }

    public int[] acuityAdjustmentParallel(int previousEyePosition, ReadingStateParallelRelative currentState) {
        throw new RuntimeException("Not yet implemented.");
    }

    public ReadingState attendCurrentWord(ReadingState newState) {
        newState.setDistanceFromAttendCenter(this.calculateDistFromAttendedWordCenter(newState));
        return this.setWordLengths(newState);
    }

    private ReadingStateParallelRelative setWordLengths(ReadingState newStateX) {
        throw new RuntimeException("Not yet implemented.");
    }

    public void performParallelLexicalProcessing(ReadingStateParallelRelative newState) {
        throw new RuntimeException("Not yet implemented.");
    }

    public boolean isTerminalState(State state) {
        ReadingStateParallelRelative s = (ReadingStateParallelRelative)state;
        int finalWordID = this.getNumWords() - 1;
        for (int i = 0; i < PARALLEL_ATTENDABLE_WORDS; ++i) {
            int finalWordSlot;
            if (s.getBeginningOfAttWindow() + i != finalWordID || !s.attWindowIdentified[finalWordSlot = i]) continue;
            for (int goingBackwards = finalWordSlot; goingBackwards >= 0; --goingBackwards) {
                if (s.attWindowIdentified[goingBackwards]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public State getStartingState() {
        if (this.setStartingState != null) {
            return this.setStartingState;
        }
        ReadingState startingState = this.readingStateFactory.createNewReadingState();
        startingState.setAttendedWordID(0);
        startingState = this.attendCurrentWord(startingState);
        startingState.setTimeAttending(0);
        return startingState;
    }

    public ReadingState checkForWordIdentification(ReadingState state) {
        return state;
    }

    public ReadingState checkForWordIdentificationParallel(ReadingState state) {
        throw new RuntimeException("Not yet implemented.");
    }

    public int calculateDistFromAttendedWordCenter(ReadingState state) {
        ReadingStateParallelRelative s = (ReadingStateParallelRelative)state;
        Word centerOfAttention = this.getWord(s.getCenterOfAttentionID());
        List<Integer> eyePositions = this.getPossibleEyePositions(centerOfAttention);
        int center = eyePositions.get((eyePositions.size() - 1) / 2);
        return state.getEyePosition() - center;
    }

    protected void attemptAttendNextWord(ReadingState newState) {
        ReadingStateParallelRelative result = (ReadingStateParallelRelative)newState;
        while (!this.isTerminalState(result) && result.leftMostAttendedWordIsIdentified() && result.getCenterOfAttentionID() + 1 < this.getNumWords()) {
            super.attemptAttendNextWord(result);
            this.advanceAttentionWindow(result);
            result.setDistanceFromAttendCenter(this.calculateDistFromAttendedWordCenter(result));
        }
    }

    public void advanceAttentionWindow(ReadingStateParallelRelative newState) {
        throw new RuntimeException("Not yet implemented.");
    }

    public Iterator stateIterator() {
        ParallelStateIteratorIndividualist result = new ParallelStateIteratorIndividualist(this);
        return result;
    }

    public static int roundTo(int value, int roundToNearest) {
        return (int)SentenceWorldParallel.roundTo((double)value, (double)roundToNearest);
    }

    public static double roundTo(double value, double roundToNearest) {
        return (double)Math.round(value * (1.0 / roundToNearest)) / (1.0 / roundToNearest);
    }

    public void setPARALLEL_ATTENDABLE_WORDS(int newPARALLEL_ATTENDABLE_WORDS) {
        PARALLEL_ATTENDABLE_WORDS = newPARALLEL_ATTENDABLE_WORDS;
    }

    public int getPARALLEL_ATTENDABLE_WORDS() {
        return PARALLEL_ATTENDABLE_WORDS;
    }

    public void setCENTER_OF_ATTENTION(int newCENTER_OF_ATTENTION) {
        CENTER_OF_ATTENTION = newCENTER_OF_ATTENTION;
    }

    public int getCENTER_OF_ATTENTION() {
        return CENTER_OF_ATTENTION;
    }

    public String getSettings() {
        String result = super.getSettings();
        result = result + "\nParallel Attention Settings:";
        result = result + "\n----------------------------";
        result = result + "\nUNIFORM_ATTENTION = " + UNIFORM_ATTENTION;
        result = result + "\nLINEAR_ATTENTION_GRADIENT = " + LINEAR_ATTENTION_GRADIENT;
        result = result + "\nDIVIDED_ATTENTION = " + DIVIDED_ATTENTION;
        return result;
    }

    class ParallelStateIteratorIndividualist
    extends Thread
    implements Iterator,
    Serializable {
        private boolean running = true;
        private ArrayBlockingQueue boundedBuffer = null;
        private boolean ceaseRunning = false;
        volatile boolean deliveredLast = false;
        volatile Object nextToReturn = null;
        volatile Object LAST_OBJECT_MARKER = new ReadingState();
        SentenceWorldParallel sentenceWorld = null;

        public synchronized void emptyBuffer() {
            while (this.boundedBuffer.size() > 0) {
                ReadingState readingState = (ReadingState)this.next();
            }
        }

        public boolean hasNext() {
            if (this.deliveredLast) {
                return false;
            }
            if (this.nextToReturn == null) {
                try {
                    this.nextToReturn = this.boundedBuffer.take();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            if (this.nextToReturn == this.LAST_OBJECT_MARKER) {
                this.deliveredLast = true;
                return false;
            }
            return true;
        }

        public ParallelStateIteratorIndividualist(SentenceWorldParallel parent) {
            this.sentenceWorld = parent;
            this.boundedBuffer = new ArrayBlockingQueue(SentenceWorldParallel.this.boundedBufferSize);
            this.setDaemon(true);
            this.start();
        }

        public synchronized Object next() {
            Object returned = this.nextToReturn;
            this.nextToReturn = null;
            return returned;
        }

        public void run() {
            try {
                this.running = true;
                this.loadInNext();
                this.running = false;
                this.ceaseRunning = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }

        public void performParallelLexicalProcessingUntil(ReadingStateParallelRelative s, int focusedWord, int timeAttended) {
            while (s.attWindowTimes[focusedWord] < timeAttended) {
                SentenceWorldParallel.this.performParallelLexicalProcessing(s);
            }
        }

        public void loadInNext() {
            throw new RuntimeException("Not yet implemented.");
        }

        public void remove() {
        }
    }
}

