/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.concurrent.ArrayBlockingQueue;
import net.pakl.rl.Action;
import net.pakl.rl.RandomPerThread;
import net.pakl.rl.State;
import net.pakl.rl.World;
import org.eyelanguage.rl.reading.ReadingAction;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.ReadingStateFactory;
import org.eyelanguage.rl.reading.ReadingStateParallelRelative;
import org.eyelanguage.rl.reading.ReadingStateRelative;
import org.eyelanguage.rl.reading.Word;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceWorld
implements World,
Serializable {
    static final long serialVersionUID = -4499055574151223530L;
    RandomPerThread randomSourcePerThread = new RandomPerThread();
    public int ACUITY_LIMIT = 1000;
    public int ATTEND_INTERVAL = 5;
    public boolean ACUITY_LINEAR_PENALIZE = true;
    public int ACUITY_LINEAR_PENALTY_SLOPE = this.ATTEND_INTERVAL;
    public int SACCADE_PROGRAM_INTERVAL = 5;
    public int MAX_POSSIBLE_ID_TIME = 50;
    public int MAX_SACCADE_PROG_TIME = 15;
    public int MAX_POSSIBLE_ACUITY_PENALTY = 0;
    public int MAX_POSSIBLE_ATTEND_TIME = this.MAX_POSSIBLE_ID_TIME + this.MAX_SACCADE_PROG_TIME;
    public int MAX_POSSIBLE_PENALTY = 0;
    public double SACCADIC_ERROR_SPREAD = 2.0;
    public int SACCADE_TIME_PENALTY = -5;
    public int MIN_ATTEND_TIME_WITH_PENALTIES;
    public int MAX_ATTEND_TIME_WITH_PENALTIES;
    public boolean SACCADIC_ERROR = false;
    protected int length;
    boolean isBuilt = false;
    protected String sentenceString = "";
    protected String name = "namelessWorld";
    ArrayList<Word> words = new ArrayList();
    public boolean CACHE_ENABLED = false;
    public boolean SACCADIC_ERROR_GAUSSIAN = true;
    public ReadingStateParallelRelative setStartingState = null;
    ReadingStateFactory readingStateFactory = null;
    int numStates;
    int bound_maxDistanceFromAttendCenter = -2147483647;
    int bound_minDistanceFromAttendCenter = Integer.MAX_VALUE;
    String requester;
    protected HashSet terminalStatesCache = null;
    boolean starvedBoolean = false;
    int boundedBufferSize = 10000;
    HashMap eyePositionCache = new HashMap();

    protected int minOf(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }

    protected int maxOf(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public void growBounds(State state) {
        ReadingState rs = (ReadingState)state;
        if (rs.getDistanceFromAttendCenter() > this.bound_maxDistanceFromAttendCenter) {
            this.bound_maxDistanceFromAttendCenter = rs.getDistanceFromAttendCenter();
        }
        if (rs.getDistanceFromAttendCenter() < this.bound_minDistanceFromAttendCenter) {
            this.bound_minDistanceFromAttendCenter = rs.getDistanceFromAttendCenter();
        }
    }

    public static void main(String[] args) {
        SentenceWorld w = new SentenceWorld("test", 1L);
        w.setSentence("123456789", "0.1 0.1", "20 20");
        ReadingState s1 = new ReadingState();
        ReadingState s2 = new ReadingState();
        ReadingState s3 = new ReadingState();
        s1.setTimeAttending(10);
        s2.setTimeAttending(10);
        s3.setTimeAttending(10);
        s1.setAttendedWordLen(9);
        s2.setAttendedWordLen(9);
        s3.setAttendedWordLen(9);
        s1.setDistanceFromAttendCenter(5);
        s3.setDistanceFromAttendCenter(5);
        s2.setDistanceFromAttendCenter(0);
        System.out.println("s1: " + s1);
        System.out.println("s2: " + s2);
        System.out.println("s3: " + s3);
        System.out.println("Adjustment from s1 to s2: " + w.acuityAdjustment(s1, s2));
        System.out.println("Adjustment from s2 to s3: " + w.acuityAdjustment(s2, s3));
        System.out.println("Adjustment from s1 to s3: " + w.acuityAdjustment(s1, s3));
        System.out.println("Adjustment from s3 to s2: " + w.acuityAdjustment(s3, s2));
        System.out.println("Adjustment from s2 to s1: " + w.acuityAdjustment(s2, s1));
    }

    public int acuityAdjustment(ReadingState previousState, ReadingState newState) {
        Word attendedWord = this.getWord(previousState.getAttendedWordID());
        double foveatedCenterIDTime = attendedWord.getIdentificationTime();
        double preSaccadeIDTime = this.totalIdentificationTimePlusAcuityEffect(attendedWord, previousState.getEyePosition());
        double postSaccadeIDTime = this.totalIdentificationTimePlusAcuityEffect(attendedWord, newState.getEyePosition());
        double timeAlreadySpent = newState.getTimeAttending();
        double preSaccadeTimeWasWorth = foveatedCenterIDTime / preSaccadeIDTime * timeAlreadySpent;
        double postSaccadeTimeIsWorth = postSaccadeIDTime / foveatedCenterIDTime * preSaccadeTimeWasWorth;
        postSaccadeTimeIsWorth /= (double)this.ATTEND_INTERVAL;
        postSaccadeTimeIsWorth = Math.floor(postSaccadeTimeIsWorth);
        int adjustBy = -1 * (int)(timeAlreadySpent - (postSaccadeTimeIsWorth *= (double)this.ATTEND_INTERVAL));
        return adjustBy;
    }

    public int calculateDistFromAttendedWordCenter(ReadingState state) {
        Word attendedWord = this.getWord(state.getAttendedWordID());
        List<Integer> eyePositions = this.getPossibleEyePositions(attendedWord);
        int center = eyePositions.get((eyePositions.size() - 1) / 2);
        return state.getEyePosition() - center;
    }

    protected int totalIdentificationTimePlusAcuityEffect(int wid, int fromEyePosition) {
        return this.totalIdentificationTimePlusAcuityEffect(this.getWord(wid), fromEyePosition);
    }

    protected int totalIdentificationTimePlusAcuityEffect(Word w, int fromEyePosition) {
        int result = w.getIdentificationTime() - this.acuityIdentificationPenalty(w, fromEyePosition);
        return result;
    }

    public int getCenterOfWord(Word w) {
        int centerOfW = -1;
        for (int i = 0; i < w.getID(); ++i) {
            centerOfW = 1 + centerOfW + this.getWord(i).getLength();
        }
        return 1 + centerOfW + (int)((double)w.getLength() / 2.0);
    }

    public int getCenterOfWord(int wid) {
        return this.getCenterOfWord(this.getWord(wid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequester(String r) {
        SentenceWorld sentenceWorld = this;
        synchronized (sentenceWorld) {
            this.requester = r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getNewState(State oldGenericState, Action genericAction, String r) {
        SentenceWorld sentenceWorld = this;
        synchronized (sentenceWorld) {
            this.requester = r;
            State result = this.getNewState(oldGenericState, genericAction);
            this.requester = "requester";
            return result;
        }
    }

    @Override
    public State getNewState(State oldGenericState, Action genericAction) {
        ReadingState oldState = (ReadingState)oldGenericState;
        ReadingAction readingAction = (ReadingAction)genericAction;
        if (readingAction.isRemainHere()) {
            ReadingState newState = this.readingStateFactory.createNewReadingState(oldState);
            return newState;
        }
        if (this.isTerminalState(oldState)) {
            ReadingState newState = this.readingStateFactory.createNewReadingState(oldState);
            return newState;
        }
        ReadingState newState = this.readingStateFactory.createNewReadingState(oldState);
        if (readingAction.isAttendNextWord()) {
            try {
                this.attemptAttendNextWord(newState);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                System.err.println("Action was " + readingAction);
                throw e;
            }
        }
        if (newState.isProgrammingSaccade()) {
            if (newState.getTimeInProgrammingSaccade() >= this.MAX_SACCADE_PROG_TIME) {
                newState = this.executeSaccade(newState);
            } else {
                newState.setTimeInProgrammingSaccade(this.SACCADE_PROGRAM_INTERVAL + newState.getTimeInProgrammingSaccade());
            }
        }
        if (readingAction.isRequestingSaccade()) {
            newState.setProgrammingSaccade(true);
            newState.setTimeInProgrammingSaccade(0);
            newState.setSaccadeRequestDistance(readingAction.getSaccadeRequestDistance());
        }
        newState = this.checkForAcuityLimit(newState);
        if (oldState.isProgrammingSaccade() && !newState.isProgrammingSaccade()) {
            newState.setTimeAttending(newState.getTimeAttending() + this.acuityAdjustment(oldState, newState));
            if (!readingAction.isAttendNextWord()) {
                newState.setTimeAttending(this.SACCADE_TIME_PENALTY + newState.getTimeAttending());
            }
            if (newState.getTimeAttending() < this.MIN_ATTEND_TIME_WITH_PENALTIES) {
                newState.setTimeAttending(this.MIN_ATTEND_TIME_WITH_PENALTIES);
            }
            if (newState.getTimeAttending() >= this.MAX_ATTEND_TIME_WITH_PENALTIES) {
                newState.setTimeAttending(this.MAX_ATTEND_TIME_WITH_PENALTIES - this.ATTEND_INTERVAL);
            }
        }
        if (readingAction.isAttendThisWord()) {
            newState = this.attendCurrentWord(newState);
        }
        newState = this.checkForWordIdentification(newState);
        return newState;
    }

    public ReadingState checkForAcuityLimit(ReadingState newState) {
        if (newState.getDistanceFromAttendCenter() > this.ACUITY_LIMIT) {
            int overshoot = newState.getDistanceFromAttendCenter() - this.ACUITY_LIMIT;
            newState.setEyePosition(newState.getEyePosition() - overshoot);
            newState.setFixatedWordID(this.getWordAtEyePosition(newState.getEyePosition()).getID());
            newState.setDistanceFromAttendCenter(newState.getDistanceFromAttendCenter() - overshoot);
        }
        if (newState.getDistanceFromAttendCenter() < -this.ACUITY_LIMIT) {
            int undershoot = Math.abs(Math.abs(newState.getDistanceFromAttendCenter()) - this.ACUITY_LIMIT);
            newState.setEyePosition(newState.getEyePosition() + undershoot);
            newState.setFixatedWordID(this.getWordAtEyePosition(newState.getEyePosition()).getID());
            newState.setDistanceFromAttendCenter(newState.getDistanceFromAttendCenter() + undershoot);
        }
        return newState;
    }

    public int applySaccadicError(int saccadeRequestDistance) {
        long result = 0L;
        double zForHalf = 0.3829;
        double zForOneAndHalf = 0.8664;
        Random random = (Random)this.randomSourcePerThread.get();
        double x = random.nextDouble();
        if (this.SACCADIC_ERROR_GAUSSIAN) {
            if (x <= zForHalf) {
                result = saccadeRequestDistance;
            } else if (x <= zForHalf + 0.5 * (zForOneAndHalf - zForHalf)) {
                result = saccadeRequestDistance - 1;
            } else if (x <= zForHalf + 1.0 * (zForOneAndHalf - zForHalf)) {
                result = saccadeRequestDistance + 1;
            } else if (x <= zForOneAndHalf + 0.5 * (1.0 - zForOneAndHalf)) {
                result = saccadeRequestDistance - 2;
            } else if (x <= zForOneAndHalf + 1.0 * (1.0 - zForOneAndHalf)) {
                result = saccadeRequestDistance + 2;
            }
        } else {
            x -= 0.5;
            x = x * 2.0 * (this.SACCADIC_ERROR_SPREAD + 0.5);
            result = Math.round((double)saccadeRequestDistance + x);
        }
        return (int)result;
    }

    protected ReadingState executeSaccade(ReadingState oldState) {
        ReadingState newState = this.readingStateFactory.createNewReadingState();
        newState.copyFrom(oldState);
        newState.setProgrammingSaccade(false);
        newState.setTimeInProgrammingSaccade(0);
        int newEyePosition = 0;
        newEyePosition = !this.SACCADIC_ERROR ? newState.getSaccadeRequestDistance() + newState.getEyePosition() : this.applySaccadicError(newState.getSaccadeRequestDistance()) + oldState.getEyePosition();
        if (newEyePosition < 0) {
            newEyePosition = 0;
        }
        if (newEyePosition >= this.getSentenceLength()) {
            newEyePosition = this.getSentenceLength() - 1;
        }
        newState.setEyePosition(newEyePosition);
        newState.setFixatedWordID(this.getWordAtEyePosition(newState.getEyePosition()).getID());
        newState.setSaccadeRequestDistance(0);
        newState.setDistanceFromAttendCenter(this.calculateDistFromAttendedWordCenter(newState));
        return newState;
    }

    public ReadingState checkForWordIdentification(ReadingState newState) {
        int attWordID = newState.getAttendedWordID();
        Word currentWord = this.getWord(attWordID);
        int wordIdTime = this.totalIdentificationTimePlusAcuityEffect(currentWord, newState.getEyePosition());
        int actualWordIdTime = this.minOf(this.MAX_ATTEND_TIME_WITH_PENALTIES, wordIdTime);
        if (newState.getTimeAttending() >= actualWordIdTime) {
            newState.setIdentified(true);
        } else {
            newState.setIdentified(false);
        }
        return newState;
    }

    public ReadingState attendCurrentWord(ReadingState newState) {
        newState.setTimeAttending(this.ATTEND_INTERVAL + newState.getTimeAttending());
        newState.setDistanceFromAttendCenter(this.calculateDistFromAttendedWordCenter(newState));
        int attWordID = newState.getAttendedWordID();
        Word currentWord = this.getWord(attWordID);
        newState.setAttendedWordLen(currentWord.getPsychologicalLength());
        newState.setAttendedWordPredictability(currentWord.getPredictabilityFromPreceedingWord());
        newState.setPreviousWordLen(this.getWordLengthOrZero(attWordID - 1));
        newState.setNextWordLen(this.getWordLengthOrZero(attWordID + 1));
        newState.setNextNextWordLen(this.getWordLengthOrZero(attWordID + 2));
        newState.setPreviousWordPredictability(this.getWordPredictabilityOrZero(attWordID - 1));
        newState.setNextWordPredictability(this.getWordPredictabilityOrZero(attWordID + 1));
        newState.setNextNextWordPredictability(this.getWordPredictabilityOrZero(attWordID + 2));
        return newState;
    }

    protected int getWordLengthOrZero(int id) {
        if (id < 0 || id >= this.getNumWords()) {
            return 0;
        }
        return this.getWord(id).getPsychologicalLength();
    }

    protected double getWordPredictabilityOrZero(int id) {
        return 0.0;
    }

    protected void attemptAttendNextWord(ReadingState newState) {
        if (1 + newState.getAttendedWordID() >= this.getNumWords()) {
            throw new RuntimeException("Error: Tried to attend word beyond end of sentence from a non-terminal state.  Shouldn't there have been a REMAIN action from that state?\n Original State was " + newState);
        }
        Word currentWord = this.getWord(1 + newState.getAttendedWordID());
        newState.setAttendedWordID(currentWord.getID());
        newState.setAttendedWordLen(currentWord.getPsychologicalLength());
        newState.setAttendedWordPredictability(currentWord.getPredictabilityFromPreceedingWord());
        newState.setPreviousWordLen(this.getWordLengthOrZero(currentWord.getID() - 1));
        newState.setNextWordLen(this.getWordLengthOrZero(currentWord.getID() + 1));
        newState.setNextNextWordLen(this.getWordLengthOrZero(currentWord.getID() + 2));
        newState.setPreviousWordPredictability(this.getWordPredictabilityOrZero(currentWord.getID() - 1));
        newState.setNextWordPredictability(this.getWordPredictabilityOrZero(currentWord.getID() + 1));
        newState.setNextNextWordPredictability(this.getWordPredictabilityOrZero(currentWord.getID() + 2));
        newState.setTimeAttending(0);
        newState.setIdentified(false);
        newState.setDistanceFromAttendCenter(this.calculateDistFromAttendedWordCenter(newState));
    }

    public ReadingState getNewState(ReadingState rs, ReadingAction ra) {
        return (ReadingState)this.getNewState((State)rs, (Action)ra);
    }

    public int distance(State state1, State state2) {
        ReadingState rs1 = (ReadingState)state1;
        ReadingState rs2 = (ReadingState)state2;
        return Math.abs(rs2.getEyePosition() - rs1.getEyePosition());
    }

    public int getSentenceLength() {
        return this.sentenceString.length();
    }

    public void setSentence(String newSentenceString, String predictabilities, String minIDTimes) {
        this.setSentence(newSentenceString, predictabilities, minIDTimes, "", false);
    }

    public void setSentence(String newSentenceString, String predictabilities, String minIDTimes, String lengths, boolean lengthsManuallyOverridden) {
        this.sentenceString = newSentenceString;
        if (this.sentenceString.charAt(this.sentenceString.length() - 1) != ' ') {
            System.out.println("Note: Appending space character at end of sentence automatically.");
            this.sentenceString = this.sentenceString + " ";
        }
        System.out.println("Sentence Length observed as " + this.getSentenceLength());
        Word preceedingWord = null;
        int wordCounter = 0;
        this.words = new ArrayList();
        StringTokenizer wordTokenizer = new StringTokenizer(this.sentenceString, " ", false);
        StringTokenizer predTokenizer = new StringTokenizer(predictabilities, " ", false);
        StringTokenizer timeTokenizer = new StringTokenizer(minIDTimes, " ", false);
        StringTokenizer lengthTokenizer = new StringTokenizer(lengths, " ", false);
        while (wordTokenizer.hasMoreTokens()) {
            Word thisWord = new Word();
            thisWord.setID(wordCounter);
            thisWord.setText(wordTokenizer.nextToken());
            try {
                thisWord.setIdentificationTime(new Integer(timeTokenizer.nextToken()));
            }
            catch (NoSuchElementException nse) {
                throw new NoSuchElementException("While processing word " + wordCounter + " could not find id time.\n" + this.sentenceString + "\n" + predictabilities + "\n" + minIDTimes);
            }
            if (lengthsManuallyOverridden) {
                thisWord.setLengthOverride(new Integer(lengthTokenizer.nextToken()));
            }
            thisWord.setPredictabilityFromPreceedingWord(new Double(predTokenizer.nextToken()));
            thisWord.setPreceedingWord(preceedingWord);
            if (thisWord.getIdentificationTime() > this.MAX_POSSIBLE_ID_TIME) {
                this.MAX_POSSIBLE_ID_TIME = thisWord.getIdentificationTime();
            }
            this.words.add(thisWord);
            preceedingWord = thisWord;
            ++wordCounter;
        }
        this.MAX_POSSIBLE_ATTEND_TIME = this.MAX_POSSIBLE_ID_TIME + this.MAX_SACCADE_PROG_TIME;
        this.MAX_POSSIBLE_ACUITY_PENALTY = this.acuityIdentificationPenaltyAbsolute(Math.abs(this.sentenceString.length()));
        System.out.println("ACUITY_LINEAR_PENALIZE = " + this.ACUITY_LINEAR_PENALIZE);
        System.out.println("Sentence length is " + this.sentenceString.length() + " so max acuity penalty is " + this.MAX_POSSIBLE_ACUITY_PENALTY);
        this.MAX_POSSIBLE_PENALTY = 0 + this.SACCADE_TIME_PENALTY + this.MAX_POSSIBLE_ACUITY_PENALTY;
        this.MIN_ATTEND_TIME_WITH_PENALTIES = 0 + this.MAX_POSSIBLE_PENALTY;
        this.MAX_ATTEND_TIME_WITH_PENALTIES = this.MAX_POSSIBLE_ATTEND_TIME + Math.abs(this.MAX_POSSIBLE_PENALTY);
        System.out.println(this.getSettings());
        if (this.isBuilt) {
            this.build();
        }
    }

    public int acuityIdentificationPenalty(int wid, int currentEyePosition) {
        return this.acuityIdentificationPenalty(this.getWord(wid), currentEyePosition);
    }

    public int acuityIdentificationPenalty(Word w, int currentEyePosition) {
        int centerOfW = this.getCenterOfWord(w);
        int distanceFromCenterOfW = Math.abs(currentEyePosition - centerOfW);
        return this.acuityIdentificationPenaltyAbsolute(distanceFromCenterOfW);
    }

    public int acuityIdentificationPenaltyAbsolute(int absoluteDistanceInCharacters) {
        if (this.ACUITY_LINEAR_PENALIZE) {
            return -1 * this.ACUITY_LINEAR_PENALTY_SLOPE * absoluteDistanceInCharacters;
        }
        if (absoluteDistanceInCharacters > 0) {
            return -2 * this.ATTEND_INTERVAL;
        }
        return 0;
    }

    @Override
    public boolean isTerminalState(State state) {
        ReadingState readingState = (ReadingState)state;
        return readingState.isIdentified() && readingState.getAttendedWordID() == this.getNumWords() - 1;
    }

    public int getNumberOfPositions() {
        return this.numStates;
    }

    public HashSet getTerminalStates() {
        throw new RuntimeException("No Terminal States list is needed, just inquire using isTerminalState().");
    }

    public HashSet getTerminalStates_notUsed() {
        if (this.terminalStatesCache == null) {
            System.err.println("SentenceWorld " + this.getName() + ": Finding terminal states");
            HashSet<ReadingStateRelative> result = new HashSet<ReadingStateRelative>();
            int lastWordID = this.getNumWords() - 1;
            this.requester = "terminalStates";
            int visitedCount = 0;
            Iterator i = this.stateIterator();
            while (i.hasNext()) {
                ReadingState r;
                ++visitedCount;
                ReadingState rs = (ReadingState)i.next();
                if (!rs.isIdentified() || rs.getAttendedWordID() != lastWordID) continue;
                if (rs instanceof ReadingStateRelative) {
                    r = new ReadingStateRelative((ReadingStateRelative)rs);
                    result.add((ReadingStateRelative)r);
                } else if (rs instanceof ReadingStateParallelRelative) {
                    r = new ReadingStateParallelRelative((ReadingStateParallelRelative)rs);
                    result.add((ReadingStateRelative)r);
                }
                if (!(rs instanceof ReadingState)) continue;
                r = new ReadingState(rs);
                result.add((ReadingStateRelative)r);
            }
            System.err.println("SentenceWorld " + this.getName() + ": Finding terminal states. DONE.");
            this.terminalStatesCache = result;
            return result;
        }
        System.err.println("SentenceWorld " + this.getName() + ": Finding terminal states [used cache]");
        return this.terminalStatesCache;
    }

    public List getDeadendStates() {
        System.err.println("SentenceWorld " + this.getName() + ": Finding dead-end states");
        ArrayList<ReadingState> result = new ArrayList<ReadingState>();
        Iterator i = this.stateIterator();
        while (i.hasNext()) {
            ReadingState rs = (ReadingState)i.next();
            if (rs.getTimeAttending() != this.MAX_ATTEND_TIME_WITH_PENALTIES) continue;
            result.add(rs);
        }
        System.err.println("SentenceWorld " + this.getName() + ": Finding dead-end states. DONE.");
        return result;
    }

    public void setupReadingStateFactory(int kind, boolean pooling) {
        this.readingStateFactory = new ReadingStateFactory(kind, pooling);
    }

    public void setupReadingStateFactory(int kind) {
        this.readingStateFactory = new ReadingStateFactory(kind);
    }

    @Override
    public void build() {
        System.err.println(this.getClass() + ": Counting up states...");
        long timerStart = System.currentTimeMillis();
        Iterator i = this.stateIterator();
        this.numStates = 0;
        while (i.hasNext()) {
            State s = (State)i.next();
            this.growBounds(s);
            ++this.numStates;
            if (this.numStates % 100000 != 0) continue;
            System.out.println(this.numStates + " states so far.\n" + s);
        }
        long timerElapsed = System.currentTimeMillis() - timerStart;
        System.out.println("SentenceWorld has " + this.numStates + " states");
        System.out.println("It took " + timerElapsed + " time to count up states, " + (double)timerElapsed / (double)this.numStates + "ms per state");
        this.isBuilt = true;
    }

    @Override
    public Iterator stateIterator() {
        StateIteratorIndividualist result = new StateIteratorIndividualist();
        return result;
    }

    public void setBoundedBufferSize(int n) {
        this.boundedBufferSize = n;
    }

    public List getAllStatesFromEyePosition(int eyePosition) {
        ArrayList<ReadingState> result = new ArrayList<ReadingState>();
        Iterator i = this.stateIterator();
        while (i.hasNext()) {
            ReadingState rs = (ReadingState)i.next();
            if (rs.getEyePosition() != eyePosition) continue;
            result.add(rs);
        }
        return result;
    }

    public boolean isOnWord(int eyePosition) {
        return this.sentenceString.charAt(eyePosition) != ' ';
    }

    public Word getWordAtEyePosition(int eyePosition) {
        for (int i = 0; i < this.words.size(); ++i) {
            Word w = this.words.get(i);
            ArrayList list = (ArrayList)this.getPossibleEyePositions(w);
            if (!this.getPossibleEyePositions(w).contains(new Integer(eyePosition))) continue;
            return w;
        }
        throw new RuntimeException("Landed on non-claimed space " + eyePosition + " eye position.  Policy/toolbox should have prevented this.");
    }

    public List getAllStatesWhereAttendingWordAt(int eyePosition) {
        Word wordAtEyePosition = this.getWordAtEyePosition(eyePosition);
        ArrayList<ReadingState> result = new ArrayList<ReadingState>();
        Iterator i = this.stateIterator();
        while (i.hasNext()) {
            ReadingState rs = (ReadingState)i.next();
            if (rs.getAttendedWordID() != wordAtEyePosition.getID()) continue;
            result.add(rs);
        }
        return result;
    }

    public List<Integer> getPossibleEyePositions(Word thisWord) {
        if (this.eyePositionCache.get(thisWord) == null) {
            ArrayList<Integer> result = new ArrayList<Integer>(thisWord.getLength());
            int start = 0;
            for (int i = 0; i < thisWord.getID(); ++i) {
                Word w = this.words.get(i);
                start = start + w.getLength() + 1;
            }
            int end = start + thisWord.getLength();
            if (end + 1 <= this.sentenceString.length()) {
                ++end;
            }
            for (int i = start; i < end; ++i) {
                result.add(new Integer(i));
            }
            this.eyePositionCache.put(thisWord, result);
            return result;
        }
        return (List)this.eyePositionCache.get(thisWord);
    }

    public List getPossibleEyePositionsSlow(Word thisWord) {
        int wordStart = 0;
        int previousWordLengthIncludingSpace = 0;
        Iterator<Word> wordIterator = this.words.iterator();
        Word candidateWord = wordIterator.next();
        int wordEnd = wordStart + candidateWord.getLength();
        if (thisWord.getID() != candidateWord.getID()) {
            while (wordIterator.hasNext()) {
                previousWordLengthIncludingSpace = candidateWord.getLength() + 1;
                candidateWord = wordIterator.next();
                wordEnd = (wordStart += previousWordLengthIncludingSpace) + candidateWord.getLength();
                if (candidateWord.getID() != thisWord.getID()) continue;
            }
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = wordStart; i <= wordEnd; ++i) {
            if (i >= this.sentenceString.length()) continue;
            result.add(new Integer(i));
        }
        return result;
    }

    public String getSettings() {
        String result = "";
        result = result + "\nATTEND_INTERVAL (steps thru state space time while attending)        : " + this.ATTEND_INTERVAL;
        result = result + "\nSACCADE_PROGRAM_INTERVAL (steps thru state space time while prg sacc): " + this.SACCADE_PROGRAM_INTERVAL;
        result = result + "\nSACCADE_TIME_PENALTY (ms of time for saccade, penalize attend time)  : " + this.SACCADE_TIME_PENALTY;
        result = result + "\nMAX_POSSIBLE_ACUITY_PENALTY = " + this.MAX_POSSIBLE_ACUITY_PENALTY;
        result = result + "\nMIN_ATTEND_TIME_WITH_PENALTIES (worst saccades could translate into negative time: " + this.MIN_ATTEND_TIME_WITH_PENALTIES;
        result = result + "\nMAX_SACCADE_PROG_TIME (maximum possible program time in saccade prog'ing) : " + this.MAX_SACCADE_PROG_TIME;
        result = result + "\nMAX_POSSIBLE_ATTEND_TIME (maximum possible attend time to consder in learning): " + this.MAX_POSSIBLE_ATTEND_TIME;
        result = result + "\nMAX_ATTEND_TIME_WITH_PENALTIES (including vis acuity penalities): " + this.MAX_ATTEND_TIME_WITH_PENALTIES;
        result = result + "\nATTEND TIME LIMITS RANGE FROM " + (0 + this.MAX_POSSIBLE_PENALTY) + "ms TO " + (this.MAX_POSSIBLE_ATTEND_TIME + Math.abs(this.MAX_POSSIBLE_PENALTY)) + "ms";
        result = result + "\nSACCADIC_ERROR = " + this.SACCADIC_ERROR;
        result = result + "\nACUITY_LIMIT = " + this.ACUITY_LIMIT;
        result = result + "\nSACCADIC_ERROR_GAUSSIAN = " + this.SACCADIC_ERROR_GAUSSIAN;
        return result;
    }

    @Override
    public String toText() {
        return this.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator i = this.stateIterator();
        while (i.hasNext()) {
            ReadingState s = (ReadingState)i.next();
            result.append(s.toString());
        }
        return result.toString();
    }

    public int getNumWords() {
        return this.words.size();
    }

    public Word getWord(int id) {
        return this.words.get(id);
    }

    public boolean isLastWordID(int wordID) {
        return wordID == this.getNumWords() - 1;
    }

    public SentenceWorld(String newName, long randomSeed) {
        this.name = newName;
        this.randomSourcePerThread.setRandomSeed(randomSeed);
    }

    public SentenceWorld(String newName) {
        this.name = newName;
        this.randomSourcePerThread.setRandomSeed(1111L);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean getIsBuilt() {
        return this.isBuilt;
    }

    public int getATTEND_INTERVAL() {
        return this.ATTEND_INTERVAL;
    }

    public void setATTEND_INTERVAL(int ATTEND_INTERVAL) {
        this.ATTEND_INTERVAL = ATTEND_INTERVAL;
    }

    public int getSACCADE_PROGRAM_INTERVAL() {
        return this.SACCADE_PROGRAM_INTERVAL;
    }

    public void setSACCADE_PROGRAM_INTERVAL(int SACCADE_PROGRAM_INTERVAL) {
        this.SACCADE_PROGRAM_INTERVAL = SACCADE_PROGRAM_INTERVAL;
    }

    public int getMAX_POSSIBLE_ID_TIME() {
        return this.MAX_POSSIBLE_ID_TIME;
    }

    public void setMAX_POSSIBLE_ID_TIME(int MAX_POSSIBLE_ID_TIME) {
        this.MAX_POSSIBLE_ID_TIME = MAX_POSSIBLE_ID_TIME;
    }

    public int getMAX_SACCADE_PROG_TIME() {
        return this.MAX_SACCADE_PROG_TIME;
    }

    public void setMAX_SACCADE_PROG_TIME(int MAX_SACCADE_PROG_TIME) {
        this.MAX_SACCADE_PROG_TIME = MAX_SACCADE_PROG_TIME;
    }

    public int getMAX_POSSIBLE_ATTEND_TIME() {
        return this.MAX_POSSIBLE_ATTEND_TIME;
    }

    public void setMAX_POSSIBLE_ATTEND_TIME(int MAX_POSSIBLE_ATTEND_TIME) {
        this.MAX_POSSIBLE_ATTEND_TIME = MAX_POSSIBLE_ATTEND_TIME;
    }

    public int getSACCADE_TIME_PENALTY() {
        return this.SACCADE_TIME_PENALTY;
    }

    public void setSACCADE_TIME_PENALTY(int SACCADE_TIME_PENALTY) {
        this.SACCADE_TIME_PENALTY = SACCADE_TIME_PENALTY;
    }

    public int getMIN_ATTEND_TIME_WITH_PENALTIES() {
        return this.MIN_ATTEND_TIME_WITH_PENALTIES;
    }

    public int getMAX_ATTEND_TIME_WITH_PENALTIES() {
        return this.MAX_ATTEND_TIME_WITH_PENALTIES;
    }

    @Override
    public int getNumberOfStates() {
        return this.numStates;
    }

    public ReadingStateFactory getStateFactory() {
        return this.readingStateFactory;
    }

    @Override
    public State getStartingState() {
        if (this.setStartingState != null) {
            return this.setStartingState;
        }
        ReadingState startingState = this.readingStateFactory.createNewReadingState();
        startingState.setAttendedWordID(0);
        startingState = this.attendCurrentWord(startingState);
        startingState.setTimeAttending(0);
        return startingState;
    }

    public State getRandomState() {
        throw new RuntimeException("getRandomState() is not implemented for sentence world due to large numbers of states... to be implemented soon.");
    }

    @Override
    public List getStateList() {
        throw new RuntimeException("getStateList() is not implemented for sentence world due to large numbers of states... to be implemented soon.");
    }

    public class StateIteratorIndividualist
    extends Thread
    implements Iterator,
    Serializable {
        private boolean running = true;
        private ArrayBlockingQueue boundedBuffer = null;
        private boolean ceaseRunning = false;
        volatile boolean deliveredLast = false;
        volatile Object nextToReturn = null;
        volatile Object LAST_OBJECT_MARKER = new ReadingState();

        public synchronized void emptyBuffer() {
            while (this.boundedBuffer.size() > 0) {
                ReadingState readingState = (ReadingState)this.next();
            }
        }

        public boolean hasNext() {
            if (this.deliveredLast) {
                return false;
            }
            if (this.nextToReturn == null) {
                try {
                    this.nextToReturn = this.boundedBuffer.take();
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            if (this.nextToReturn == this.LAST_OBJECT_MARKER) {
                this.deliveredLast = true;
                return false;
            }
            return true;
        }

        public StateIteratorIndividualist() {
            this.boundedBuffer = new ArrayBlockingQueue(SentenceWorld.this.boundedBufferSize);
            this.setDaemon(true);
            if (SentenceWorld.this.readingStateFactory == null) {
                SentenceWorld.this.readingStateFactory = new ReadingStateFactory();
            }
            this.start();
        }

        public synchronized Object next() {
            Object returned = this.nextToReturn;
            this.nextToReturn = null;
            return returned;
        }

        public void run() {
            try {
                this.running = true;
                this.loadInNext();
                this.running = false;
                this.ceaseRunning = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
        }

        public void loadInNext() {
            ReadingState tempPreservePrevious = SentenceWorld.this.readingStateFactory.createNewReadingState();
            try {
                for (int i1 = 0; i1 < SentenceWorld.this.words.size(); ++i1) {
                    Word fixatedWord = SentenceWorld.this.words.get(i1);
                    ArrayList possibleEyePositions = (ArrayList)SentenceWorld.this.getPossibleEyePositions(fixatedWord);
                    for (int i2 = 0; i2 < possibleEyePositions.size(); ++i2) {
                        Integer eyePosition = (Integer)possibleEyePositions.get(i2);
                        for (int i3 = 0; i3 < SentenceWorld.this.words.size(); ++i3) {
                            Word attendedWord = SentenceWorld.this.words.get(i3);
                            for (int timeAttended = SentenceWorld.this.MIN_ATTEND_TIME_WITH_PENALTIES; timeAttended <= SentenceWorld.this.MAX_ATTEND_TIME_WITH_PENALTIES; timeAttended += SentenceWorld.this.ATTEND_INTERVAL) {
                                ReadingState newStateAttending = SentenceWorld.this.readingStateFactory.createNewReadingState();
                                newStateAttending.setEyePosition(eyePosition);
                                newStateAttending.setAttendedWordID(attendedWord.getID());
                                newStateAttending.setAttendedWordLen(attendedWord.getPsychologicalLength());
                                newStateAttending.setAttendedWordPredictability(attendedWord.getPredictabilityFromPreceedingWord());
                                newStateAttending.setPreviousWordLen(SentenceWorld.this.getWordLengthOrZero(attendedWord.getID() - 1));
                                newStateAttending.setNextWordLen(SentenceWorld.this.getWordLengthOrZero(attendedWord.getID() + 1));
                                newStateAttending.setNextNextWordLen(SentenceWorld.this.getWordLengthOrZero(attendedWord.getID() + 2));
                                newStateAttending.setPreviousWordPredictability(SentenceWorld.this.getWordPredictabilityOrZero(attendedWord.getID() - 1));
                                newStateAttending.setNextWordPredictability(SentenceWorld.this.getWordPredictabilityOrZero(attendedWord.getID() + 1));
                                newStateAttending.setNextNextWordPredictability(SentenceWorld.this.getWordPredictabilityOrZero(attendedWord.getID() + 2));
                                newStateAttending.setFixatedWordID(fixatedWord.getID());
                                newStateAttending.setTimeAttending(timeAttended);
                                newStateAttending.setProgrammingSaccade(false);
                                newStateAttending.setIdentified(false);
                                newStateAttending.setDistanceFromAttendCenter(SentenceWorld.this.calculateDistFromAttendedWordCenter(newStateAttending));
                                if (newStateAttending.getTimeAttending() != SentenceWorld.this.MAX_ATTEND_TIME_WITH_PENALTIES && Math.abs(newStateAttending.getDistanceFromAttendCenter()) <= SentenceWorld.this.ACUITY_LIMIT) {
                                    newStateAttending = SentenceWorld.this.checkForWordIdentification(newStateAttending);
                                    this.boundedBuffer.put(newStateAttending);
                                }
                                tempPreservePrevious.copyFrom(newStateAttending);
                                if (this.ceaseRunning) {
                                    return;
                                }
                                for (int timeInSaccadicProg = 0; timeInSaccadicProg <= SentenceWorld.this.MAX_SACCADE_PROG_TIME; timeInSaccadicProg += SentenceWorld.this.SACCADE_PROGRAM_INTERVAL) {
                                    int maxBack = 10;
                                    int maxFwd = 10;
                                    int actualBack = maxBack;
                                    int actualFwd = maxFwd;
                                    if (eyePosition < maxBack) {
                                        actualBack = eyePosition;
                                    }
                                    if (SentenceWorld.this.getSentenceLength() - eyePosition <= maxFwd) {
                                        actualFwd = SentenceWorld.this.getSentenceLength() - eyePosition;
                                    }
                                    for (int saccRequestDistance = -actualBack; saccRequestDistance <= actualFwd; ++saccRequestDistance) {
                                        if (saccRequestDistance == 0 || newStateAttending.getTimeAttending() - timeInSaccadicProg < SentenceWorld.this.MIN_ATTEND_TIME_WITH_PENALTIES) continue;
                                        ReadingState newStateProgramming = SentenceWorld.this.readingStateFactory.createNewReadingState(tempPreservePrevious);
                                        newStateProgramming.setTimeInProgrammingSaccade(timeInSaccadicProg);
                                        newStateProgramming.setProgrammingSaccade(true);
                                        newStateProgramming.setIdentified(false);
                                        newStateProgramming.setSaccadeRequestDistance(saccRequestDistance);
                                        newStateProgramming.setDistanceFromAttendCenter(SentenceWorld.this.calculateDistFromAttendedWordCenter(newStateProgramming));
                                        tempPreservePrevious.copyFrom(newStateProgramming);
                                        if (newStateAttending.getTimeAttending() != SentenceWorld.this.MAX_ATTEND_TIME_WITH_PENALTIES && Math.abs(newStateProgramming.getDistanceFromAttendCenter()) <= SentenceWorld.this.ACUITY_LIMIT) {
                                            newStateProgramming = SentenceWorld.this.checkForWordIdentification(newStateProgramming);
                                            this.boundedBuffer.put(newStateProgramming);
                                        }
                                        if (!this.ceaseRunning) continue;
                                        return;
                                    }
                                }
                            }
                        }
                    }
                }
                this.boundedBuffer.put(this.LAST_OBJECT_MARKER);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                System.err.println("should not happen.");
                System.exit(1);
            }
        }

        public void remove() {
        }
    }
}

