/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.pakl.rl.HasVectorRepresentation;
import net.pakl.rl.SubdivisionIdentification;
import org.eyelanguage.rl.reading.ReadingState;

public class ReadingStateRelative
extends ReadingState
implements HasVectorRepresentation,
SubdivisionIdentification {
    static final long serialVersionUID = -7046034796366757136L;

    public ReadingStateRelative(ReadingStateRelative rs) {
        super(rs);
    }

    public ReadingStateRelative() {
    }

    public int hashCode() {
        if (this.isIdentified()) {
            return 1 + 10 * this.getDistanceFromAttendCenter() + 1000 * this.getTimeAttending() + 100000 * this.getSaccadeRequestDistance() + 10000000 * this.getTimeInProgrammingSaccade();
        }
        return 2 + 10 * this.getDistanceFromAttendCenter() + 1000 * this.getTimeAttending() + 100000 * this.getSaccadeRequestDistance() + 10000000 * this.getTimeInProgrammingSaccade();
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof ReadingStateRelative) {
            ReadingStateRelative otherState = (ReadingStateRelative)otherObject;
            if (otherState.isIdentified() != this.isIdentified()) {
                return false;
            }
            if (otherState.isProgrammingSaccade() != this.isProgrammingSaccade()) {
                return false;
            }
            if (otherState.getTimeAttending() != this.getTimeAttending()) {
                return false;
            }
            if (otherState.getTimeInProgrammingSaccade() != this.getTimeInProgrammingSaccade()) {
                return false;
            }
            if (otherState.getSaccadeRequestDistance() != this.getSaccadeRequestDistance()) {
                return false;
            }
            if (otherState.getAttendedWordLen() != this.getAttendedWordLen()) {
                return false;
            }
            if (otherState.getDistanceFromAttendCenter() != this.getDistanceFromAttendCenter()) {
                return false;
            }
            if (otherState.getPreviousWordLen() != this.getPreviousWordLen()) {
                return false;
            }
            return otherState.getNextWordLen() == this.getNextWordLen();
        }
        return false;
    }

    public double[] doubleRepresentation() {
        double[] result = new double[]{(double)(500 + this.getTimeAttending()) / 1000.0, (double)(50 + this.getDistanceFromAttendCenter()) / 100.0, (double)this.getTimeInProgrammingSaccade() / 20.0, (double)(10 + this.getSaccadeRequestDistance()) / 20.0, this.isProgrammingSaccade() ? 0.7 : 0.3, (double)this.getAttendedWordLen() / 9.0, (double)this.getPreviousWordLen() / 9.0, (double)this.getNextWordLen() / 9.0, this.isIdentified() ? 0.7 : 0.3, (double)Math.abs(this.getDistanceFromAttendCenter()) / 100.0};
        for (int i = 0; i < result.length; ++i) {
            if (result[i] < 0.0) {
                throw new RuntimeException("doublerepresentation index " + i + " was negative.");
            }
            if (!(result[i] > 1.0)) continue;
            throw new RuntimeException("doublerepresentation index " + i + " was > 1.");
        }
        return result;
    }

    public List binaryRepresentationIndices() {
        int[] b = this.binaryRepresentation();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < b.length; ++i) {
            if (b[i] != 1) continue;
            indices.add(i);
        }
        return indices;
    }

    public int[] binaryRepresentation() {
        int[] result = null;
        try {
            int[] a = ReadingStateRelative.representAsVector(this.getTimeAttending(), -250, 250, 5);
            int[] b = ReadingStateRelative.representAsVector(this.getDistanceFromAttendCenter(), -40, 40, 1);
            int[] c = ReadingStateRelative.representAsVector(this.getTimeInProgrammingSaccade(), 0, 25, 5);
            int[] d = ReadingStateRelative.representAsVector(this.getSaccadeRequestDistance(), -10, 10, 1);
            int[] e = ReadingStateRelative.representAsVector(this.getAttendedWordLen(), 1, 10, 1);
            int[] f = ReadingStateRelative.representAsVector(this.getPreviousWordLen(), 0, 10, 1);
            int[] g = ReadingStateRelative.representAsVector(this.getNextWordLen(), 0, 10, 1);
            int[] h = new int[2];
            if (this.isIdentified()) {
                h[0] = 1;
            } else {
                h[1] = 1;
            }
            result = ReadingStateRelative.concatenateArrays(a, b, c, d, e, f, g, h);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            e.printStackTrace();
            throw new RuntimeException("\n\n *** Bounds for vector representation are too\n     small for binary representation. See line\n     number of binaryRepresentation() call ABOVE ***\n\n");
        }
        return result;
    }

    public String toString() {
        return "STATEREL: [attDst=" + this.getDistanceFromAttendCenter() + ",attTIM=" + this.getTimeAttending() + ",sacPrg=" + this.isProgrammingSaccade() + ",sacPrgTIM=" + this.getTimeInProgrammingSaccade() + ",sacDst=" + this.getSaccadeRequestDistance() + ",ID'd?=" + this.isIdentified() + ",attlen=" + this.getAttendedWordLen() + ",prevlen=" + this.getPreviousWordLen() + ",nextlen=" + this.getNextWordLen() + ",fixWid=" + this.getFixatedWordID() + ",attWid=" + this.getAttendedWordID() + "] (eyepos=" + this.getEyePosition() + ")";
    }

    public void parseString(String s) {
        String t = s.replaceAll("\\[", "");
        t = t.replaceAll("\\]", "");
        t = t.replaceAll(" ", ",");
        t = t.replaceAll("\\(", ",");
        t = t.replaceAll("\\)", ",");
        StringTokenizer st = new StringTokenizer(t, ",", false);
        while (st.hasMoreTokens()) {
            StringTokenizer piece = new StringTokenizer(st.nextToken(), "=", false);
            String field = null;
            String value = null;
            if (piece.hasMoreTokens()) {
                field = piece.nextToken();
            }
            if (piece.hasMoreTokens()) {
                value = piece.nextToken();
            }
            if (field == null) continue;
            if (field.equals("attDst")) {
                this.setDistanceFromAttendCenter(this.intValue(value));
            }
            if (field.equals("attTIM")) {
                this.setTimeAttending(this.intValue(value));
            }
            if (field.equals("sacPrg")) {
                this.setProgrammingSaccade(this.boolValue(value));
            }
            if (field.equals("sacPrgTIM")) {
                this.setTimeInProgrammingSaccade(this.intValue(value));
            }
            if (field.equals("sacDst")) {
                this.setSaccadeRequestDistance(this.intValue(value));
            }
            if (field.equals("ID'd?")) {
                this.setIdentified(this.boolValue(value));
            }
            if (field.equals("pred")) {
                this.setAttendedWordPredictability(this.doubleValue(value));
            }
            if (field.equals("attlen")) {
                this.setAttendedWordLen(this.intValue(value));
            }
            if (field.equals("prevlen")) {
                this.setPreviousWordLen(this.intValue(value));
            }
            if (field.equals("nextlen")) {
                this.setNextWordLen(this.intValue(value));
            }
            if (field.equals("fixWid")) {
                this.setFixatedWordID(this.intValue(value));
            }
            if (field.equals("attWid")) {
                this.setAttendedWordID(this.intValue(value));
            }
            if (!field.equals("eyepos")) continue;
            this.setEyePosition(this.intValue(value));
        }
    }

    protected int intValue(String s) {
        return new Integer(s);
    }

    protected double doubleValue(String s) {
        return new Double(s);
    }

    protected boolean boolValue(String s) {
        return s.equalsIgnoreCase("true");
    }

    public boolean test() {
        ReadingStateRelative state1 = new ReadingStateRelative();
        String string1 = "STATEREL: [attDst=0,attTIM=-5,sacPrg=true,sacPrgTIM=10,sacDst=1,ID'd?=false,pred=0.1,attlen=1,prevlen=0,nextlen=3,fixWid=0,attWid=0] (eyepos=0)";
        state1.parseString(string1);
        String testString = state1.toString();
        if (!testString.equals(string1)) {
            System.out.println("[FAIL] Test failed: \noriginal:" + string1 + "\nreturned:" + testString);
        }
        System.out.println("[OK] ReadingStateRelative test complete.");
        return true;
    }

    public static void main(String[] args) {
        new ReadingStateRelative().test();
    }

    public String getPatchName() {
        return this.previousWordLen + "-" + this.attendedWordLen + "-" + this.nextWordLen;
    }
}

