/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.pakl.rl.SubdivisionIdentification;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.ReadingStateRelative;
import org.eyelanguage.rl.reading.SentenceWorldParallel;

public class ReadingStateParallelRelative
extends ReadingStateRelative
implements SubdivisionIdentification {
    static final long serialVersionUID = 8711529768299836928L;
    public static final boolean FORCE_ROUNDING_TO_GRANULARITY = false;
    public boolean[] attWindowIdentified = new boolean[SentenceWorldParallel.PARALLEL_ATTENDABLE_WORDS];
    public int[] attWindowWordIDs = new int[SentenceWorldParallel.PARALLEL_ATTENDABLE_WORDS];
    public int[] attWindowTimes = new int[SentenceWorldParallel.PARALLEL_ATTENDABLE_WORDS];
    public double[] attWindowPredictabilities = new double[SentenceWorldParallel.PARALLEL_ATTENDABLE_WORDS];
    public int[] attWindowLengths = new int[SentenceWorldParallel.PARALLEL_ATTENDABLE_WORDS];

    public boolean leftMostAttendedWordIsIdentified() {
        return this.attWindowIdentified[0];
    }

    public int getCenterOfAttentionID() {
        return this.attWindowWordIDs[SentenceWorldParallel.CENTER_OF_ATTENTION];
    }

    public boolean isIdentifiedInWindow(int index) {
        if (index < 0 || index > this.attWindowIdentified.length) {
            return true;
        }
        return this.attWindowIdentified[index];
    }

    public int getTimeAttending() {
        return this.attWindowTimes[0];
    }

    public void setTimeAttending(int timeAttending) {
    }

    public void setParallelTimeAttended(int i, int value) {
        this.attWindowTimes[i] = value;
    }

    public void incParallelTimeAttended(int i, int delta) {
        this.setParallelTimeAttended(i, this.getParallelTimeAttended(i) + delta);
    }

    public int getParallelTimeAttended(int i) {
        return this.attWindowTimes[i];
    }

    public void setAttendedWordID() {
    }

    public int getAttendedWordID() {
        return this.attWindowWordIDs[0];
    }

    public int getBeginningOfAttWindow() {
        return this.attWindowWordIDs[0];
    }

    public ReadingStateParallelRelative() {
    }

    public ReadingStateParallelRelative(ReadingStateParallelRelative s) {
        this.copyFrom(s);
    }

    public int getSumAttWindowTimes() {
        int sum = 0;
        for (int i = 0; i < this.attWindowTimes.length; ++i) {
            sum += this.attWindowTimes[i];
        }
        return sum;
    }

    public int getNumIdentified() {
        int sum = 0;
        for (int i = 0; i < this.attWindowIdentified.length; ++i) {
            if (!this.attWindowIdentified[i]) continue;
            ++sum;
        }
        return sum;
    }

    public boolean isIdentified() {
        return this.attWindowIdentified[0];
    }

    public void copyFrom(ReadingState s) {
        int i;
        ReadingStateParallelRelative toCopyFrom = (ReadingStateParallelRelative)s;
        this.setDistanceFromAttendCenter(toCopyFrom.getDistanceFromAttendCenter());
        this.setEyePosition(toCopyFrom.getEyePosition());
        this.setFixatedWordID(toCopyFrom.getFixatedWordID());
        this.setProgrammingSaccade(toCopyFrom.isProgrammingSaccade());
        this.setSaccadeRequestDistance(toCopyFrom.getSaccadeRequestDistance());
        this.setTimeInProgrammingSaccade(toCopyFrom.getTimeInProgrammingSaccade());
        this.setNextWordLen(toCopyFrom.getNextWordLen());
        this.setPreviousWordLen(toCopyFrom.getPreviousWordLen());
        for (i = 0; i < this.attWindowIdentified.length; ++i) {
            this.attWindowIdentified[i] = toCopyFrom.attWindowIdentified[i];
            this.attWindowWordIDs[i] = toCopyFrom.attWindowWordIDs[i];
            this.attWindowTimes[i] = toCopyFrom.attWindowTimes[i];
            this.attWindowPredictabilities[i] = toCopyFrom.attWindowPredictabilities[i];
        }
        for (i = 0; i < this.attWindowLengths.length; ++i) {
            this.attWindowLengths[i] = toCopyFrom.attWindowLengths[i];
        }
    }

    public int getAttendedWordLen() {
        return this.attWindowLengths[0];
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof ReadingStateParallelRelative) {
            int i;
            ReadingStateParallelRelative otherState = (ReadingStateParallelRelative)otherObject;
            if (otherState.isProgrammingSaccade() != this.isProgrammingSaccade()) {
                return false;
            }
            if (otherState.getTimeInProgrammingSaccade() != this.getTimeInProgrammingSaccade()) {
                return false;
            }
            if (otherState.getSaccadeRequestDistance() != this.getSaccadeRequestDistance()) {
                return false;
            }
            if (otherState.getDistanceFromAttendCenter() != this.getDistanceFromAttendCenter()) {
                return false;
            }
            for (i = 0; i < this.attWindowLengths.length; ++i) {
                if (this.attWindowLengths[i] == otherState.attWindowLengths[i]) continue;
                return false;
            }
            for (i = 0; i < this.attWindowIdentified.length; ++i) {
                if (this.attWindowIdentified[i] != otherState.attWindowIdentified[i]) {
                    return false;
                }
                if (this.attWindowTimes[i] == otherState.attWindowTimes[i]) continue;
                return false;
            }
            if (this.getNextWordLen() != otherState.getNextWordLen()) {
                return false;
            }
            return this.getPreviousWordLen() == otherState.getPreviousWordLen();
        }
        return false;
    }

    public static int roundTo(int value, int roundToNearest) {
        return (int)ReadingStateParallelRelative.roundTo((double)value, (double)roundToNearest);
    }

    public static double roundTo(double value, double roundToNearest) {
        return (double)Math.round(value * (1.0 / roundToNearest)) / (1.0 / roundToNearest);
    }

    public void roundToLinearAttentionGradient() {
        for (int i = 0; i < this.attWindowIdentified.length; ++i) {
            int wordIDToProcess = this.attWindowWordIDs[i];
            int granularity = 0;
            if (wordIDToProcess == this.getCenterOfAttentionID()) {
                granularity = 5;
            }
            if (Math.abs(wordIDToProcess - this.getCenterOfAttentionID()) == 1) {
                granularity = 3;
            }
            if (Math.abs(wordIDToProcess - this.getCenterOfAttentionID()) == 2) {
                granularity = 2;
            }
            if (Math.abs(wordIDToProcess - this.getCenterOfAttentionID()) == 3) {
                granularity = 1;
            }
            this.attWindowTimes[i] = ReadingStateParallelRelative.roundTo(this.attWindowTimes[i], granularity);
        }
    }

    public int hashCode() {
        if (this.identified) {
            return 1 + 10 * this.getDistanceFromAttendCenter() + 1000 * this.getTimeAttending() + 10000 * this.getSumAttWindowTimes() + 100000 * this.getSaccadeRequestDistance() + 10000000 * this.getTimeInProgrammingSaccade();
        }
        return 2 + 10 * this.getDistanceFromAttendCenter() + 1000 * this.getTimeAttending() + 10000 * this.getSumAttWindowTimes() + 100000 * this.getSaccadeRequestDistance() + 10000000 * this.getTimeInProgrammingSaccade();
    }

    public ReadingStateParallelRelative fromString(String s) {
        ArrayList<String> required = new ArrayList<String>();
        required.add("ecc");
        required.add("fixID");
        required.add("eyepos");
        required.add("sacPrg");
        required.add("sacReqDst");
        required.add("sacPrgTime");
        required.add("attIDs");
        required.add("attLens");
        required.add("attTimes");
        required.add("identified");
        StringTokenizer t = new StringTokenizer(s, ",");
        while (t.hasMoreTokens()) {
            StringTokenizer equality = new StringTokenizer(t.nextToken(), "=");
            String key = equality.nextToken();
            String value = equality.nextToken();
            required.remove(key);
            if (key.equals("ecc")) {
                this.setDistanceFromAttendCenter(new Integer(value));
            }
            if (key.equals("fixID")) {
                this.setFixatedWordID(new Integer(value));
            }
            if (key.equals("eyepos")) {
                this.setEyePosition(new Integer(value));
            }
            if (key.equals("sacPrg")) {
                if (value.equals("true")) {
                    this.setProgrammingSaccade(true);
                } else {
                    this.setProgrammingSaccade(false);
                }
            }
            if (key.equals("sacReqDst")) {
                this.setSaccadeRequestDistance(new Integer(value));
            }
            if (key.equals("sacPrgTime")) {
                this.setTimeInProgrammingSaccade(new Integer(value));
            }
            if (key.equals("attIDs")) {
                this.plop(this.attWindowWordIDs, value);
            }
            if (key.equals("attLens")) {
                this.plop(this.attWindowLengths, value);
            }
            if (key.equals("attTimes")) {
                this.plop(this.attWindowTimes, value);
            }
            if (!key.equals("identified")) continue;
            for (int i = 0; i < value.length(); ++i) {
                this.attWindowIdentified[i] = value.charAt(i) == 'x';
            }
        }
        if (!required.isEmpty()) {
            throw new RuntimeException("\nNot all keys were specified for instantiating a class from a string.\nRemaining keys: " + required);
        }
        System.out.println("State successfully instantiated from String: " + this.toString());
        return this;
    }

    private void plop(int[] array, String values) {
        StringTokenizer data = new StringTokenizer(values, "|");
        int slot = 0;
        while (data.hasMoreTokens()) {
            array[slot] = new Integer(data.nextToken());
            ++slot;
        }
    }

    public String toString() {
        int i;
        String result = "STATEPARREL: [ecc=" + this.getDistanceFromAttendCenter() + ",sacPrg=" + this.isProgrammingSaccade() + ",sacPrgTime=" + this.getTimeInProgrammingSaccade() + ",sacReqDst=" + this.getSaccadeRequestDistance() + ",attLens=";
        for (i = 0; i < this.attWindowLengths.length; ++i) {
            result = result + this.attWindowLengths[i] + "|";
        }
        result = result + ",attIDs=";
        for (i = 0; i < this.attWindowWordIDs.length; ++i) {
            result = result + this.attWindowWordIDs[i] + "|";
        }
        result = result + ",eyepos=" + this.getEyePosition() + ",fixID=" + this.getFixatedWordID() + ",startAttID=" + this.getBeginningOfAttWindow() + ",centerAttID=" + (this.getBeginningOfAttWindow() + SentenceWorldParallel.CENTER_OF_ATTENTION) + ",endAttWinID=" + (this.getBeginningOfAttWindow() + SentenceWorldParallel.PARALLEL_ATTENDABLE_WORDS - 1) + ",attTimes=";
        for (i = 0; i < this.attWindowTimes.length; ++i) {
            result = result + this.attWindowTimes[i] + "|";
        }
        result = result + ",identified=";
        for (i = 0; i < this.attWindowIdentified.length; ++i) {
            result = this.attWindowIdentified[i] ? result + "x" : result + "_";
        }
        result = result + "]";
        return result;
    }

    public String getPatchName() {
        String result = "";
        for (int i = 0; i < this.attWindowLengths.length; ++i) {
            result = result + this.attWindowLengths[i];
            if (i >= this.attWindowLengths.length - 1) continue;
            result = result + "-";
        }
        return result;
    }
}

