/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.io.Serializable;
import java.util.HashMap;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.ReadingStateParallelRelative;
import org.eyelanguage.rl.reading.ReadingStateRelative;

public class ReadingStateFactory
implements Serializable {
    public static int NORMAL_READING_STATES = 1001;
    public static int RELATIVE_READING_STATES = 1002;
    public static int RELATIVE_PARALLEL_READING_STATES = 1003;
    public int mode = NORMAL_READING_STATES;
    public int allocationCounter = 0;
    public static int GARBAGE_COLLECT_EVERY = 10000;
    Object[] pool;
    boolean[] inUse;
    int GROW_BY = 50;
    HashMap records = new HashMap();

    public void diag() {
        for (Object key : this.records.keySet()) {
            System.out.print(key + "=" + this.records.get(key) + " ");
        }
        System.out.println("");
    }

    public ReadingStateFactory(int kindOfStatesRequested, boolean pooling) {
        this(kindOfStatesRequested);
    }

    public ReadingStateFactory() {
    }

    public ReadingStateFactory(int kindOfStatesRequested) {
        this.mode = kindOfStatesRequested;
        if (this.mode == NORMAL_READING_STATES) {
            System.out.println("ReadingStateFactory: ABSOLUTE STATES");
        }
        if (this.mode == RELATIVE_READING_STATES) {
            System.out.println("ReadingStateFactory: RELATIVE STATES");
        }
        if (this.mode == RELATIVE_PARALLEL_READING_STATES) {
            System.out.println("ReadingStateFactory: RELATIVE PARALLEL STATES");
        }
    }

    public ReadingState createNewReadingState() {
        return this.createNewReadingStateNoPool();
    }

    public ReadingState createNewReadingState(ReadingState rsSource) {
        return this.createNewReadingStateNoPool(rsSource);
    }

    public ReadingState createNewReadingStateNoPool() {
        if (this.mode == NORMAL_READING_STATES) {
            return new ReadingState();
        }
        if (this.mode == RELATIVE_READING_STATES) {
            return new ReadingStateRelative();
        }
        if (this.mode == RELATIVE_PARALLEL_READING_STATES) {
            return new ReadingStateParallelRelative();
        }
        throw new RuntimeException("ReadingStateFactory had been initialized somehow with an unknown value, " + this.mode);
    }

    public ReadingState createNewReadingStateNoPool(ReadingState rs) {
        if (this.mode == NORMAL_READING_STATES) {
            return new ReadingState(rs);
        }
        if (this.mode == RELATIVE_READING_STATES) {
            return new ReadingStateRelative((ReadingStateRelative)rs);
        }
        if (this.mode == RELATIVE_PARALLEL_READING_STATES) {
            return new ReadingStateParallelRelative((ReadingStateParallelRelative)rs);
        }
        throw new RuntimeException("ReadingStateFactory had been initialized somehow with an unknown value, " + this.mode);
    }
}

