/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.io.Serializable;
import net.pakl.rl.HasVectorRepresentation;
import net.pakl.rl.State;

public class ReadingState
extends State
implements Serializable,
HasVectorRepresentation {
    protected int attendedWordID;
    protected int attendedWordLen;
    protected int previousWordLen;
    protected int nextWordLen;
    protected double attendedWordPredictability;
    protected int distanceFromAttendCenter;
    protected int eyePosition;
    protected int fixatedWordID;
    protected boolean identified;
    protected boolean programmingSaccade;
    protected int saccadeRequestDistance;
    protected int timeAttending;
    protected int timeInProgrammingSaccade;

    public ReadingState(int uniqueCode) {
        throw new RuntimeException("Unique codes are no longer used.");
    }

    public ReadingState(ReadingState oldReadingState) {
        this.copyFrom(oldReadingState);
    }

    public int[] binaryRepresentation() {
        throw new RuntimeException("Not implemented.");
    }

    public double[] doubleRepresentation() {
        throw new RuntimeException("Not implemented.");
    }

    public void clear() {
        this.setAttendedWordID(0);
        this.setAttendedWordLen(0);
        this.setAttendedWordPredictability(0.0);
        this.setDistanceFromAttendCenter(0);
        this.setEyePosition(0);
        this.setFixatedWordID(0);
        this.setIdentified(false);
        this.setProgrammingSaccade(false);
        this.setSaccadeRequestDistance(0);
        this.setTimeAttending(0);
        this.setTimeInProgrammingSaccade(0);
        this.setPreviousWordLen(0);
        this.setNextWordLen(0);
        this.setNextNextWordLen(0);
        this.setPreviousWordPredictability(0.0);
        this.setNextWordPredictability(0.0);
        this.setNextNextWordPredictability(0.0);
    }

    public void copyFrom(ReadingState oldReadingState) {
        this.setAttendedWordID(oldReadingState.getAttendedWordID());
        this.setAttendedWordLen(oldReadingState.getAttendedWordLen());
        this.setAttendedWordPredictability(oldReadingState.getAttendedWordPredictability());
        this.setDistanceFromAttendCenter(oldReadingState.getDistanceFromAttendCenter());
        this.setEyePosition(oldReadingState.getEyePosition());
        this.setFixatedWordID(oldReadingState.getFixatedWordID());
        this.setIdentified(oldReadingState.isIdentified());
        this.setProgrammingSaccade(oldReadingState.isProgrammingSaccade());
        this.setSaccadeRequestDistance(oldReadingState.getSaccadeRequestDistance());
        this.setTimeAttending(oldReadingState.getTimeAttending());
        this.setTimeInProgrammingSaccade(oldReadingState.getTimeInProgrammingSaccade());
        this.setPreviousWordLen(oldReadingState.getPreviousWordLen());
        this.setNextWordLen(oldReadingState.getNextWordLen());
        this.setNextNextWordLen(oldReadingState.getNextNextWordLen());
        this.setPreviousWordPredictability(oldReadingState.getPreviousWordPredictability());
        this.setNextWordPredictability(oldReadingState.getNextWordPredictability());
        this.setNextNextWordPredictability(oldReadingState.getNextNextWordPredictability());
    }

    public ReadingState(double[] doubleRepresentation) {
        this.setAttendedWordID((int)doubleRepresentation[0]);
        this.setAttendedWordLen((int)doubleRepresentation[1]);
        this.setAttendedWordPredictability(doubleRepresentation[2]);
        this.setDistanceFromAttendCenter((int)doubleRepresentation[3]);
        this.setEyePosition((int)doubleRepresentation[4]);
        this.setFixatedWordID((int)doubleRepresentation[5]);
        this.setIdentified(doubleRepresentation[6] == 1.0);
        this.setProgrammingSaccade(doubleRepresentation[7] == 1.0);
        this.setSaccadeRequestDistance((int)doubleRepresentation[8]);
        this.setTimeAttending((int)doubleRepresentation[9]);
        this.setTimeInProgrammingSaccade((int)doubleRepresentation[10]);
        this.setPreviousWordLen((int)doubleRepresentation[11]);
        this.setNextWordLen((int)doubleRepresentation[12]);
        this.setNextNextWordLen((int)doubleRepresentation[13]);
        this.setPreviousWordPredictability(doubleRepresentation[14]);
        this.setNextWordPredictability(doubleRepresentation[15]);
        this.setNextNextWordPredictability(doubleRepresentation[16]);
    }

    public ReadingState() {
        this.timeAttending = 0;
        this.attendedWordID = 0;
        this.attendedWordLen = 0;
        this.fixatedWordID = 0;
        this.distanceFromAttendCenter = 0;
        this.eyePosition = 0;
        this.identified = false;
    }

    public String toString() {
        return "STATE: [pos=" + this.getEyePosition() + ",fixWid=" + this.getFixatedWordID() + ",attWid=" + this.getAttendedWordID() + ",attDst=" + this.getDistanceFromAttendCenter() + ",attTIM=" + this.getTimeAttending() + ",sacPrg=" + this.isProgrammingSaccade() + ",sacPrgTIM=" + this.getTimeInProgrammingSaccade() + ",sacDst=" + this.getSaccadeRequestDistance() + ",ID'd?=" + this.isIdentified() + ",pred=" + this.getAttendedWordPredictability() + ",attlen=" + this.getAttendedWordLen() + "]";
    }

    public int hashCode() {
        if (this.isIdentified()) {
            return 1 + 10 * this.getEyePosition() + 1000 * this.getTimeAttending() + 100000 * this.getSaccadeRequestDistance() + 10000000 * this.getTimeInProgrammingSaccade();
        }
        return 2 + 10 * this.getEyePosition() + 1000 * this.getTimeAttending() + 100000 * this.getSaccadeRequestDistance() + 10000000 * this.getTimeInProgrammingSaccade();
    }

    public static int uniqueCode() {
        throw new RuntimeException("Unique codes are no longer used.");
    }

    public boolean equals(Object otherObject) {
        if (otherObject instanceof ReadingState) {
            ReadingState otherState = (ReadingState)otherObject;
            if (otherState.getTimeAttending() != this.getTimeAttending()) {
                return false;
            }
            if (otherState.getEyePosition() != this.getEyePosition()) {
                return false;
            }
            if (otherState.isProgrammingSaccade() != this.isProgrammingSaccade()) {
                return false;
            }
            if (otherState.getTimeInProgrammingSaccade() != this.getTimeInProgrammingSaccade()) {
                return false;
            }
            if (otherState.isIdentified() != this.isIdentified()) {
                return false;
            }
            if (otherState.getSaccadeRequestDistance() != this.getSaccadeRequestDistance()) {
                return false;
            }
            if (otherState.getFixatedWordID() != this.getFixatedWordID()) {
                return false;
            }
            if (otherState.getAttendedWordID() != this.getAttendedWordID()) {
                return false;
            }
            if (otherState.getAttendedWordLen() != this.getAttendedWordLen()) {
                return false;
            }
            if (otherState.getAttendedWordPredictability() != this.getAttendedWordPredictability()) {
                return false;
            }
            return otherState.getDistanceFromAttendCenter() == this.getDistanceFromAttendCenter();
        }
        return false;
    }

    public int getTimeAttending() {
        return this.timeAttending;
    }

    public void setTimeAttending(int timeAttending) {
        this.timeAttending = timeAttending;
    }

    public int getAttendedWordID() {
        return this.attendedWordID;
    }

    public void setAttendedWordID(int attendedWordID) {
        this.attendedWordID = attendedWordID;
    }

    public int getAttendedWordLen() {
        return this.attendedWordLen;
    }

    public void setAttendedWordLen(int attendedWordLen) {
        this.attendedWordLen = attendedWordLen;
    }

    public int getFixatedWordID() {
        return this.fixatedWordID;
    }

    public void setFixatedWordID(int fixatedWordID) {
        this.fixatedWordID = fixatedWordID;
    }

    public int getDistanceFromAttendCenter() {
        return this.distanceFromAttendCenter;
    }

    public void setDistanceFromAttendCenter(int distanceFromAttendCenter) {
        this.distanceFromAttendCenter = distanceFromAttendCenter;
    }

    public boolean isIdentified() {
        return this.identified;
    }

    public void setIdentified(boolean identified) {
        this.identified = identified;
    }

    public int getEyePosition() {
        return this.eyePosition;
    }

    public void setEyePosition(int eyePosition) {
        this.eyePosition = eyePosition;
    }

    public int getSaccadeRequestDistance() {
        return this.saccadeRequestDistance;
    }

    public void setSaccadeRequestDistance(int saccadeRequestDistance) {
        this.saccadeRequestDistance = saccadeRequestDistance;
    }

    public boolean isProgrammingSaccade() {
        return this.programmingSaccade;
    }

    public void setProgrammingSaccade(boolean programmingSaccade) {
        this.programmingSaccade = programmingSaccade;
    }

    public int getTimeInProgrammingSaccade() {
        return this.timeInProgrammingSaccade;
    }

    public void setTimeInProgrammingSaccade(int timeInProgrammingSaccade) {
        this.timeInProgrammingSaccade = timeInProgrammingSaccade;
    }

    public double getAttendedWordPredictability() {
        return this.attendedWordPredictability;
    }

    public void setAttendedWordPredictability(double attendedWordPredictability) {
        this.attendedWordPredictability = attendedWordPredictability;
    }

    public int getPreviousWordLen() {
        return this.previousWordLen;
    }

    public void setPreviousWordLen(int previousWordLen) {
        this.previousWordLen = previousWordLen;
    }

    public int getNextWordLen() {
        return this.nextWordLen;
    }

    public void setNextWordLen(int nextWordLen) {
        this.nextWordLen = nextWordLen;
    }

    public int getNextNextWordLen() {
        return 0;
    }

    public void setNextNextWordLen(int nextNextWordLen) {
    }

    public double getPreviousWordPredictability() {
        return 0.0;
    }

    public void setPreviousWordPredictability(double previousWordPredictability) {
    }

    public double getNextWordPredictability() {
        return 0.0;
    }

    public void setNextWordPredictability(double nextWordPredictability) {
    }

    public double getNextNextWordPredictability() {
        return 0.0;
    }

    public void setNextNextWordPredictability(double nextNextWordPredictability) {
    }
}

