/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.io.Serializable;
import java.util.ArrayList;
import org.eyelanguage.rl.reading.ReadingPolicy;
import org.eyelanguage.rl.reading.ReadingReinforcementFunction;
import org.eyelanguage.rl.reading.SentenceWorld;
import org.eyelanguage.rl.reading.Word;

public class ReadingSet
implements Serializable {
    ArrayList sentenceWorlds = new ArrayList();
    ArrayList readingPolicies = new ArrayList();
    ArrayList reinforcementFs = new ArrayList();

    public void add(SentenceWorld sWorld, ReadingPolicy readingPolicy, ReadingReinforcementFunction rf) {
        this.sentenceWorlds.add(sWorld);
        this.readingPolicies.add(readingPolicy);
        this.reinforcementFs.add(rf);
        System.out.println(sWorld.getName() + " has been added to the ReadingSet");
    }

    public int getNumSentenceWorlds() {
        return this.sentenceWorlds.size();
    }

    public SentenceWorld getSentenceWorld(int i) {
        return (SentenceWorld)this.sentenceWorlds.get(i);
    }

    public ReadingPolicy getReadingPolicy(int i) {
        return (ReadingPolicy)this.readingPolicies.get(i);
    }

    public ReadingReinforcementFunction getReadingReinforcementFunction(int i) {
        return (ReadingReinforcementFunction)this.reinforcementFs.get(i);
    }

    public int getMaxWordLength() {
        int max = 0;
        for (int i = 0; i < this.sentenceWorlds.size(); ++i) {
            SentenceWorld sWorld = (SentenceWorld)this.sentenceWorlds.get(i);
            for (int j = 0; j < sWorld.getNumWords(); ++j) {
                Word w = sWorld.getWord(j);
                if (w.getLength() <= max) continue;
                max = w.getLength();
            }
        }
        return max;
    }

    public int getMaxSentenceLength() {
        int max = 0;
        for (int i = 0; i < this.sentenceWorlds.size(); ++i) {
            SentenceWorld sWorld = (SentenceWorld)this.sentenceWorlds.get(i);
            if (sWorld.getSentenceLength() <= max) continue;
            max = sWorld.getSentenceLength();
        }
        return max;
    }

    public int getTotalNumStates() {
        int result = 0;
        for (int i = 0; i < this.sentenceWorlds.size(); ++i) {
            SentenceWorld sWorld = (SentenceWorld)this.sentenceWorlds.get(i);
            result += sWorld.getNumberOfStates();
        }
        return result;
    }

    public int getMAX_POSSIBLE_ID_TIME() {
        int max = ((SentenceWorld)this.sentenceWorlds.get(0)).getMAX_POSSIBLE_ATTEND_TIME();
        for (int i = 1; i < this.sentenceWorlds.size(); ++i) {
            int test = ((SentenceWorld)this.sentenceWorlds.get(i)).getMAX_POSSIBLE_ATTEND_TIME();
            if (test <= max) continue;
            max = test;
        }
        return max;
    }

    public int getMAX_SACCADE_PROG_TIME() {
        int max = ((SentenceWorld)this.sentenceWorlds.get(0)).getMAX_SACCADE_PROG_TIME();
        for (int i = 1; i < this.sentenceWorlds.size(); ++i) {
            int test = ((SentenceWorld)this.sentenceWorlds.get(i)).getMAX_SACCADE_PROG_TIME();
            if (test <= max) continue;
            max = test;
        }
        return max;
    }

    public int getMAX_POSSIBLE_ATTEND_TIME() {
        int max = ((SentenceWorld)this.sentenceWorlds.get(0)).getMAX_POSSIBLE_ATTEND_TIME();
        for (int i = 1; i < this.sentenceWorlds.size(); ++i) {
            int test = ((SentenceWorld)this.sentenceWorlds.get(i)).getMAX_POSSIBLE_ATTEND_TIME();
            if (test <= max) continue;
            max = test;
        }
        return max;
    }

    public int getMIN_ATTEND_TIME_WITH_PENALTIES() {
        int min = ((SentenceWorld)this.sentenceWorlds.get(0)).getMIN_ATTEND_TIME_WITH_PENALTIES();
        for (int i = 1; i < this.sentenceWorlds.size(); ++i) {
            int test = ((SentenceWorld)this.sentenceWorlds.get(i)).getMIN_ATTEND_TIME_WITH_PENALTIES();
            if (test >= min) continue;
            min = test;
        }
        return min;
    }

    public int getMAX_ATTEND_TIME_WITH_PENALTIES() {
        int max = ((SentenceWorld)this.sentenceWorlds.get(0)).getMAX_ATTEND_TIME_WITH_PENALTIES();
        for (int i = 1; i < this.sentenceWorlds.size(); ++i) {
            int test = ((SentenceWorld)this.sentenceWorlds.get(i)).getMAX_ATTEND_TIME_WITH_PENALTIES();
            if (test <= max) continue;
            max = test;
        }
        return max;
    }
}

