/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import net.pakl.rl.Action;
import net.pakl.rl.ReinforcementFunction;
import net.pakl.rl.State;
import org.eyelanguage.rl.reading.ReadingAction;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.SentenceWorld;

public class ReadingReinforcementFunction
extends ReinforcementFunction {
    int sentenceLength = 0;
    private SentenceWorld sWorld;
    double rewardForSuccessfulIdentification = 1.0;
    double rewardForReachingTerminalState = 100.0;
    double rewardForOffSentenceSaccades = -100.0;

    public void setReinforcementsForActionsOntoTerminalState(double reward) {
        this.rewardForReachingTerminalState = reward;
    }

    public ReadingReinforcementFunction(SentenceWorld sWorld) {
        this.sWorld = sWorld;
        this.sentenceLength = sWorld.getSentenceLength();
    }

    private boolean saccadeOffSentence(State s, Action a) {
        ReadingState rs = (ReadingState)s;
        ReadingAction ra = (ReadingAction)a;
        if (rs.getEyePosition() + ra.getSaccadeRequestDistance() >= this.sentenceLength) {
            return true;
        }
        return rs.getEyePosition() + ra.getSaccadeRequestDistance() < 0;
    }

    public double getReward(State state, Action action) {
        throw new RuntimeException("Since eye movements might be stochastic, please pass in the resulting state using a different function call.");
    }

    public double getReward(State state, Action action, State resultingState) {
        ReadingState readingState = (ReadingState)state;
        ReadingAction readingAction = (ReadingAction)action;
        ReadingState resultingReadingState = (ReadingState)resultingState;
        if (!readingState.isIdentified() && resultingReadingState.isIdentified()) {
            return this.rewardForSuccessfulIdentification;
        }
        if (this.sWorld.isTerminalState(resultingState)) {
            return this.rewardForReachingTerminalState;
        }
        return this.getDefaultReinforcement();
    }

    public double getRewardForSuccessfulIdentification() {
        return this.rewardForSuccessfulIdentification;
    }

    public void setRewardForSuccessfulIdentification(double rewardForSuccessfulIdentification) {
        this.rewardForSuccessfulIdentification = rewardForSuccessfulIdentification;
    }
}

