/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.util.ArrayList;
import java.util.List;
import net.pakl.rl.ActionSet;
import net.pakl.rl.State;
import org.eyelanguage.rl.reading.ReadingAction;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.SentenceWorld;

public class ReadingPolicy
extends ActionSet {
    private static boolean ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = false;
    private static boolean ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT = false;
    private SentenceWorld sWorld = null;
    private int maxSaccadeIntendedDistance = 10;

    public ReadingPolicy(SentenceWorld sWorld) {
        this.sWorld = sWorld;
    }

    public ReadingPolicy() {
    }

    public void setALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT(boolean newValue) {
        ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = newValue;
        System.out.println("ReadingPolicy: ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT set = " + newValue);
    }

    public void setALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT(boolean newValue) {
        ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = newValue;
        System.out.println("ReadingPolicy: ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT set = " + newValue);
    }

    public void allowSaccadeActions(int eyePosition, int charsBack, int charsForward) {
        this.maxSaccadeIntendedDistance = Math.max(Math.abs(charsForward), Math.abs(charsBack));
    }

    public void setMaxSaccadeIntendedDistance(int x) {
        this.maxSaccadeIntendedDistance = x;
    }

    public synchronized List getAllPossibleActions(State state) {
        if (this.sWorld.isTerminalState(state)) {
            ReadingAction remainHere = new ReadingAction().setRemainHere(true).setAttendThisWord(false);
            ArrayList<ReadingAction> result = new ArrayList<ReadingAction>();
            result.add(remainHere);
            return result;
        }
        ArrayList<ReadingAction> result = new ArrayList<ReadingAction>();
        if (state instanceof ReadingState) {
            int i;
            ReadingState readingState = (ReadingState)state;
            if (!(readingState.getTimeAttending() >= this.sWorld.MAX_ATTEND_TIME_WITH_PENALTIES - this.sWorld.MAX_SACCADE_PROG_TIME || readingState.isIdentified() && !ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT || readingState.isProgrammingSaccade())) {
                for (i = -this.maxSaccadeIntendedDistance; i <= this.maxSaccadeIntendedDistance; ++i) {
                    if (i == 0 || !this.isBetween(readingState.getEyePosition() + i, 0, this.sWorld.getSentenceLength())) continue;
                    result.add(new ReadingAction().setRequestingSaccade(true).setSaccadeRequestDistance(i));
                }
            }
            if (readingState.isIdentified()) {
                if (ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT) {
                    for (i = 0; i < result.size(); ++i) {
                        ReadingAction action = (ReadingAction)result.get(i);
                        ReadingAction actionWithAttNext = new ReadingAction();
                        actionWithAttNext.copyFrom(action);
                        actionWithAttNext.setAttendNextWord(true);
                        if (ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT) {
                            actionWithAttNext.setAttendThisWord(true);
                        }
                        result.set(i, actionWithAttNext);
                    }
                }
                if (ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT) {
                    result.add(new ReadingAction().setAttendNextWord(true).setAttendThisWord(true));
                } else {
                    result.add(new ReadingAction().setAttendNextWord(true).setAttendThisWord(false));
                }
            } else {
                result.add(new ReadingAction().setAttendNextWord(false).setAttendThisWord(true));
            }
        }
        return result;
    }

    protected boolean isBetween(int x, int lowerBound, int upperBound) {
        if (x < lowerBound) {
            return false;
        }
        return x <= upperBound;
    }

    public String toString() {
        return "[a policy]";
    }
}

