/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import net.pakl.rl.Action;
import net.pakl.rl.State;
import org.eyelanguage.rl.reading.ReadingAction;
import org.eyelanguage.rl.reading.ReadingReinforcementFunction;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.ReadingStateParallelRelative;
import org.eyelanguage.rl.reading.SentenceWorld;

public class ReadingParallelReinforcementFunction
extends ReadingReinforcementFunction {
    int sentenceLength = 0;
    private SentenceWorld sWorld;
    double rewardForSuccessfulIdentification = 1.0;
    double rewardForReachingTerminalState = 100.0;
    double rewardForOffSentenceSaccades = -100.0;

    public void setReinforcementsForActionsOntoTerminalState(double reward) {
        this.rewardForReachingTerminalState = reward;
    }

    public ReadingParallelReinforcementFunction(SentenceWorld sWorld) {
        super(sWorld);
        this.sWorld = sWorld;
        this.sentenceLength = sWorld.getSentenceLength();
    }

    private boolean saccadeOffSentence(State s, Action a) {
        ReadingState rs = (ReadingState)s;
        ReadingAction ra = (ReadingAction)a;
        if (rs.getEyePosition() + ra.getSaccadeRequestDistance() >= this.sentenceLength) {
            return true;
        }
        return rs.getEyePosition() + ra.getSaccadeRequestDistance() < 0;
    }

    public double getReward(State state, Action action) {
        throw new RuntimeException("Since eye movements might be stochastic, please pass in the resulting state using a different function call.");
    }

    public double getReward(State state, Action action, State resultingState) {
        ReadingStateParallelRelative readingState = (ReadingStateParallelRelative)state;
        ReadingAction readingAction = (ReadingAction)action;
        ReadingStateParallelRelative resultingReadingState = (ReadingStateParallelRelative)resultingState;
        if (resultingReadingState.getNumIdentified() > readingState.getNumIdentified()) {
            int numberOfIdentifiedWords = resultingReadingState.getNumIdentified() - readingState.getNumIdentified();
            return (double)numberOfIdentifiedWords * this.rewardForSuccessfulIdentification;
        }
        if (this.sWorld.isTerminalState(resultingState)) {
            return this.rewardForReachingTerminalState;
        }
        return this.getDefaultReinforcement();
    }

    public double getRewardForSuccessfulIdentification() {
        return this.rewardForSuccessfulIdentification;
    }

    public void setRewardForSuccessfulIdentification(double rewardForSuccessfulIdentification) {
        this.rewardForSuccessfulIdentification = rewardForSuccessfulIdentification;
    }
}

