/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.pakl.rl.Agent;
import net.pakl.rl.AgentParallelized;
import net.pakl.rl.PolicyExtractor;
import net.pakl.rl.State;
import net.pakl.rl.ValueFunction;
import net.pakl.rl.ValueFunctionHashMap;
import net.pakl.rl.ValueFunctionHashMapZipped;
import net.pakl.rl.ValueFunctionPerceptron;
import net.pakl.rl.ValueFunctionResidualAlgorithmBairdPerceptron;
import net.pakl.rl.ValueFunctionResidualAlgorithmLinear;
import net.pakl.rl.ValueFunctionResidualAlgorithmPatrykNetwork;
import net.pakl.rl.ValueFunctionResidualAlgorithmPerceptron;
import org.eyelanguage.rl.reading.Corpus;
import org.eyelanguage.rl.reading.ParallelToSerialVFAdapter;
import org.eyelanguage.rl.reading.ReadingParallelReinforcementFunction;
import org.eyelanguage.rl.reading.ReadingPolicy;
import org.eyelanguage.rl.reading.ReadingReinforcementFunction;
import org.eyelanguage.rl.reading.ReadingState;
import org.eyelanguage.rl.reading.ReadingStateFactory;
import org.eyelanguage.rl.reading.ReadingStateParallelRelative;
import org.eyelanguage.rl.reading.SentenceWorld;
import org.eyelanguage.rl.reading.SentenceWorldParallel;
import org.eyelanguage.rl.reading.Toolbox;

public class ReadingMain {
    private static final String VERSION = "20060203-1631";
    protected int totalIterations = 2000;
    protected int testAgentEvery = 0;
    protected boolean incrementalUpdate = true;
    protected String attention = "serial";
    protected boolean PARALLEL_UNIFORM_ATTENTION = false;
    protected boolean PARALLEL_LINEAR_ATTENTION_GRADIENT = false;
    protected boolean PARALLEL_DIVIDED_ATTENTION_GRADIENT = false;
    protected boolean saccadicError = false;
    protected double saccadicErrorSpread = 0.0;
    protected boolean acuityLinearPenalize = false;
    protected int acuityLinearPenaltySlope = 5;
    protected int saccadeTimePenalty = -5;
    protected boolean saccadicErrorGaussian = true;
    protected double identifyReinforcement = 1.0;
    protected double reachTerminalReinforcement = 0.0;
    protected double defaultReinforcement = -1.0;
    protected int saccPrgTime = 15;
    protected int parallelAttendableWords = 2;
    protected int centerOfAttention = 0;
    protected int acuityLimit = 1000;
    protected boolean ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = false;
    protected boolean ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT = false;
    protected boolean DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES = false;
    protected String valueFunctionName = "valueFunction";
    protected String sentence = "a funny cat";
    protected String predictabilities = "0.5 0.2";
    protected String aidTimes = "30 30 30";
    protected String wordLengths = "";
    protected boolean wordLengthsOverridden = false;
    protected String testSentence = "a funny cat";
    protected int testIterations = 1;
    protected String testPredictabilities = "0.5 0.2";
    protected String testAidTimes = "30 30 30";
    protected int hiddenLayerSize = 10;
    protected String testWordLengths = "";
    protected boolean testWordLengthsOverridden = false;
    protected String agentType = "serial";
    protected int agentParallelNumThreads = 2;
    protected int boundedBufferSize = 0;
    protected double valueOfTerminalStates = 0.0;
    protected boolean testTrainSameVf = false;
    protected boolean stateActionCache = false;
    protected boolean bitPacker = false;
    protected String valueFunctionToLoad = "";
    protected boolean wrapSerialValueFunctionWithParallelAdapter = false;
    protected String valueFunctionToSave = "";
    protected String loadWorldCache = "";
    protected boolean distributedJavaParty = false;
    protected boolean handCraftedVectors = false;
    protected String rlAlgorithm = "valueIteration";
    protected double greed = 1.0;
    protected double discountFactor = 1.0;
    protected double epsilon = 1.0;
    protected double learningRate = 0.01;
    protected double momentum = 0.0;
    protected double netOutputRange = 150.0;
    protected int saveNetworkEvery = 0;
    protected String readingStateType = "Absolute";
    protected long randomSeed = 123456L;
    protected double valueOfNonStoredStates = 0.0;
    protected String startState = "";
    protected boolean updateOnlyWhenGreedy = true;
    protected boolean residualAlgorithm = true;
    protected double residualWeighting = 0.5;
    String valueFunctionType = "LookupTable";
    boolean valueFunctionSafety = true;
    boolean valueFunctionStateBounds = false;
    protected boolean stateVectorsCrossProduct = false;
    protected boolean stateVectorsComplement = false;
    protected Corpus testCorpus;
    protected Corpus trainCorpus;

    public static void main(String[] args) {
        new ReadingMain();
    }

    public ReadingMain() {
        this.loadProperties();
        this.showProperties();
        this.trainSingleSentence();
    }

    private SentenceWorld configureSentenceWorld() {
        SentenceWorld sWorld = null;
        if (this.attention.equalsIgnoreCase("serial")) {
            sWorld = new SentenceWorld("trainCorpus", this.randomSeed);
        }
        if (this.attention.equalsIgnoreCase("semiparallel")) {
            sWorld = new SentenceWorldParallel("trainCorpus", this.randomSeed);
        }
        if (sWorld == null) {
            throw new RuntimeException("Sorry, attention must be either serial or semiparallel... but was " + this.attention);
        }
        if (this.readingStateType.equalsIgnoreCase("Relative")) {
            System.out.println("! SETTING UP RELATIVE READING STATES");
            if (this.attention.equalsIgnoreCase("serial")) {
                sWorld.setupReadingStateFactory(ReadingStateFactory.RELATIVE_READING_STATES);
            } else {
                sWorld.setupReadingStateFactory(ReadingStateFactory.RELATIVE_PARALLEL_READING_STATES);
                SentenceWorldParallel asParallel = (SentenceWorldParallel)sWorld;
                asParallel.setPARALLEL_ATTENDABLE_WORDS(this.parallelAttendableWords);
                asParallel.setCENTER_OF_ATTENTION(this.centerOfAttention);
                SentenceWorldParallel.UNIFORM_ATTENTION = this.PARALLEL_UNIFORM_ATTENTION;
                SentenceWorldParallel.LINEAR_ATTENTION_GRADIENT = this.PARALLEL_LINEAR_ATTENTION_GRADIENT;
                SentenceWorldParallel.DIVIDED_ATTENTION = this.PARALLEL_DIVIDED_ATTENTION_GRADIENT;
            }
        }
        sWorld.setMAX_SACCADE_PROG_TIME(this.saccPrgTime);
        sWorld.SACCADIC_ERROR = this.saccadicError;
        sWorld.SACCADIC_ERROR_GAUSSIAN = this.saccadicErrorGaussian;
        sWorld.SACCADIC_ERROR_SPREAD = this.saccadicErrorSpread;
        sWorld.ACUITY_LINEAR_PENALIZE = this.acuityLinearPenalize;
        sWorld.ACUITY_LINEAR_PENALTY_SLOPE = this.acuityLinearPenaltySlope;
        sWorld.SACCADE_TIME_PENALTY = this.saccadeTimePenalty;
        sWorld.ACUITY_LIMIT = this.acuityLimit;
        if (!this.startState.equals("")) {
            sWorld.setStartingState = new ReadingStateParallelRelative().fromString(this.startState);
        }
        return sWorld;
    }

    private void trainSingleSentence() {
        long start = System.currentTimeMillis();
        SentenceWorld sWorld = this.configureSentenceWorld();
        sWorld.setSentence(this.sentence, this.predictabilities, this.aidTimes, this.wordLengths, this.wordLengthsOverridden);
        if (this.rlAlgorithm.equalsIgnoreCase("valueIteration") && !sWorld.getIsBuilt()) {
            sWorld.build();
        }
        ReadingPolicy readingPolicy = Toolbox.createSimpleReadingPolicy(sWorld);
        readingPolicy.setALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT(this.ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT);
        readingPolicy.setALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT(this.ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT);
        ReadingReinforcementFunction rf = null;
        rf = this.attention.equalsIgnoreCase("serial") ? new ReadingReinforcementFunction(sWorld) : new ReadingParallelReinforcementFunction(sWorld);
        rf.setDefaultReinforcement(this.defaultReinforcement);
        rf.setRewardForSuccessfulIdentification(this.identifyReinforcement);
        rf.setReinforcementsForActionsOntoTerminalState(this.reachTerminalReinforcement);
        Agent reader = null;
        reader = this.agentType.equalsIgnoreCase("parallel") ? new AgentParallelized("reader", this.agentParallelNumThreads) : new Agent("reader");
        Agent.printStartStateValueEvery = 100;
        reader.setReinforcementFunction(rf);
        reader.setPolicy(readingPolicy);
        reader.setDiscountFactor(this.discountFactor);
        reader.setEpsilon(this.epsilon);
        reader.setGreed(this.greed);
        Agent.UPDATE_ONLY_WHEN_GREEDY = this.updateOnlyWhenGreedy;
        ValueFunction valueFunction = null;
        ValueFunction tempNewValueFunction = null;
        if (this.valueFunctionToLoad.equals("")) {
            valueFunction = this.initializeValueFunction(sWorld);
            if (!this.testTrainSameVf) {
                tempNewValueFunction = this.initializeValueFunction(sWorld);
            }
        } else {
            valueFunction = this.loadValueFunction(this.valueFunctionToLoad);
            if (!this.testTrainSameVf && this.totalIterations > 0) {
                tempNewValueFunction = this.loadValueFunction(this.valueFunctionToLoad);
            }
        }
        if (this.totalIterations > 0) {
            valueFunction.setValueOfTerminalStates(this.valueOfTerminalStates);
            if (valueFunction instanceof ValueFunctionHashMap) {
                ((ValueFunctionHashMap)valueFunction).setValueOfNonStoredStates(this.valueOfNonStoredStates);
            }
            if (!this.testTrainSameVf) {
                tempNewValueFunction.setValueOfTerminalStates(this.valueOfTerminalStates);
                if (tempNewValueFunction instanceof ValueFunctionHashMap) {
                    ((ValueFunctionHashMap)tempNewValueFunction).setValueOfNonStoredStates(this.valueOfNonStoredStates);
                }
            }
            System.out.println("Done with ValueFunction...");
            int sampleTimingEvery = 1000;
            reader.setWorld(sWorld);
            int numStates = sWorld.getNumberOfStates();
            double timerStart = System.currentTimeMillis();
            for (int trial = 1; trial < this.totalIterations && !this.receivedEndRunMessage(); ++trial) {
                if (this.testTrainSameVf) {
                    this.trainAgent(reader, valueFunction, valueFunction, trial, numStates);
                } else {
                    this.trainAgent(reader, valueFunction, tempNewValueFunction, trial, numStates);
                    ValueFunction temp = tempNewValueFunction;
                    tempNewValueFunction = valueFunction;
                    valueFunction = temp;
                }
                if (this.testAgentEvery > 0 && trial % this.testAgentEvery == 0) {
                    this.testAgent(sWorld, valueFunction);
                }
                this.saveValueFunction(valueFunction, trial);
                if (trial % sampleTimingEvery != 0) continue;
                double timerCease = System.currentTimeMillis();
                double duration = (timerCease - timerStart) / 60.0 / 1000.0;
                System.out.println("\n" + sampleTimingEvery + " Iterations took " + duration + " minutes.");
                System.out.println("Estimated " + (double)((this.totalIterations - trial) / sampleTimingEvery) * duration / 60.0 + " hours remaining.");
                if (valueFunction instanceof ValueFunctionHashMap) {
                    System.out.println("size(vf) = " + ((ValueFunctionHashMap)valueFunction).getSize());
                }
                timerStart = System.currentTimeMillis();
            }
            System.out.println("Iterations completed, stopping run.");
            if (!this.valueFunctionToSave.equals("")) {
                this.saveValueFunction(valueFunction, this.valueFunctionToSave);
            }
        }
        this.testAgent(sWorld, valueFunction);
        long cease = System.currentTimeMillis();
        System.out.println("Total run time was " + ((double)cease - (double)start) / 1000.0 / 3600.0 + " hours");
    }

    private void testAgent(SentenceWorld sWorld, ValueFunction valueFunction) {
        System.out.println("Testing Agent");
        SentenceWorld tWorld = sWorld;
        if (!this.testSentence.equals("")) {
            if (this.attention.equalsIgnoreCase("serial")) {
                tWorld = new SentenceWorld("trainCorpus", this.randomSeed);
            }
            if (this.attention.equalsIgnoreCase("semiparallel")) {
                tWorld = new SentenceWorldParallel("trainCorpus", this.randomSeed);
            }
            if (this.readingStateType.equalsIgnoreCase("Relative")) {
                System.out.println("! SETTING UP RELATIVE READING STATES");
                if (this.attention.equalsIgnoreCase("serial")) {
                    tWorld.setupReadingStateFactory(ReadingStateFactory.RELATIVE_READING_STATES);
                } else {
                    tWorld.setupReadingStateFactory(ReadingStateFactory.RELATIVE_PARALLEL_READING_STATES);
                    SentenceWorldParallel asParallel = (SentenceWorldParallel)tWorld;
                    asParallel.setPARALLEL_ATTENDABLE_WORDS(this.parallelAttendableWords);
                    asParallel.setCENTER_OF_ATTENTION(this.centerOfAttention);
                    SentenceWorldParallel.UNIFORM_ATTENTION = this.PARALLEL_UNIFORM_ATTENTION;
                    SentenceWorldParallel.LINEAR_ATTENTION_GRADIENT = this.PARALLEL_LINEAR_ATTENTION_GRADIENT;
                    SentenceWorldParallel.DIVIDED_ATTENTION = this.PARALLEL_DIVIDED_ATTENTION_GRADIENT;
                }
            }
            tWorld.setMAX_SACCADE_PROG_TIME(this.saccPrgTime);
            tWorld.SACCADIC_ERROR = this.saccadicError;
            tWorld.SACCADIC_ERROR_GAUSSIAN = this.saccadicErrorGaussian;
            tWorld.SACCADIC_ERROR_SPREAD = this.saccadicErrorSpread;
            tWorld.ACUITY_LINEAR_PENALIZE = this.acuityLinearPenalize;
            tWorld.ACUITY_LINEAR_PENALTY_SLOPE = this.acuityLinearPenaltySlope;
            tWorld.SACCADE_TIME_PENALTY = this.saccadeTimePenalty;
            tWorld.ACUITY_LIMIT = this.acuityLimit;
            tWorld.setSentence(this.testSentence, this.testPredictabilities, this.testAidTimes, this.testWordLengths, this.testWordLengthsOverridden);
            if (!this.startState.equals("")) {
                tWorld.setStartingState = new ReadingStateParallelRelative().fromString(this.startState);
            }
        } else {
            tWorld = sWorld;
        }
        if (this.rlAlgorithm.equalsIgnoreCase("valueIteration") && !tWorld.getIsBuilt()) {
            tWorld.build();
        }
        for (int tests = 0; tests < this.testIterations; ++tests) {
            System.out.println("Test Number " + tests);
            PolicyExtractor policyExtractor = new PolicyExtractor();
            if (this.DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES) {
                PolicyExtractor.DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES = true;
            }
            ReadingReinforcementFunction rfTest = null;
            rfTest = this.attention.equalsIgnoreCase("serial") ? new ReadingReinforcementFunction(tWorld) : new ReadingParallelReinforcementFunction(tWorld);
            rfTest.setDefaultReinforcement(this.defaultReinforcement);
            rfTest.setRewardForSuccessfulIdentification(this.identifyReinforcement);
            rfTest.setReinforcementsForActionsOntoTerminalState(this.reachTerminalReinforcement);
            ReadingPolicy readingPolicyTest = Toolbox.createSimpleReadingPolicy(tWorld);
            try {
                System.out.println(policyExtractor.extractOptimalPolicy(readingPolicyTest, valueFunction, sWorld, tWorld, rfTest, this.discountFactor));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private ValueFunction initializeValueFunction(SentenceWorld sWorld) {
        System.out.println("Initializing a new value function with a " + sWorld.getClass() + ".");
        if (this.valueFunctionType.equalsIgnoreCase("ResidualAlgorithmLinear")) {
            System.out.println("USING Residual Algorithm -- Linear Approximator!!!");
            ValueFunctionResidualAlgorithmLinear valueFunction = new ValueFunctionResidualAlgorithmLinear(sWorld);
            valueFunction.setMaxMinValue(this.netOutputRange);
            valueFunction.CROSS_PRODUCT = this.stateVectorsCrossProduct;
            valueFunction.BINARY_COMPLEMENT = this.stateVectorsComplement;
            valueFunction.RESIDUAL_ALGORITHM = this.residualAlgorithm;
            valueFunction.INCREMENTAL_UPDATE = this.incrementalUpdate;
            valueFunction.HAND_CRAFTED_VECTORS = this.handCraftedVectors;
            valueFunction.setLearningRate(this.learningRate);
            valueFunction.setResidualWeighting(this.residualWeighting);
            valueFunction.setName(this.valueFunctionName);
            return valueFunction;
        }
        if (this.valueFunctionType.equalsIgnoreCase("ResidualAlgorithm")) {
            System.out.println("USING Residual Algorithm");
            ValueFunctionResidualAlgorithmPerceptron valueFunction = new ValueFunctionResidualAlgorithmPerceptron(sWorld);
            valueFunction.setMaxMinValue(this.netOutputRange);
            valueFunction.setLearningRate(this.learningRate);
            valueFunction.setRandomSeed(this.randomSeed);
            valueFunction.setResidualWeighting(this.residualWeighting);
            valueFunction.setHiddenUnits(this.hiddenLayerSize);
            valueFunction.INCREMENTAL_UPDATE = this.incrementalUpdate;
            valueFunction.setName(this.valueFunctionName);
            return valueFunction;
        }
        if (this.valueFunctionType.equalsIgnoreCase("ResidualAlgorithmBairdPerceptron")) {
            System.out.println("USING Residual Algorithm + Baird Perceptron");
            ValueFunctionResidualAlgorithmBairdPerceptron valueFunction = new ValueFunctionResidualAlgorithmBairdPerceptron(sWorld);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setMaxMinValue(this.netOutputRange);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setLearningRate(this.learningRate);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setRandomSeed(this.randomSeed);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setResidualWeighting(this.residualWeighting);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setHiddenUnits(this.hiddenLayerSize);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).INCREMENTAL_UPDATE = this.incrementalUpdate;
            valueFunction.setName(this.valueFunctionName);
            return valueFunction;
        }
        if (this.valueFunctionType.equalsIgnoreCase("ResidualAlgorithmPatrykNetwork")) {
            System.out.println("USING Residual Algorithm + Patryk Network");
            ValueFunctionResidualAlgorithmPatrykNetwork valueFunction = new ValueFunctionResidualAlgorithmPatrykNetwork(sWorld);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setMaxMinValue(this.netOutputRange);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setLearningRate(this.learningRate);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setRandomSeed(this.randomSeed);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setResidualWeighting(this.residualWeighting);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setHiddenUnits(this.hiddenLayerSize);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).INCREMENTAL_UPDATE = this.incrementalUpdate;
            valueFunction.setName(this.valueFunctionName);
            return valueFunction;
        }
        if (this.valueFunctionType.equalsIgnoreCase("Perceptron")) {
            System.out.println("USING Backprop -- GradientDescent Approximator WITHOUT RESIDUAL ALGORITHMS!!!");
            ValueFunctionPerceptron valueFunction = new ValueFunctionPerceptron(sWorld);
            valueFunction.setMaxMinValue(this.netOutputRange);
            valueFunction.setLearningRate(this.learningRate);
            valueFunction.setRandomSeed(this.randomSeed);
            valueFunction.setHiddenUnits(this.hiddenLayerSize);
            valueFunction.setMomentum(this.momentum);
            valueFunction.INCREMENTAL_UPDATE = this.incrementalUpdate;
            valueFunction.setName(this.valueFunctionName);
            return valueFunction;
        }
        if (this.valueFunctionType.equalsIgnoreCase("LookupTable")) {
            System.out.println("USING LOOKUP TABLE VALUE FUNCTION.");
            ValueFunctionHashMap vf = new ValueFunctionHashMap(sWorld, this.valueFunctionSafety);
            vf.setName(this.valueFunctionName);
            return vf;
        }
        if (this.valueFunctionType.equalsIgnoreCase("LookupTableZipped")) {
            System.out.println("USING LOOKUP TABLE VALUE FUNCTION.");
            ValueFunctionHashMapZipped vf = new ValueFunctionHashMapZipped(sWorld, this.valueFunctionSafety);
            vf.setName(this.valueFunctionName);
            return vf;
        }
        throw new RuntimeException("\nvalueFunctionType must be either 'Perceptron', 'ResidualAlgorithm', 'LookupTable' or 'ResidualAlgorithmLinear'.  It was '" + this.valueFunctionType + "'\n");
    }

    private void trainAgent(Agent reader, ValueFunction valueFunction, ValueFunction tempNewValueFunction, int trial, int numStates) {
        if (this.rlAlgorithm.equalsIgnoreCase("valueIteration")) {
            long timerStart = System.currentTimeMillis();
            reader.performValueIteration(tempNewValueFunction, valueFunction);
            long timerCease = System.currentTimeMillis();
            this.displayTimeCalculations(timerStart, timerCease, trial, numStates);
        } else {
            if (this.rlAlgorithm.equalsIgnoreCase("TD(lambda)")) {
                throw new RuntimeException("TD(lambda) is not implemented.");
            }
            if (this.rlAlgorithm.equalsIgnoreCase("valueIterationTrajectorySample")) {
                System.out.println("Trajectory " + trial);
                reader.performValueIterationTrajectorySample(tempNewValueFunction, valueFunction);
            } else {
                System.out.println("Try:  valueIteration valueIterationTrajectorySample");
                throw new RuntimeException("rlAlgorithm unrecognized:  " + this.rlAlgorithm);
            }
        }
    }

    private void saveValueFunction(ValueFunction valueFunction, int trial) {
        if (this.saveNetworkEvery > 0 && trial % this.saveNetworkEvery == 0 && !this.valueFunctionToSave.equals("")) {
            this.saveValueFunction(valueFunction, this.valueFunctionToSave + "-" + trial);
        }
    }

    private void dumpValueFunction(ValueFunction valueFunction, SentenceWorld sWorld) {
        Iterator stateIterator = sWorld.stateIterator();
        System.out.println("Value Function Dump");
        while (stateIterator.hasNext()) {
            ReadingState rs = (ReadingState)stateIterator.next();
            System.out.println(rs + " = " + valueFunction.getValue(rs));
        }
    }

    private boolean receivedEndRunMessage() {
        File f = new File("endrun.msg");
        if (f.exists()) {
            System.out.println("File endrun.msg exists, stopping run.");
            return true;
        }
        return false;
    }

    private String showVector(double[] x) {
        StringBuffer result = new StringBuffer();
        result.append("[");
        for (int i = 0; i < x.length; ++i) {
            result.append(x[i] + " ");
        }
        result.append("]");
        return result.toString();
    }

    private ValueFunction loadValueFunction(String filename) {
        System.out.println("Loading pre-existing value function.");
        try {
            ObjectInputStream in = new ObjectInputStream(new GZIPInputStream(new FileInputStream(filename + ".gz")));
            ValueFunction vf = null;
            vf = (ValueFunction)in.readObject();
            System.out.println("Value function of type " + vf.getClass() + " loaded from " + filename);
            if (vf instanceof ValueFunctionResidualAlgorithmLinear) {
                System.out.println("ValueFunction is linear network!  Re-setting parameters in case changed.");
                System.out.println("  learning rate: " + this.learningRate);
                ((ValueFunctionResidualAlgorithmLinear)vf).setLearningRate(this.learningRate);
                System.out.println("  residual weighting: " + this.residualWeighting);
                ((ValueFunctionResidualAlgorithmLinear)vf).setResidualWeighting(this.residualWeighting);
            }
            if (vf instanceof ValueFunctionResidualAlgorithmPerceptron) {
                System.out.println("ValueFunction is perceptron residual algorithm network!  Re-setting parameters in case changed.");
                System.out.println("  learning rate: " + this.learningRate);
                ((ValueFunctionResidualAlgorithmPerceptron)vf).setLearningRate(this.learningRate);
                System.out.println("  residual weighting: " + this.residualWeighting);
                ((ValueFunctionResidualAlgorithmPerceptron)vf).setResidualWeighting(this.residualWeighting);
            }
            if (vf instanceof ValueFunctionPerceptron) {
                System.out.println("ValueFunction is perceptron!  Re-setting parameters in case changed.");
                System.out.println("  learning rate: " + this.learningRate);
                ((ValueFunctionPerceptron)vf).setLearningRate(this.learningRate);
            }
            if (this.wrapSerialValueFunctionWithParallelAdapter) {
                System.out.println("Wrapping loaded value function in Parallel-to->Serial Adapter.");
                vf = new ParallelToSerialVFAdapter(vf);
            }
            return vf;
        }
        catch (Exception e) {
            System.out.println("Reading value function from file " + filename + " failed.\n");
            e.printStackTrace();
            throw new RuntimeException("Value Function loading failed.");
        }
    }

    private void loadCorpus(Corpus corpus, String filename) {
        corpus = new Corpus();
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            while (reader.ready()) {
                String sentence = reader.readLine();
                String times = reader.readLine();
                String predictabilities = reader.readLine();
                corpus.addSentence(sentence, "", times, predictabilities);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void displayTimeCalculations(long timerStart, long timerCease, int j, int numStates) {
        System.out.println("Iteration " + j + " took " + (timerCease - timerStart) + " ms");
        System.out.print("Rate: " + (double)(timerCease - timerStart) / (double)numStates + " ms/state ");
        double minutes = (double)(timerCease - timerStart) * (double)(this.totalIterations - j) / 1000.0 / 60.0;
        double hours = minutes / 60.0;
        System.out.print("Time left: " + minutes + " minutes, which is " + hours + " hours");
    }

    private void displayTimeCalculationsForTrials(long timerStart, long timerCease, int runsPerTrial, int trial) {
        double timePerBlock = (double)timerCease - (double)timerStart;
        double blocksLeft = (double)this.totalIterations - (double)trial;
        double timeLeft = blocksLeft * timePerBlock;
        double minutes = timeLeft / 1000.0 / 60.0;
        double hours = minutes / 60.0;
        System.out.println(timePerBlock + "ms per block. Time left: " + minutes + " minutes, which is " + hours + " hours");
    }

    private void saveValueFunction(ValueFunction valueFunction, String filename) {
        System.out.println("Saving value function.");
        try {
            GZIPOutputStream zipout = new GZIPOutputStream(new FileOutputStream(filename + ".gz"));
            ObjectOutputStream out = new ObjectOutputStream(zipout);
            out.writeObject(valueFunction);
            out.close();
            System.out.println("Value Function object of type " + valueFunction.getClass() + " has been written to file.\n");
        }
        catch (Exception e) {
            System.out.println("Writing value function object to file failed.\n");
            e.printStackTrace();
        }
        System.out.println("Saving value function. [done]");
    }

    private void showProperties() {
        System.out.println("ReadingMain VERSION 20060203-1631");
        System.out.println("------------ properties ----------------------");
        System.out.println("Random Seed: '" + this.randomSeed + "'");
        System.out.println("totalIterations = '" + this.totalIterations + "'");
        System.out.println("startState = " + this.startState);
        System.out.println("SENTENCE ENVIRONMENT");
        System.out.println(" sentence =  '" + this.sentence + "'");
        System.out.println(" pred  =  '" + this.predictabilities + "'");
        System.out.println(" aid =  '" + this.aidTimes + "'");
        System.out.println(" testSentence =  '" + this.testSentence + "'");
        System.out.println(" testPred  =  '" + this.testPredictabilities + "'");
        System.out.println(" testAid =  '" + this.testAidTimes + "'");
        System.out.println(" saccPrgTime = '" + this.saccPrgTime + "'");
        System.out.println(" saccadicError = '" + this.saccadicError + "'");
        System.out.println(" saccadicErrorSpread = '" + this.saccadicErrorSpread + "'");
        System.out.println(" saccadicErrorGaussian = '" + this.saccadicErrorGaussian + "'");
        System.out.println(" acuityLinearPenalize = '" + this.acuityLinearPenalize + "'");
        System.out.println(" acuityLinearPenaltySlope = '" + this.acuityLinearPenaltySlope + "'");
        System.out.println(" saccadeTimePenalty = " + this.saccadeTimePenalty);
        System.out.println(" attention = " + this.attention);
        System.out.println(" attentionGradient: ");
        System.out.println("PARALLEL_UNIFORM_ATTENTION = " + this.PARALLEL_UNIFORM_ATTENTION);
        System.out.println("PARALLEL_LINEAR_ATTENTION_GRADIENT = " + this.PARALLEL_LINEAR_ATTENTION_GRADIENT);
        System.out.println("PARALLEL_DIVIDED_ATTENTION_GRADIENT = " + this.PARALLEL_DIVIDED_ATTENTION_GRADIENT);
        System.out.println(" acuityLimit = " + this.acuityLimit);
        System.out.println("FUNCTION APPROXIMATORS");
        System.out.println(" learningRate =  '" + this.learningRate + "'");
        System.out.println(" momentum =  '" + this.momentum + "'");
        System.out.println(" hiddenLayerSize =  '" + this.hiddenLayerSize + "'");
        System.out.println(" incrementalUpdate =  '" + this.incrementalUpdate + "'");
        System.out.println(" netOutputRange =  '" + this.netOutputRange + "'");
        System.out.println(" residualWeighting = '" + this.residualWeighting + "'");
        System.out.println(" stateVectorsCrossProduct = " + this.stateVectorsCrossProduct);
        System.out.println(" stateVectorsComplement = " + this.stateVectorsComplement);
        System.out.println(" residualAlgorithm = " + this.residualAlgorithm);
        System.out.println("REINFORCEMENT LEARNING");
        System.out.println(" rlAlgorithm = '" + this.rlAlgorithm + "'");
        System.out.println(" discountFactor =  '" + this.discountFactor + "'");
        System.out.println(" epsilon =  '" + this.epsilon + "'");
        System.out.println(" greed = '" + this.greed + "'");
        System.out.println(" testTrainSameVf = '" + this.testTrainSameVf + "'");
        System.out.println("VALUE FUNCTION");
        System.out.println(" reachTerminalReinforcement =  '" + this.reachTerminalReinforcement + "'");
        System.out.println(" valueOfTerminalStates =  '" + this.valueOfTerminalStates + "'");
        System.out.println(" valueFunctionToLoad = '" + this.valueFunctionToLoad + "'");
        System.out.println(" valueFunctionToSave = '" + this.valueFunctionToSave + "'");
        System.out.println(" saveNetworkEvery = '" + this.saveNetworkEvery + "'");
        System.out.println(" valueFunctionType = " + this.valueFunctionType);
        System.out.println(" valueFunctionSafety = " + this.valueFunctionSafety);
        System.out.println(" valueFunctionStateBounds = " + this.valueFunctionStateBounds);
        System.out.println("# POLICY / REWARD SCHEDULE");
        System.out.println(" defaultReinforcement = " + this.defaultReinforcement + "");
        System.out.println(" identifyReinforcement = " + this.identifyReinforcement + "");
        System.out.println(" readingStateType = " + this.readingStateType + "");
        System.out.println(" valueOfNonStoredStates = " + this.valueOfNonStoredStates);
        System.out.println("bitPacker = '" + this.bitPacker + "'");
        System.out.println("stateActionCache = '" + this.stateActionCache + "'");
        System.out.println("# DEPRECATED");
        System.out.println(" loadWorldCache = '" + this.loadWorldCache + "'");
        System.out.println(" boundedBufferSize = '" + this.boundedBufferSize + "'");
        System.out.println("# COMPUTATION ENVIRONMENT");
        System.out.println(" agentType = " + this.agentType);
        System.out.println(" agentParallelNumThreads = " + this.agentParallelNumThreads);
        System.out.println(" distributedJavaParty = " + this.distributedJavaParty);
        System.out.println("parallelAttendableWords (if attention != serial) = " + this.parallelAttendableWords);
        System.out.println("centerOfAttention (if attention != serial) = " + this.centerOfAttention);
        System.out.println("ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = " + this.ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT);
        System.out.println("ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT = " + this.ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT);
        System.out.println("DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES = " + this.DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES);
        System.out.println("valueFunctionName = " + this.valueFunctionName);
        System.out.println("handCraftedVectors = " + this.handCraftedVectors);
    }

    private void setStateValuesTo(ValueFunction valueFunction, List states, double value) {
        double maxAllowedDelta;
        System.out.println("Making sure Terminal States have values Near 1.0");
        Iterator i = states.iterator();
        double maxDelta = maxAllowedDelta = 1.0E-4;
        while (maxDelta >= maxAllowedDelta) {
            maxDelta = 0.0;
            while (i.hasNext()) {
                State s = (State)i.next();
                valueFunction.setValue(s, value);
                double test = Math.abs(value - valueFunction.getValue(s));
                if (!(test > maxDelta)) continue;
                maxDelta = test;
            }
        }
        System.out.println("Making sure Terminal States have values Near 1.0 [Done]");
    }

    protected void loadProperties() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("reading.prop"));
            if (properties.getProperty("trainCorpusFile") != null) {
                this.loadCorpus(this.trainCorpus, properties.getProperty("trainCorpusFile"));
            }
            if (properties.getProperty("testCorpusFile") != null) {
                this.loadCorpus(this.testCorpus, properties.getProperty("testCorpusFile"));
            }
            if (properties.getProperty("agentType") != null) {
                this.agentType = properties.getProperty("agentType").trim();
            }
            if (properties.getProperty("agentParallelNumThreads") != null) {
                this.agentParallelNumThreads = new Integer(properties.getProperty("agentParallelNumThreads").trim());
                if (this.agentType.equalsIgnoreCase("serial")) {
                    System.err.println("Warning: agentParallelNumThreads specified in setup file, but agentType = serial.  Execution will be serial.");
                }
            }
            if (properties.getProperty("randomSeed") != null) {
                this.randomSeed = new Long(properties.getProperty("randomSeed").trim());
            }
            if (properties.getProperty("totalIterations") != null) {
                this.totalIterations = new Integer(properties.getProperty("totalIterations").trim());
            }
            if (properties.getProperty("residualWeighting") != null) {
                this.residualWeighting = new Double(properties.getProperty("residualWeighting").trim());
            }
            if (properties.getProperty("saccPrgTime") != null) {
                this.saccPrgTime = new Integer(properties.getProperty("saccPrgTime").trim());
            }
            if (properties.getProperty("valueFunctionSafety") != null) {
                this.valueFunctionSafety = properties.getProperty("valueFunctionSafety").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("valueFunctionStateBounds") != null) {
                this.valueFunctionStateBounds = properties.getProperty("valueFunctionStateBounds").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT") != null) {
                this.ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT = properties.getProperty("ALLOW_SIMULTANEOUS_SACREQ_AND_ATTNEXT").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT") != null) {
                this.ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT = properties.getProperty("ALLOW_SIMULTANEOUS_ATTNEXT_AND_IDENT").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("residualAlgorithm") != null) {
                this.residualAlgorithm = properties.getProperty("residualAlgorithm").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("testAgentEvery") != null) {
                this.testAgentEvery = new Integer(properties.getProperty("testAgentEvery"));
            }
            if (properties.getProperty("stateVectorsComplement") != null) {
                this.stateVectorsComplement = properties.getProperty("stateVectorsComplement").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("stateVectorsCrossProduct") != null) {
                this.stateVectorsCrossProduct = properties.getProperty("stateVectorsCrossProduct").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("incrementalUpdate") != null) {
                this.incrementalUpdate = properties.getProperty("incrementalUpdate").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("hiddenLayerSize") != null) {
                this.hiddenLayerSize = new Integer(properties.getProperty("hiddenLayerSize").trim());
            }
            if (properties.getProperty("acuityLinearPenaltySlope") != null) {
                this.acuityLinearPenaltySlope = new Integer(properties.getProperty("acuityLinearPenaltySlope").trim());
            }
            if (properties.getProperty("acuityLimit") != null) {
                this.acuityLimit = new Integer(properties.getProperty("acuityLimit").trim());
            }
            if (properties.getProperty("saveNetworkEvery") != null) {
                this.saveNetworkEvery = new Integer(properties.getProperty("saveNetworkEvery").trim());
            }
            if (properties.getProperty("boundedBufferSize") != null) {
                this.boundedBufferSize = new Integer(properties.getProperty("boundedBufferSize").trim());
            }
            if (properties.getProperty("testIterations") != null) {
                this.testIterations = new Integer(properties.getProperty("testIterations").trim());
            }
            if (properties.getProperty("parallelAttendableWords") != null) {
                this.parallelAttendableWords = new Integer(properties.getProperty("parallelAttendableWords").trim());
            }
            if (properties.getProperty("centerOfAttention") != null) {
                this.centerOfAttention = new Integer(properties.getProperty("centerOfAttention").trim());
            }
            if (properties.getProperty("saccadeTimePenalty") != null) {
                this.saccadeTimePenalty = new Integer(properties.getProperty("saccadeTimePenalty").trim());
            }
            if (properties.getProperty("netOutputRange") != null) {
                this.netOutputRange = new Double(properties.getProperty("netOutputRange").trim());
            }
            if (properties.getProperty("momentum") != null) {
                this.momentum = new Double(properties.getProperty("momentum").trim());
            }
            if (properties.getProperty("reachTerminalReinforcement") != null) {
                this.reachTerminalReinforcement = new Double(properties.getProperty("reachTerminalReinforcement").trim());
            }
            if (properties.getProperty("valueOfNonStoredStates") != null) {
                this.valueOfNonStoredStates = new Double(properties.getProperty("valueOfNonStoredStates").trim());
            }
            if (properties.getProperty("saccadicErrorSpread") != null) {
                this.saccadicErrorSpread = new Double(properties.getProperty("saccadicErrorSpread").trim());
            }
            if (properties.getProperty("greed") != null) {
                this.greed = new Double(properties.getProperty("greed").trim());
            }
            if (properties.getProperty("valueOfTerminalStates") != null) {
                this.valueOfTerminalStates = new Double(properties.getProperty("valueOfTerminalStates"));
            }
            if (properties.getProperty("defaultReinforcement") != null) {
                this.defaultReinforcement = new Double(properties.getProperty("defaultReinforcement").trim());
            }
            if (properties.getProperty("identifyReinforcement") != null) {
                this.identifyReinforcement = new Double(properties.getProperty("identifyReinforcement").trim());
            }
            if (properties.getProperty("discountFactor") != null) {
                this.discountFactor = new Double(properties.getProperty("discountFactor").trim());
            }
            if (properties.getProperty("epsilon") != null) {
                this.epsilon = new Double(properties.getProperty("epsilon").trim());
            }
            if (properties.getProperty("learningRate") != null) {
                this.learningRate = new Double(properties.getProperty("learningRate").trim());
            }
            if (properties.getProperty("valueFunctionType") != null) {
                this.valueFunctionType = properties.getProperty("valueFunctionType").trim();
            }
            if (properties.getProperty("registerWithBitMapper") != null && properties.getProperty("registerWithBitMapper").trim().equalsIgnoreCase("true")) {
                throw new RuntimeException("\nRegisterWithBitMapper is no longer used; state vectors are now provided by the state objects themselves rather than an external utility class.");
            }
            if (properties.getProperty("distributedJavaParty") != null) {
                this.distributedJavaParty = properties.getProperty("distributedJavaParty").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("saccadicErrorGaussian") != null) {
                this.saccadicErrorGaussian = properties.getProperty("saccadicErrorGaussian").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("handCraftedVectors") != null) {
                if (properties.getProperty("handCraftedVectors").trim().equalsIgnoreCase("true")) {
                    this.handCraftedVectors = true;
                    System.out.println("@@@@@@@@@@@ WARNING @@@@@@@@@@@@");
                    System.out.println("Hand Crafted Vectors are likely to produce bizarre results.");
                    System.out.println("@@@@@ WARNING END @@@@@@");
                } else {
                    this.handCraftedVectors = false;
                }
            }
            if (properties.getProperty("testTrainSameVf") != null) {
                if (properties.getProperty("testTrainSameVf").trim().equalsIgnoreCase("true")) {
                    this.testTrainSameVf = true;
                    if (this.valueFunctionType.equalsIgnoreCase("LookupTable")) {
                        System.out.println("@@@@@ WARNING @@@@@@");
                        System.out.println("Usually,  with lookup tables, you want to testAndTrainSameVf=false, to proceed on ");
                        System.out.println("different value functions during learning (swap)");
                        System.out.println("@@@@@ WARNING END @@@@@@");
                    }
                } else {
                    this.testTrainSameVf = false;
                    if (!this.valueFunctionType.equalsIgnoreCase("LookupTable")) {
                        System.out.println("@@@@@ WARNING @@@@@@");
                        System.out.println("Usually, with function approximators, you want to testAndTrainSameVf=true, i.e. on\nthe SAME value functions during learning (swap)");
                        System.out.println("@@@@@ WARNING END @@@@@@");
                    }
                }
            }
            if (properties.getProperty("bitPacker") != null) {
                this.bitPacker = properties.getProperty("bitPacker").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("saccadicError") != null) {
                this.saccadicError = properties.getProperty("saccadicError").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("attention") != null) {
                this.attention = properties.getProperty("attention");
            }
            if (properties.getProperty("attentionGradient") != null) {
                if (properties.getProperty("attentionGradient").trim().equalsIgnoreCase("uniform")) {
                    this.PARALLEL_UNIFORM_ATTENTION = true;
                    this.PARALLEL_LINEAR_ATTENTION_GRADIENT = false;
                    this.PARALLEL_DIVIDED_ATTENTION_GRADIENT = false;
                } else if (properties.getProperty("attentionGradient").trim().equalsIgnoreCase("linear")) {
                    this.PARALLEL_UNIFORM_ATTENTION = false;
                    this.PARALLEL_LINEAR_ATTENTION_GRADIENT = true;
                    this.PARALLEL_DIVIDED_ATTENTION_GRADIENT = false;
                } else if (properties.getProperty("attentionGradient").trim().equalsIgnoreCase("divided")) {
                    this.PARALLEL_UNIFORM_ATTENTION = false;
                    this.PARALLEL_LINEAR_ATTENTION_GRADIENT = false;
                    this.PARALLEL_DIVIDED_ATTENTION_GRADIENT = true;
                } else {
                    throw new RuntimeException("Unrecognized attentionGradient parameter: " + properties.getProperty("attentionGradient") + ".  Try unform, linear or divided.");
                }
                if (this.attention.equals("serial")) {
                    System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                    System.out.println("WARNING: In serial mode, it is meaningless to set the attention gradient.");
                    System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                }
            } else if (!this.attention.equals("serial")) {
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
                System.out.println("WARNING: In nonserial mode, you should probably set an attention gradient.");
                System.out.println("@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@");
            }
            if (properties.getProperty("updateOnlyWhenGreedy") != null) {
                this.updateOnlyWhenGreedy = properties.getProperty("updateOnlyWhenGreedy").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("acuityLinearPenalize") != null) {
                this.acuityLinearPenalize = properties.getProperty("acuityLinearPenalize").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("stateActionCache") != null) {
                this.stateActionCache = properties.getProperty("stateActionCache").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("sentence") != null) {
                this.predictabilities = properties.getProperty("pred").trim();
                this.aidTimes = properties.getProperty("aid").trim();
                this.sentence = properties.getProperty("sentence").trim();
                if (properties.getProperty("lengths") != null) {
                    this.wordLengths = properties.getProperty("lengths").trim();
                    this.wordLengthsOverridden = true;
                }
            }
            if (properties.getProperty("testSentence") != null) {
                this.testPredictabilities = properties.getProperty("testPred").trim();
                this.testAidTimes = properties.getProperty("testAid").trim();
                this.testSentence = properties.getProperty("testSentence").trim();
                if (properties.getProperty("testLengths") != null) {
                    this.testWordLengths = properties.getProperty("testLengths").trim();
                    this.testWordLengthsOverridden = true;
                }
            }
            if (properties.getProperty("valueFunctionToLoad") != null) {
                this.valueFunctionToLoad = properties.getProperty("valueFunctionToLoad").trim();
            }
            if (properties.getProperty("wrapSerialValueFunctionWithParallelAdapter") != null) {
                this.wrapSerialValueFunctionWithParallelAdapter = properties.getProperty("wrapSerialValueFunctionWithParallelAdapter").trim().equalsIgnoreCase("true");
            }
            if (properties.getProperty("valueFunctionToSave") != null) {
                this.valueFunctionToSave = properties.getProperty("valueFunctionToSave").trim();
            }
            if (properties.getProperty("startState") != null) {
                this.startState = properties.getProperty("startState");
            }
            if (properties.getProperty("loadWorldCache") != null) {
                this.loadWorldCache = properties.getProperty("loadWorldCache").trim();
            }
            if (properties.getProperty("readingStateType") != null) {
                this.readingStateType = properties.getProperty("readingStateType").trim();
                if (!this.readingStateType.equalsIgnoreCase("Absolute") && !this.readingStateType.equalsIgnoreCase("Relative")) {
                    throw new RuntimeException("Reading State Type must either be relative or absolute.");
                }
            }
            if (properties.getProperty("rlAlgorithm") != null) {
                this.rlAlgorithm = properties.getProperty("rlAlgorithm").trim();
            }
            if (properties.getProperty("DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES") != null) {
                this.DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES = properties.getProperty("DYNAMICALLY_LOAD_VALUE_FUNCTION_PATCHES").equalsIgnoreCase("true");
            }
            if (properties.getProperty("valueFunctionName") != null) {
                this.valueFunctionName = properties.getProperty("valueFunctionName").trim();
            }
        }
        catch (Exception e) {
            System.out.println("Problem processing 'reading.prop' properties file, stopping.");
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

