/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import java.util.ArrayList;
import net.pakl.rl.Action;

public class ReadingAction
implements Action {
    protected boolean requestingSaccade = false;
    protected boolean attendNextWord = false;
    protected int saccadeRequestDistance = 0;
    protected boolean attendThisWord = true;
    protected boolean remainHere = false;
    public static final int MAXIMUM_SACCADE_DISTANCE = 10;
    private boolean SAFE_MODE = false;

    public void copyFrom(ReadingAction o) {
        this.requestingSaccade = o.requestingSaccade;
        this.attendNextWord = o.attendNextWord;
        this.saccadeRequestDistance = o.saccadeRequestDistance;
        this.attendThisWord = o.attendThisWord;
        this.remainHere = o.remainHere;
    }

    public static void main(String[] args) {
        ReadingAction.test();
    }

    public static void test() {
        ArrayList uniques = new ArrayList();
        ReadingAction ra = new ReadingAction();
        ra.setRequestingSaccade(true);
        ra.setAttendNextWord(false);
        ra.setRequestingSaccade(true);
        for (int i = -10; i <= 10; ++i) {
            ra.setSaccadeRequestDistance(i);
            ReadingAction.check(uniques, ra);
        }
        ra.setRequestingSaccade(false);
        ra.setAttendNextWord(true);
        ReadingAction.check(uniques, ra);
        ra.setRequestingSaccade(false);
        ra.setAttendNextWord(false);
        ra.setAttendThisWord(true);
        ReadingAction.check(uniques, ra);
        ra.setRequestingSaccade(false);
        ra.setAttendNextWord(false);
        ra.setAttendThisWord(false);
        ra.setRemainHere(true);
        ReadingAction.check(uniques, ra);
        ra = new ReadingAction();
        ra.setAttendNextWord(true);
        ra.setAttendThisWord(false);
        ReadingAction.check(uniques, ra);
    }

    public static void check(ArrayList uniques, ReadingAction ra) {
        System.out.println(ra + "\t" + ra.uniqueCode());
        int uniqueCode = ra.uniqueCode();
        Integer i = new Integer(uniqueCode);
        if (uniques.contains(i)) {
            throw new RuntimeException("Fails.");
        }
        uniques.add(i);
    }

    public int uniqueCode() {
        if (this.SAFE_MODE && this.isRequestingSaccade() && this.isAttendNextWord()) {
            System.out.println(this);
            System.out.println("isRequestingSaccade() = " + this.isRequestingSaccade());
            System.out.println("isAttendNextWord() = " + this.isAttendNextWord());
            throw new RuntimeException("Unique Action Code not defined for both request saccade and attend word shift.");
        }
        int result = 0;
        if (this.isRequestingSaccade()) {
            ++result;
        }
        if (this.isAttendNextWord()) {
            result += 2;
        }
        if (this.isAttendThisWord()) {
            result += 4;
        }
        if (this.isRemainHere()) {
            result += 8;
        }
        int jumpCode = 20 + this.getSaccadeRequestDistance();
        if (this.SAFE_MODE && jumpCode < 0) {
            throw new RuntimeException("Got negative jump code; cannot tolerate that for unique action codes.");
        }
        if (this.isRequestingSaccade()) {
            result = result + 15 + jumpCode;
        }
        return result;
    }

    public int hashCode() {
        int result = 0;
        if (this.isRequestingSaccade()) {
            ++result;
        }
        if (this.isAttendNextWord()) {
            result += 2;
        }
        if (this.isAttendThisWord()) {
            result += 4;
        }
        if (this.isRemainHere()) {
            result += 8;
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o instanceof ReadingAction) {
            ReadingAction other = (ReadingAction)o;
            if (this.isRequestingSaccade() != other.isRequestingSaccade()) {
                return false;
            }
            if (this.isAttendNextWord() != other.isAttendNextWord()) {
                return false;
            }
            if (this.isAttendThisWord() != other.isAttendThisWord()) {
                return false;
            }
            if (this.isRemainHere() != other.isRemainHere()) {
                return false;
            }
            return this.getSaccadeRequestDistance() == other.getSaccadeRequestDistance();
        }
        return false;
    }

    public String toString() {
        String result = "ACTION: ";
        if (this.isRemainHere()) {
            result = result + "Remain|";
        }
        if (this.isRequestingSaccade()) {
            result = result + "ReqSacc" + this.saccadeRequestDistance + "|";
        }
        if (this.isAttendNextWord()) {
            result = result + "AttNext|";
        }
        if (this.attendingWord()) {
            result = result + "Ident|";
        }
        return result;
    }

    public boolean attendingWord() {
        return this.attendThisWord;
    }

    public boolean isRequestingSaccade() {
        return this.requestingSaccade;
    }

    public ReadingAction setRequestingSaccade(boolean requestingSaccade) {
        this.requestingSaccade = requestingSaccade;
        return this;
    }

    public boolean isAttendNextWord() {
        return this.attendNextWord;
    }

    public ReadingAction setAttendNextWord(boolean attendNextWord) {
        this.attendNextWord = attendNextWord;
        return this;
    }

    public int getSaccadeRequestDistance() {
        return this.saccadeRequestDistance;
    }

    public ReadingAction setSaccadeRequestDistance(int saccadeRequestDistance) {
        this.saccadeRequestDistance = saccadeRequestDistance;
        return this;
    }

    public boolean isAttendThisWord() {
        return this.attendThisWord;
    }

    public ReadingAction setAttendThisWord(boolean attendThisWord) {
        this.attendThisWord = attendThisWord;
        return this;
    }

    public boolean isRemainHere() {
        return this.remainHere;
    }

    public ReadingAction setRemainHere(boolean remainHere) {
        this.remainHere = remainHere;
        return this;
    }
}

