/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.reading;

import net.pakl.rl.State;
import net.pakl.rl.ValueFunction;
import net.pakl.rl.World;
import org.eyelanguage.rl.reading.ReadingStateParallelRelative;
import org.eyelanguage.rl.reading.ReadingStateRelative;
import org.eyelanguage.rl.reading.SentenceWorldParallel;

public class ParallelToSerialVFAdapter
implements ValueFunction {
    ValueFunction adaptedValueFunction;
    public final double SERIAL_ATTEND_INTERVAL = 5.0;

    public ParallelToSerialVFAdapter(ValueFunction vf) {
        this.adaptedValueFunction = vf;
    }

    public void setWorld(World w) {
        this.adaptedValueFunction.setWorld(w);
    }

    public double getValue(State state) {
        ReadingStateRelative converted = this.convertParallelToSerial((ReadingStateParallelRelative)state);
        return this.adaptedValueFunction.getValue(converted);
    }

    public ReadingStateRelative convertParallelToSerial(ReadingStateParallelRelative s) {
        ReadingStateRelative result = new ReadingStateRelative();
        result.copyFrom(s);
        double temp = (double)result.getTimeAttending() / 5.0;
        temp = Math.floor(temp);
        result.setTimeAttending((int)(temp * 5.0));
        if (SentenceWorldParallel.CENTER_OF_ATTENTION != 0) {
            if (SentenceWorldParallel.CENTER_OF_ATTENTION == 1) {
                int newEccentricity = s.getDistanceFromAttendCenter() + (1 + (s.attWindowLengths[0] + s.attWindowLengths[1]) / 2);
                result.setDistanceFromAttendCenter(newEccentricity);
            } else {
                throw new RuntimeException("No code to handle center of attention of " + SentenceWorldParallel.CENTER_OF_ATTENTION);
            }
        }
        return result;
    }

    public String getName() {
        return this.adaptedValueFunction.getName();
    }

    public void setName(String name) {
        throw new RuntimeException("Adaptor is read-only.");
    }

    public void setValue(State state, double newValue) {
        throw new RuntimeException("Adaptor is read-only.");
    }

    public void setValueOfTerminalStates(double newValueOfTerminalStates) {
        throw new RuntimeException("Adaptor is read-only.");
    }

    public void setValueOfOutOfBoundsStates(double newValueOfOutOfBoundsStates) {
        throw new RuntimeException("Adaptor is read-only.");
    }
}

