/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.analysis;

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.zip.GZIPInputStream;
import net.pakl.rl.State;
import net.pakl.rl.ValueFunctionHashMap;
import net.pakl.rl.VectorTools;
import org.eyelanguage.rl.reading.ReadingStateRelative;

public class ValueFunctionDumper {
    public static void main(String[] args) throws Exception {
        String filename = args[0];
        ValueFunctionHashMap vf = ValueFunctionDumper.loadValueFunction(filename);
        Iterator states = vf.getKeySetIterator();
        while (states.hasNext()) {
            State s = (State)states.next();
            ReadingStateRelative rs = (ReadingStateRelative)s;
            System.out.println(ValueFunctionDumper.pad(s.toString(), 150, " ") + "\t[" + VectorTools.vectorToText(rs.doubleRepresentation()) + "]\t= " + vf.getValue(s));
        }
    }

    public static ValueFunctionHashMap loadValueFunction(String filename) throws Exception {
        ObjectInputStream ois = null;
        if (filename.endsWith(".gz")) {
            System.err.println("Opening compressed object stream.");
            ois = new ObjectInputStream(new GZIPInputStream(new FileInputStream(filename)));
        } else {
            System.err.println("Opening noncompressed object stream.");
            ois = new ObjectInputStream(new FileInputStream(filename));
        }
        System.err.println("Reading value function object into memory.");
        ValueFunctionHashMap vf = (ValueFunctionHashMap)ois.readObject();
        return vf;
    }

    private static String pad(Object str, int padlen, String pad) {
        String padding = new String();
        int len = Math.abs(padlen) - str.toString().length();
        if (len < 1) {
            return str.toString();
        }
        for (int i = 0; i < len; ++i) {
            padding = padding + pad;
        }
        return padlen < 0 ? padding + str : str + padding;
    }
}

