/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.analysis;

import net.pakl.rl.PolicyExtractor;
import net.pakl.rl.ValueFunctionHashMap;
import org.eyelanguage.rl.analysis.ValueFunctionDumper;
import org.eyelanguage.rl.reading.ReadingMain;
import org.eyelanguage.rl.reading.ReadingPolicy;
import org.eyelanguage.rl.reading.ReadingReinforcementFunction;
import org.eyelanguage.rl.reading.ReadingStateFactory;
import org.eyelanguage.rl.reading.ReadingStateRelative;
import org.eyelanguage.rl.reading.SentenceWorld;
import org.eyelanguage.rl.reading.Toolbox;

public class OptimalActionsLister
extends ReadingMain {
    public static void main(String[] args) {
        try {
            new OptimalActionsLister().run(args);
        }
        catch (Exception e) {
            System.out.println("Sorry, an error occured:  " + e.getMessage());
        }
    }

    public void run(String[] args) throws Exception {
        String valueFunctionFilename = args[0];
        String startingStateString = args[1];
        this.loadProperties();
        SentenceWorld sWorld = this.recreateSentenceWorld();
        ReadingPolicy readingPolicy = Toolbox.createSimpleReadingPolicy(sWorld);
        ReadingReinforcementFunction rf = new ReadingReinforcementFunction(sWorld);
        rf.setDefaultReinforcement(this.defaultReinforcement);
        rf.setRewardForSuccessfulIdentification(this.identifyReinforcement);
        rf.setReinforcementsForActionsOntoTerminalState(this.reachTerminalReinforcement);
        PolicyExtractor extractor = new PolicyExtractor();
        ValueFunctionHashMap vf = ValueFunctionDumper.loadValueFunction(valueFunctionFilename);
        ReadingStateRelative startState = new ReadingStateRelative();
        startState.parseString(startingStateString);
        extractor.forceInitialState(startState);
        throw new RuntimeException("discountFactor must be entered here");
    }

    public SentenceWorld recreateSentenceWorld() {
        SentenceWorld sWorld = new SentenceWorld("environment", this.randomSeed);
        sWorld.setupReadingStateFactory(ReadingStateFactory.RELATIVE_READING_STATES);
        sWorld.setMAX_SACCADE_PROG_TIME(this.saccPrgTime);
        sWorld.SACCADIC_ERROR = this.saccadicError;
        sWorld.SACCADIC_ERROR_GAUSSIAN = this.saccadicErrorGaussian;
        sWorld.SACCADIC_ERROR_SPREAD = this.saccadicErrorSpread;
        sWorld.ACUITY_LINEAR_PENALIZE = this.acuityLinearPenalize;
        sWorld.SACCADE_TIME_PENALTY = this.saccadeTimePenalty;
        sWorld.setSentence(this.sentence, this.predictabilities, this.aidTimes);
        if (!sWorld.getIsBuilt()) {
            sWorld.build();
        }
        return sWorld;
    }
}

