/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.analysis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogAnalyzer {
    public static boolean SKIP_INTERNAL_ANALYSIS = false;
    public static boolean ENABLE_FIXATION_SPACE_BEFORE_WORD = true;
    public static boolean EXCLUDE_LAST_WORD_FROM_ANALYSIS = true;
    public static boolean EXCLUDE_FIRST_WORD_FROM_ANALYSIS = true;
    public static final int MS_PER_TIMESTEP = 5;
    int lastWordID = 0;

    public LogAnalyzer(String logFileName) throws Exception {
        this.process(logFileName);
    }

    public LogAnalyzer() {
    }

    protected void process(String logFileName) throws Exception {
        BufferedReader inputFile = new BufferedReader(new FileReader(logFileName));
        int count = 0;
        HashMap wordLenToInitialFixationPos = new HashMap();
        HashMap wordLenToRefixationPos = new HashMap();
        HashMap wordLenToAttIdDuration = new HashMap();
        HashMap wordLenToFixationDuration = new HashMap();
        HashMap wordLenToAttSaccreqDuration = new HashMap();
        HashMap wordLenToFixationDurations = new HashMap();
        HashMap wordLenToGazeDurations = new HashMap();
        HashMap wordLenToRefixations = new HashMap();
        HashMap wordLenToSkips = new HashMap();
        ArrayList fixationDurations = new ArrayList();
        double numFixated = 0.0;
        double numAttended = 0.0;
        double numSkipped = 0.0;
        ArrayList refixations = new ArrayList();
        HashMap preSacOFFReqFixTimeFromFirstFixation = new HashMap();
        HashMap preSacOFFReqFixTimeFromRefixation = new HashMap();
        ArrayList<String> statesDump = new ArrayList<String>();
        while (inputFile.ready()) {
            ++count;
            List<String> visitedStates = this.loadVisitedStates(inputFile);
            List<Integer> attendedWordIDs = this.extractValues("attWid", visitedStates);
            HashSet<Integer> attWIDHash = new HashSet<Integer>();
            attWIDHash.addAll(attendedWordIDs);
            this.lastWordID = attWIDHash.size() - 1;
            List<Integer> eyePositions = this.extractValues("eyepos", visitedStates);
            List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
            List<Integer> intendedSaccadeDistance = null;
            try {
                intendedSaccadeDistance = this.extractValues("sacDst", visitedStates);
            }
            catch (Exception e) {
                intendedSaccadeDistance = this.extractValues("sacReqDst", visitedStates);
            }
            if (!SKIP_INTERNAL_ANALYSIS) {
                HashSet<Integer> fixWIDHash = new HashSet<Integer>();
                fixWIDHash.addAll(fixatedWordIDs);
                System.out.println("LastWordID: " + this.lastWordID);
                this.appendWordLenToInitialFixationPos(wordLenToInitialFixationPos, visitedStates);
                this.appendWordLenToAllReFixationPos(wordLenToRefixationPos, visitedStates);
                this.appendWordLenToRefixationCount(wordLenToRefixations, visitedStates);
                this.appendWordLenToSkipCount(wordLenToSkips, visitedStates);
                this.appendLengthToGazeDurations(wordLenToGazeDurations, visitedStates);
                this.appendLengthToAttWidTimestepCounts(wordLenToAttIdDuration, "ID'd?=false", visitedStates);
                this.appendLengthToAttWidTimestepCounts(wordLenToAttIdDuration, "identified=false", visitedStates);
                this.appendLengthToAttWidTimestepCounts(wordLenToAttSaccreqDuration, "sacPrg=false", visitedStates);
                this.appendLengthToFixationDurations(wordLenToFixationDurations, visitedStates);
                this.appendFixationDurations(fixationDurations, visitedStates);
                this.appendRefixations(refixations, visitedStates);
                this.appendPresaccadeOFFRequestFixTime(preSacOFFReqFixTimeFromFirstFixation, preSacOFFReqFixTimeFromRefixation, visitedStates);
                numFixated += (double)fixWIDHash.size();
                numAttended += (double)attWIDHash.size();
                numSkipped += (double)(attWIDHash.size() - fixWIDHash.size());
            }
            statesDump.add("T,Eye,IntendSacc,AttWord,FixWord");
            for (int v = 0; v < visitedStates.size(); ++v) {
                statesDump.add(v + "," + eyePositions.get(v) + "," + intendedSaccadeDistance.get(v) + "," + attendedWordIDs.get(v) + "," + fixatedWordIDs.get(v));
            }
        }
        if (!SKIP_INTERNAL_ANALYSIS) {
            Iterator j;
            List v;
            System.out.println("*** Initial Fixation Landing Sites");
            for (Object k : wordLenToInitialFixationPos.keySet()) {
                System.out.print("Initial fixation, len " + k + ": ");
                v = (List)wordLenToInitialFixationPos.get(k);
                j = v.iterator();
                while (j.hasNext()) {
                    System.out.print(j.next() + " ");
                }
                System.out.println("");
            }
            System.out.println("");
            System.out.println("*** Refixation Landing Sites");
            for (Object k : wordLenToRefixationPos.keySet()) {
                System.out.print("Refixation, len " + k + ": ");
                v = (List)wordLenToRefixationPos.get(k);
                j = v.iterator();
                while (j.hasNext()) {
                    System.out.print(j.next() + " ");
                }
                System.out.println("");
            }
            System.out.println("");
            System.out.print("Average fixation duration was: " + this.average(fixationDurations) + " ms");
            System.out.println(" (" + this.average(fixationDurations) / 5.0 + " time steps)");
            System.out.println("Average fixation time before SacReq OFF FIXATED WORD (initial fix)= " + this.sortedPrint(this.averageForKeys(preSacOFFReqFixTimeFromFirstFixation)) + "");
            System.out.println("Average fixation time before SacReq OFF FIXATED WORD (refixation )= " + this.sortedPrint(this.averageForKeys(preSacOFFReqFixTimeFromRefixation)) + "");
            System.out.println("Num words attended = " + numAttended);
            System.out.println("Num words fixated  = " + numFixated + " (" + 100.0 * numFixated / numAttended + "%)");
            System.out.println("Num words skipped  = " + numSkipped + " (" + 100.0 * numSkipped / numAttended + "%)");
            double numRefixated = refixations.size();
            System.out.println("Num of refixations = " + numRefixated + " (" + 100.0 * numRefixated / numFixated + "%)");
            System.out.println("\n***Average Time spent Attending Words (by word length):" + this.sortedPrint(this.averageForKeys(wordLenToAttIdDuration)));
            System.out.println("***Average Time Attending Words before Saccade Programming Request (by word length):" + this.sortedPrint(this.averageForKeys(wordLenToAttSaccreqDuration)));
            System.out.println("***Average Time spent Fixating Words (by word length): " + this.sortedPrint(this.averageForKeys(wordLenToFixationDurations)));
            System.out.println("***Average total gaze durations (by word length): " + this.sortedPrint(this.averageForKeys(wordLenToGazeDurations)));
            System.out.println("***Skip counts (by word length): " + this.sortedPrint(wordLenToSkips));
            System.out.println("***Refixation counts (by word length): " + this.sortedPrint(wordLenToRefixations));
            System.out.println("\nBreak it down, yo!");
            System.out.println("***How long was each word attended? (by word length): " + this.sortedPrint(wordLenToAttIdDuration));
            System.out.println("***How long was each word attended *before* a saccade request?: " + this.sortedPrint(wordLenToAttSaccreqDuration));
            System.out.println("***Fixation durations for each word length: " + this.sortedPrint(wordLenToFixationDurations));
            System.out.println("***Timesteps from Initial Fixation before Off-word Saccade Request: " + this.sortedPrint(preSacOFFReqFixTimeFromFirstFixation));
            System.out.println("***Timesteps from Refixation before Off-word Saccade Request: " + this.sortedPrint(preSacOFFReqFixTimeFromRefixation));
            System.out.println("***Total Gaze durations for each word length: " + this.sortedPrint(wordLenToGazeDurations));
        }
        System.out.println("Dump of visited states\n");
        for (int v = 0; v < statesDump.size(); ++v) {
            System.out.println(statesDump.get(v));
        }
    }

    private String sortedPrint(HashMap h) {
        String result = "";
        ArrayList keys = new ArrayList();
        keys.addAll(h.keySet());
        Collections.sort(keys);
        for (Object key : keys) {
            result = result + "\n";
            result = result + key + ": ";
            result = result + h.get(key);
        }
        return result + "\n";
    }

    private HashMap averageForKeys(HashMap h) {
        HashMap result = new HashMap();
        for (Object key : h.keySet()) {
            List values = (List)h.get(key);
            Iterator j = values.iterator();
            double count = 0.0;
            double sum = 0.0;
            while (j.hasNext()) {
                count += 1.0;
                double value = Double.parseDouble(j.next() + "");
                sum += value;
            }
            result.put(key, new Double(sum / count));
        }
        return result;
    }

    private void appendRefixations(List refixations, List visitedStates) {
        List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
        List<Integer> saccadeDistances = this.extractValues("sacDst", visitedStates);
        Integer previous = null;
        HashSet<Integer> alreadyFixatedIDs = new HashSet<Integer>();
        for (int i = 0; i < saccadeDistances.size(); ++i) {
            Integer current = saccadeDistances.get(i);
            Integer fixatedWordID = fixatedWordIDs.get(i);
            if (previous != null && previous != 0 && current == 0) {
                if (!(!alreadyFixatedIDs.contains(fixatedWordID) || !this.justLanded(visitedStates, i) || EXCLUDE_LAST_WORD_FROM_ANALYSIS && fixatedWordID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && fixatedWordID == 0)) {
                    refixations.add(visitedStates.get(i));
                }
                if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && fixatedWordID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && fixatedWordID == 0)) {
                    alreadyFixatedIDs.add(fixatedWordID);
                }
            }
            previous = current;
        }
    }

    private void appendPresaccadeOFFRequestFixTime(HashMap resultFromFirstFixation, HashMap resultFromRefixation, List visitedStates) {
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
        List<Integer> saccadeDistances = this.extractValues("sacDst", visitedStates);
        Integer previousDist = null;
        Integer previousWID = null;
        Integer currentWID = null;
        HashSet<Integer> hasBeenRefixated = new HashSet<Integer>();
        HashSet<Integer> hasBeenFixated = new HashSet<Integer>();
        int fixationTimeBeforeSacReq = 0;
        for (int i = 0; i < saccadeDistances.size(); ++i) {
            Integer currentDist = saccadeDistances.get(i);
            currentWID = fixatedWordIDs.get(i);
            if (previousDist != null) {
                if (previousDist == 0 && currentDist != 0 && this.ifOffWordSaccadeRequest(i, visitedStates)) {
                    fixationTimeBeforeSacReq += 5;
                    System.out.println("\nSACREQOFF: " + visitedStates.get(i));
                    if (hasBeenRefixated.contains(currentWID)) {
                        if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && currentWID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && currentWID == 0)) {
                            this.mapOfListsAppend(resultFromRefixation, wordIDToWordLength.get(currentWID), new Double(fixationTimeBeforeSacReq / 5));
                        }
                    } else if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && currentWID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && currentWID == 0)) {
                        this.mapOfListsAppend(resultFromFirstFixation, wordIDToWordLength.get(currentWID), new Double(fixationTimeBeforeSacReq / 5));
                    }
                    System.out.println("So fix time for len " + wordIDToWordLength.get(currentWID) + " is  " + fixationTimeBeforeSacReq / 5);
                    fixationTimeBeforeSacReq = 0;
                } else {
                    fixationTimeBeforeSacReq += 5;
                }
                if (this.justLanded(visitedStates, i)) {
                    fixationTimeBeforeSacReq = 0;
                    if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && currentWID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && currentWID == 0)) {
                        if (hasBeenFixated.contains(currentWID)) {
                            hasBeenRefixated.add(currentWID);
                        }
                        hasBeenFixated.add(currentWID);
                    }
                }
            }
            previousDist = currentDist;
            previousWID = currentWID;
        }
    }

    private void appendWordLenToRefixationCount(HashMap result, List visitedStates) {
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
        List<Integer> sacDst = this.extractValues("sacDst", visitedStates);
        Iterator<Integer> w = wordIDToWordLength.keySet().iterator();
        int fixationCount = 1;
        if (EXCLUDE_FIRST_WORD_FROM_ANALYSIS) {
            fixationCount = 0;
        }
        while (w.hasNext()) {
            Integer wid = w.next();
            if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && wid == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && wid == 0)) {
                for (int i = 1; i < visitedStates.size(); ++i) {
                    if (!wid.equals(fixatedWordIDs.get(i)) || !((Object)sacDst.get(i)).equals(new Double(0.0)) || ((Object)sacDst.get(i - 1)).equals(new Double(0.0))) continue;
                    System.out.println("Word ID " + wid + " was fixated:\n" + visitedStates.get(i - 1) + "\n" + visitedStates.get(i));
                    ++fixationCount;
                }
                if (fixationCount > 1) {
                    this.mapOfListsAppend(result, wordIDToWordLength.get(wid), new Double(fixationCount - 1));
                }
            }
            fixationCount = 0;
        }
    }

    private void appendWordLenToSkipCount(HashMap result, List visitedStates) {
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
        for (Integer wid : wordIDToWordLength.keySet()) {
            boolean found = false;
            for (int i = 0; i < visitedStates.size(); ++i) {
                if (!wid.equals(fixatedWordIDs.get(i))) continue;
                found = true;
            }
            if (found || EXCLUDE_LAST_WORD_FROM_ANALYSIS && wid == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && wid == 0) continue;
            this.mapOfListsAppend(result, wordIDToWordLength.get(wid), new Double(1.0));
        }
    }

    private void appendLengthToGazeDurations(HashMap result, List visitedStates) {
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
        for (Integer wid : wordIDToWordLength.keySet()) {
            int gaze = -1;
            for (int i = 0; i < visitedStates.size(); ++i) {
                if (!wid.equals(fixatedWordIDs.get(i))) continue;
                ++gaze;
            }
            if (gaze <= 0 || EXCLUDE_LAST_WORD_FROM_ANALYSIS && wid == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && wid == 0) continue;
            this.mapOfListsAppend(result, wordIDToWordLength.get(wid), new Double(gaze));
        }
    }

    private void appendLengthToFixationDurations(HashMap result, List visitedStates) {
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
        int fixationDuration = 0;
        Integer previous = null;
        for (int i = 0; i < fixatedWordIDs.size(); ++i) {
            Integer fixatedWordID = fixatedWordIDs.get(i);
            if (previous != null) {
                if (fixatedWordID.equals(previous) && !this.justLanded(visitedStates, i)) {
                    fixationDuration += 5;
                    System.out.println(i + " fix");
                }
                if (fixatedWordID.equals(previous) && this.justLanded(visitedStates, i)) {
                    System.out.println(i + " REfix wid=" + fixatedWordID);
                    if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && previous == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && previous == 0)) {
                        this.mapOfListsAppend(result, wordIDToWordLength.get(previous), new Double(fixationDuration / 5));
                    }
                    fixationDuration = 0;
                }
                if (!fixatedWordID.equals(previous)) {
                    if (this.justLanded(visitedStates, i)) {
                        System.out.println(i + " land wid=" + fixatedWordID);
                    }
                    if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && previous == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && previous == 0)) {
                        this.mapOfListsAppend(result, wordIDToWordLength.get(previous), new Double(fixationDuration / 5));
                    }
                    fixationDuration = 0;
                }
            }
            previous = fixatedWordID;
        }
        if (!(result == null || wordIDToWordLength.get(previous) == null || EXCLUDE_LAST_WORD_FROM_ANALYSIS && previous == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && previous == 0)) {
            this.mapOfListsAppend(result, wordIDToWordLength.get(previous), new Double(fixationDuration / 5));
        }
    }

    private void appendFixationDurations(List result, List visitedStates) {
        List<Integer> fixatedWordIDs = this.extractValues("fixWid", visitedStates);
        int fixationDuration = 0;
        Integer previous = null;
        for (int i = 0; i < fixatedWordIDs.size(); ++i) {
            Integer fixatedWordID = fixatedWordIDs.get(i);
            if (previous != null) {
                if (fixatedWordID.equals(previous) && !this.justLanded(visitedStates, i)) {
                    fixationDuration += 5;
                } else {
                    if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && fixatedWordID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && fixatedWordID == 0)) {
                        result.add(new Double(fixationDuration));
                    }
                    fixationDuration = 0;
                }
            }
            previous = fixatedWordID;
        }
    }

    private boolean justLanded(List visitedStates, int current) {
        if (current > 0) {
            String past = (String)visitedStates.get(current - 1);
            String present = (String)visitedStates.get(current);
            if (present.indexOf("sacPrg=false") > -1 && past.indexOf("sacPrg=true") > -1) {
                return true;
            }
        }
        return false;
    }

    private List removeIDTrue(List x) {
        ArrayList result = new ArrayList();
        for (int i = 0; i < x.size(); ++i) {
            if (((String)x.get(i)).indexOf("ID'd?=true") == -1) {
                result.add(x.get(i));
            }
            if (((String)x.get(i)).indexOf("identified=true") != -1) continue;
            result.add(x.get(i));
        }
        return result;
    }

    private void appendLengthToAttWidTimestepCounts(HashMap result, String key, List visitedStates) {
        List<Integer> attWID = this.extractValues("attWid", visitedStates);
        if (attWID.size() == 0) {
            return;
        }
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        System.out.println("Searching for key " + key);
        int i = 1;
        while (i < attWID.size()) {
            int wid;
            int previousWid = wid = attWID.get(i).intValue();
            int timesteps = 0;
            while (wid == previousWid) {
                System.out.print(".");
                if (((String)visitedStates.get(i)).indexOf(key) > -1) {
                    ++timesteps;
                }
                if (++i >= attWID.size()) break;
                previousWid = wid;
                wid = attWID.get(i);
            }
            if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && previousWid == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && previousWid == 0) continue;
            this.mapOfListsAppend(result, wordIDToWordLength.get(previousWid), new Double(timesteps));
        }
    }

    private void appendWordLenToAllReFixationPos(HashMap result, List visitedStates) {
        List<Integer> eyePositions = this.extractValues("eyepos", visitedStates);
        List<Integer> fixatedWordID = this.extractValues("fixWid", visitedStates);
        HashSet<Integer> alreadyFixated = new HashSet<Integer>();
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        for (Integer wordID : wordIDToWordLength.keySet()) {
            Integer refixationPos = null;
            for (int i = 0; i < fixatedWordID.size(); ++i) {
                if (fixatedWordID.get(i).equals(wordID) && this.justLanded(visitedStates, i) && alreadyFixated.contains(wordID)) {
                    System.out.print("Refixation: " + visitedStates.get(i) + " pos=");
                    refixationPos = eyePositions.get(i);
                    Integer lengthOfThisWord = wordIDToWordLength.get(wordID);
                    int relativeRefixationPos = refixationPos - this.startOfWord(wordID, wordIDToWordLength);
                    if (!(EXCLUDE_LAST_WORD_FROM_ANALYSIS && wordID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && wordID == 0)) {
                        this.mapOfListsAppend(result, lengthOfThisWord, relativeRefixationPos);
                    }
                    System.out.println(relativeRefixationPos);
                }
                if (!fixatedWordID.get(i).equals(wordID) || !this.justLanded(visitedStates, i) || EXCLUDE_LAST_WORD_FROM_ANALYSIS && wordID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && wordID == 0) continue;
                alreadyFixated.add(wordID);
            }
        }
    }

    private void appendWordLenToInitialFixationPos(HashMap result, List visitedStates) {
        List<Integer> eyePositions = this.extractValues("eyepos", visitedStates);
        List<Integer> fixatedWordID = this.extractValues("fixWid", visitedStates);
        HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
        for (Integer wordID : wordIDToWordLength.keySet()) {
            Integer firstFixationPos = null;
            for (int i = 0; i < fixatedWordID.size(); ++i) {
                if (!fixatedWordID.get(i).equals(wordID)) continue;
                firstFixationPos = eyePositions.get(i);
                break;
            }
            Integer lengthOfThisWord = wordIDToWordLength.get(wordID);
            if (firstFixationPos == null) continue;
            Integer firstRelativeFixationPos = firstFixationPos - this.startOfWord(wordID, wordIDToWordLength);
            if (EXCLUDE_LAST_WORD_FROM_ANALYSIS && wordID == this.lastWordID || EXCLUDE_FIRST_WORD_FROM_ANALYSIS && wordID == 0) continue;
            this.mapOfListsAppend(result, lengthOfThisWord, firstRelativeFixationPos);
        }
    }

    private boolean ifOffWordSaccadeRequest(int currentState, List visitedStates) {
        List<Integer> eyePosList = this.extractValues("eyepos", visitedStates);
        List<Integer> sacDstList = this.extractValues("sacDst", visitedStates);
        List<Integer> fixWIDList = this.extractValues("fixWid", visitedStates);
        int eyePos = eyePosList.get(currentState);
        int sacDst = sacDstList.get(currentState);
        int fixWID = fixWIDList.get(currentState);
        List eyePosToWID = this.getWordIDForAllEyePositions(visitedStates);
        int resultFixWID = (Integer)eyePosToWID.get(eyePos + sacDst);
        if (resultFixWID != fixWID) {
            return true;
        }
        System.out.println("NOT OFFWORD: " + visitedStates.get(currentState));
        return false;
    }

    private List getWordIDForAllEyePositions(List visitedStates) {
        HashMap<Integer, Integer> m = this.getWordIDToWordLength();
        System.out.println("wordIDToWordLength = " + m);
        int[] wordLengths = new int[m.keySet().size()];
        for (Integer key : m.keySet()) {
            int length;
            int wordID = key;
            wordLengths[wordID] = length = m.get(key).intValue();
        }
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int j = 0; j < wordLengths.length; ++j) {
            for (int k = 0; k < wordLengths[j]; ++k) {
                result.add(j);
            }
            result.add(j);
        }
        return result;
    }

    private int startOfWordTEXT(Integer targetWordID, HashMap<Integer, Integer> wordIDToWordLength) {
        int result = 0;
        for (int wordID : wordIDToWordLength.keySet()) {
            int wordLen = wordIDToWordLength.get(wordID);
            if (wordID >= targetWordID) continue;
            result = result + wordLen + 1;
        }
        return result;
    }

    private int startOfWord(Integer targetWordID, HashMap<Integer, Integer> wordIDToWordLength) {
        int result = 0;
        for (int wordID : wordIDToWordLength.keySet()) {
            int wordLen = wordIDToWordLength.get(wordID);
            if (wordID >= targetWordID) continue;
            result = result + wordLen + 1;
        }
        if (ENABLE_FIXATION_SPACE_BEFORE_WORD) {
            return result - 1;
        }
        return result;
    }

    private void mapOfListsAppend(HashMap h, Object key, Object newValue) {
        ArrayList<Object> list = (ArrayList<Object>)h.get(key);
        if (list == null) {
            list = new ArrayList<Object>();
            h.put(key, list);
        }
        list.add(newValue);
    }

    private HashMap<Integer, Integer> getWordIDToWordLength() {
        HashMap<Integer, Integer> result = new HashMap<Integer, Integer>();
        try {
            int wordID = 0;
            Scanner s = new Scanner(new File("sentence.txt"));
            while (s.hasNextLine()) {
                String line = s.nextLine().trim();
                if (!line.startsWith("sentence")) continue;
                String sentence = line;
                sentence = sentence.replaceAll("sentence", "").trim();
                sentence = sentence.replaceAll("=", "").trim();
                sentence = sentence.replaceAll("'", "").trim();
                StringTokenizer token = new StringTokenizer(sentence, " ", false);
                while (token.hasMoreTokens()) {
                    result.put(wordID, token.nextToken().length());
                    ++wordID;
                }
                System.out.println("word lengths = " + result);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Could not read lengths from sentence.txt");
        }
        return result;
    }

    private Double average(List x) {
        double sum = 0.0;
        for (int i = 0; i < x.size(); ++i) {
            double value = (Double)x.get(i);
            sum += value;
        }
        return new Double(sum / (double)x.size());
    }

    protected List<String> loadVisitedStates(BufferedReader inputFile) throws Exception {
        String s;
        ArrayList<String> result = new ArrayList<String>();
        while (inputFile.ready() && !inputFile.readLine().startsWith("POLICY EXTRACTOR ENDED")) {
        }
        while (inputFile.ready() && !inputFile.readLine().startsWith("Visited States:")) {
        }
        while (inputFile.ready() && !(s = inputFile.readLine()).equals("")) {
            result.add(s);
        }
        return result;
    }

    public List<Integer> extractValues(String label, List rows) {
        try {
            return this.extractValuesActual(label, rows);
        }
        catch (RuntimeException e) {
            if (label.equals("sacDst")) {
                System.out.println("sacDst failed; Trying sacReqDst");
                return this.extractValuesActual("sacReqDst", rows);
            }
            if (label.equals("sacReqDst")) {
                System.out.println("sacReqDst failed; Trying sacDst");
                return this.extractValuesActual("sacDst", rows);
            }
            System.out.println("Could not be resolved");
            throw e;
        }
    }

    public List<Integer> extractValuesActual(String label, List rows) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String row : rows) {
            int resultStart;
            String target = label + "=";
            int targetStart = row.indexOf(target);
            int resultCease = resultStart = targetStart + target.length();
            while (row.charAt(resultCease) == '-' || Character.isDigit(row.charAt(resultCease))) {
                ++resultCease;
            }
            if (resultCease > resultStart) {
                result.add(new Integer(row.substring(resultStart, resultCease)));
                continue;
            }
            throw new RuntimeException("No value present for key " + target + "\n in row " + row);
        }
        if (ENABLE_FIXATION_SPACE_BEFORE_WORD && label.equalsIgnoreCase("fixWid")) {
            List<Integer> eyePositions = this.extractValues("eyepos", rows);
            HashMap<Integer, Integer> wordIDToWordLength = this.getWordIDToWordLength();
            for (int i = 0; i < result.size(); ++i) {
                int fixWid = result.get(i);
                int eyePos = eyePositions.get(i);
                if (fixWid >= this.lastWordID) continue;
                System.out.println("Fixated word id = " + Integer.parseInt("" + fixWid));
                int lengthOfWord = wordIDToWordLength.get(fixWid);
                if (eyePos != this.startOfWordTEXT(fixWid, wordIDToWordLength) + lengthOfWord) continue;
                int actualFixWID = fixWid + 1;
                result.set(i, actualFixWID);
            }
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        new LogAnalyzer(args[0]);
    }
}

