/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.analysis;

import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Extractor {
    int numReported = 0;
    ArrayList<String> globalAlreadyIdentified = new ArrayList();
    ArrayList<String> globalAttending = new ArrayList();
    int numberOfWordsInSentence = 1;
    boolean ADD_PATRYK_FIELDS = true;

    public void process(String filename) throws Exception {
        BufferedReader inputFile = new BufferedReader(new FileReader(filename));
        String sentence = this.getSentenceString(inputFile);
        List<Integer> wordLengths = this.measureWordLengths(sentence);
        System.out.println("WordLengths: " + wordLengths);
        List<Integer> wordStarts = this.wordLengthsToWordStarts(wordLengths);
        int lines = 0;
        System.err.print("Scanning for agent tests: ");
        while (inputFile.ready() && !inputFile.readLine().startsWith("Testing Agent")) {
            if (++lines % 10000 != 0) continue;
            System.err.print(".");
        }
        System.err.println("\nProcessing agent tests.");
        while (inputFile.ready()) {
            while (inputFile.ready() && !inputFile.readLine().startsWith("POLICY EXTRACTOR STARTED")) {
            }
            this.globalAlreadyIdentified.clear();
            this.globalAttending.clear();
            List<String> states = this.loadVisitedStates(inputFile);
            List<Integer> eyePositions = this.extractValues("eyepos", states);
            List<Integer> fixatedWordID = this.convertFixationLocationsToFixatedIDs(eyePositions, wordStarts);
            List<Integer> eccentricity = this.extractValues("ecc", states);
            List<Integer> saccadeRequests = this.extractValues("sacReqDst", states);
            List<Integer> relativeLandPositions = this.computeRelativeLandPositions(eyePositions, fixatedWordID, wordStarts);
            if (eyePositions.size() > 2) {
                ++this.numReported;
                System.out.print("T,eye,intendSacc," + this.attnWindowLabels(wordLengths.size()) + "FixWord");
                if (this.ADD_PATRYK_FIELDS) {
                    System.out.println(",FixWordLen,RelativeLanding");
                }
                System.out.println("");
                String rowPreAttention = "";
                String rowPostAttention = "";
                for (int i = 0; i < eyePositions.size(); ++i) {
                    rowPreAttention = "," + eyePositions.get(i) + "," + saccadeRequests.get(i) + ",";
                    System.out.print(i + rowPreAttention);
                    List<Integer> attendedStates = this.getAttendedIDColumns(states.get(i));
                    for (int j = 0; j < wordLengths.size(); ++j) {
                        if (attendedStates.contains(j)) {
                            System.out.print("1,");
                            continue;
                        }
                        System.out.print("0,");
                    }
                    rowPostAttention = "" + fixatedWordID.get(i);
                    System.out.print(rowPostAttention);
                    if (this.ADD_PATRYK_FIELDS) {
                        String addition = "," + wordLengths.get(fixatedWordID.get(i)) + "," + relativeLandPositions.get(i);
                        System.out.print(addition);
                        rowPostAttention = rowPostAttention + addition;
                    }
                    System.out.println("");
                }
                System.out.print(eyePositions.size() + rowPreAttention);
                for (int j = 0; j < wordLengths.size(); ++j) {
                    System.out.print("0,");
                }
                System.out.print(rowPostAttention);
                System.out.println("");
            } else {
                System.err.println("Skipped a simulation");
            }
            if (this.numReported != 50) continue;
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("Syntax: java Extractor logfile.txt");
            System.exit(-1);
        }
        Extractor e = new Extractor();
        if (args.length == 2 && args[1].equals("erik")) {
            e.ADD_PATRYK_FIELDS = false;
        }
        e.process(args[0]);
    }

    public String attnWindowLabels(int x) {
        String result = "";
        for (int i = 0; i < x; ++i) {
            result = result + "Att" + (i + 1) + ",";
        }
        return result;
    }

    public List<Integer> getAttendedIDColumns(String row) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String IDs = this.getAttIDs(row);
        String Xs = this.getIdentifiedXs(row);
        StringTokenizer t = new StringTokenizer(IDs, "|");
        while (t.hasMoreTokens()) {
            result.add(new Integer(t.nextToken()));
        }
        for (int i = 0; i < Xs.length(); ++i) {
            if (Xs.charAt(i) != 'x') continue;
            Integer toRemove = new Integer(i);
            result.remove(toRemove);
        }
        return result;
    }

    public String getNewlyIdentifiedIDs(String row) {
        String result = "[";
        String IDs = this.getAttIDs(row);
        String Xs = this.getIdentifiedXs(row);
        StringTokenizer t = new StringTokenizer(IDs, "|");
        ArrayList<String> list = new ArrayList<String>();
        while (t.hasMoreTokens()) {
            list.add(t.nextToken());
        }
        for (int i = 0; i < Xs.length(); ++i) {
            String identifiedID;
            if (Xs.charAt(i) != 'x' || this.globalAlreadyIdentified.contains(identifiedID = (String)list.get(i))) continue;
            result = result + (String)list.get(i) + " ";
            this.globalAlreadyIdentified.add(identifiedID);
        }
        return result.trim() + "]";
    }

    protected List<Integer> convertFixationLocationsToFixatedIDs(List<Integer> eyePositions, List<Integer> wordStarts) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        block0: for (Integer eyePosition : eyePositions) {
            for (int wordID = 0; wordID < wordStarts.size(); ++wordID) {
                if (wordID == wordStarts.size() - 1) {
                    result.add(wordID - 1);
                    continue block0;
                }
                if (eyePosition >= wordStarts.get(wordID + 1)) continue;
                result.add(wordID);
                continue block0;
            }
        }
        return result;
    }

    public String getAttIDs(String row) {
        int start = row.indexOf("attIDs=", 0) + "attIDs=".length();
        int cease = row.indexOf(",", start) - 1;
        return row.substring(start, cease);
    }

    public String getIdentifiedXs(String row) {
        int start = "identified=".length() + row.indexOf("identified", 0);
        int cease = row.indexOf("]", start);
        return row.substring(start, cease);
    }

    protected String getSentenceString(BufferedReader inputFile) throws Exception {
        String result = null;
        while (inputFile.ready()) {
            String line = inputFile.readLine().trim();
            if (!line.startsWith("sentence")) continue;
            int start = line.indexOf("'") + 1;
            int cease = line.indexOf("'", start + 1);
            result = line.substring(start, cease);
            return result;
        }
        throw new RuntimeException("\nDid not find sentence string/visual representation");
    }

    protected List<String> loadVisitedStates(BufferedReader inputFile) throws Exception {
        String s;
        ArrayList<String> result = new ArrayList<String>();
        while (inputFile.ready() && !inputFile.readLine().startsWith("Visited States:")) {
        }
        while (inputFile.ready() && !(s = inputFile.readLine()).equals("")) {
            result.add(s);
        }
        return result;
    }

    public List<Integer> wordLengthsToWordStarts(List<Integer> wordLengths) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int start = 0;
        result.add(start);
        for (Integer eachLength : wordLengths) {
            result.add((start += eachLength + 1) - 1);
        }
        return result;
    }

    public List<Integer> measureWordLengths(String sentence) {
        System.out.println("Sentence is " + sentence);
        ArrayList<Integer> result = new ArrayList<Integer>();
        StringTokenizer t = new StringTokenizer(sentence, " ");
        while (t.hasMoreTokens()) {
            result.add(t.nextToken().length());
        }
        return result;
    }

    protected List<Integer> computeRelativeLandPositions(List<Integer> absoluteEyePositions, List<Integer> fixatedWordID, List<Integer> wordStarts) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (int i = 0; i < absoluteEyePositions.size(); ++i) {
            int relative = absoluteEyePositions.get(i) - wordStarts.get(fixatedWordID.get(i));
            result.add(relative);
        }
        return result;
    }

    public List<Integer> extractValues(String label, List rows) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (String row : rows) {
            int resultStart;
            String target = label + "=";
            int targetStart = row.indexOf(target);
            int resultCease = resultStart = targetStart + target.length();
            while (row.charAt(resultCease) == '-' || Character.isDigit(row.charAt(resultCease))) {
                ++resultCease;
            }
            if (resultCease > resultStart) {
                result.add(new Integer(row.substring(resultStart, resultCease)));
                continue;
            }
            throw new RuntimeException("No value present for key " + target + "\n in row " + row);
        }
        return result;
    }
}

