/*
 * Decompiled with CFR 0.152.
 */
package org.eyelanguage.rl.analysis;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.Timer;
import org.eyelanguage.rl.analysis.LogAnalyzer;

public class AgentTestVisualizer
extends JFrame
implements ActionListener,
Runnable {
    LogAnalyzer logAnalyzer = new LogAnalyzer();
    private JLabel agent;
    private JLabel attentionIndicator;
    private JLabel saccadeTarget;
    ArrayList<Integer> fixations = new ArrayList();
    ArrayList<Integer> attendeds = new ArrayList();
    ArrayList<Integer> targets = new ArrayList();
    ArrayList<Integer> wordLengths = new ArrayList();
    public static Timer timer;
    boolean animationComplete = false;
    int currentFixation = 0;
    int nextFixation = 0;
    int currentAttention = 0;
    int nextAttention = 0;
    int distance = 1;
    int currentTarget = 0;
    int nextTarget = 0;
    int singleBlockWidth = 20;
    int incrementWidth = 10;
    int counter = 0;
    boolean goingUp;
    boolean goingDown;
    boolean startedAnimating;
    boolean stillAnimating;
    Iterator<Integer> fixation;
    Iterator<Integer> attention;
    Iterator<Integer> target;

    public AgentTestVisualizer() {
        this.agent = new JLabel(new ImageIcon(this.getClass().getResource("/images/eye1.gif")));
        this.attentionIndicator = new JLabel(new ImageIcon(this.getClass().getResource("/images/lillipad.gif")));
        this.saccadeTarget = new JLabel(new ImageIcon(this.getClass().getResource("/images/downarrow.gif")));
        this.resetAgentToBeginning();
        this.saccadeTarget.setVisible(false);
        this.getContentPane().add(this.attentionIndicator);
        this.getContentPane().add(this.agent);
        this.getContentPane().add(this.saccadeTarget);
        this.setSize(820, 200);
    }

    public void resetAgentToBeginning() {
        this.agent.setBounds(0, 40, 40, 40);
        this.attentionIndicator.setBounds(10, 90, 20, 20);
        this.saccadeTarget.setBounds(10, 20, 20, 20);
        this.saccadeTarget.setVisible(false);
        this.agent.setVisible(true);
        this.currentFixation = 0;
        this.nextFixation = 0;
        System.out.println("Agent reset to beginning");
    }

    public void run() {
        System.out.println("run() has been called");
        this.resetAgentToBeginning();
        this.getContentPane().setBackground(new Color(1.0f, 1.0f, 1.0f));
        this.setVisible(true);
        if (timer == null) {
            timer = new Timer(10, this);
        }
        timer.start();
        System.out.println("Timer started");
    }

    public static void main(String[] args) throws Exception {
        String filename = args[0];
        AgentTestVisualizer a = new AgentTestVisualizer();
        a.process(filename);
    }

    protected String getSentenceFromFile(String filename) throws Exception {
        String sentence = "blank";
        BufferedReader inputFile = new BufferedReader(new FileReader(filename));
        while (inputFile.ready()) {
            String line = inputFile.readLine();
            if (!line.contains("sentence =")) continue;
            sentence = line;
            System.out.println("1 sentence = '" + sentence + "'");
            sentence = sentence.replaceAll("sentence", "");
            sentence = sentence.replaceAll("=", "");
            System.out.println("2 sentence = '" + sentence + "'");
            sentence = sentence.replaceAll("' ", "");
            System.out.println("3 sentence = '" + sentence + "'");
            sentence = sentence.replaceAll("'", "");
            System.out.println("4 sentence = '" + sentence + "'");
            sentence = sentence.replaceAll("  ", "");
            System.out.println("5 sentence = '" + sentence + "'");
            sentence = sentence.replaceAll("  ", "");
            System.out.println("6 sentence = '" + sentence + "'");
            sentence = sentence.replaceAll("  ", "");
            sentence = sentence.replaceAll("  ", "");
            sentence = sentence.replaceAll("  ", "");
            sentence = sentence.trim();
            sentence = sentence + " ";
            System.out.println("sentence = '" + sentence + "'");
        }
        if (sentence.equals("blank")) {
            throw new RuntimeException("Could not find sentence in file '" + filename + "'.");
        }
        StringTokenizer token = new StringTokenizer(sentence, " ", false);
        while (token.hasMoreTokens()) {
            this.wordLengths.add(1 + token.nextToken().length());
        }
        System.out.println("word lengths = " + this.wordLengths);
        return sentence;
    }

    protected void process(String filename) throws Exception {
        String sentence = this.getSentenceFromFile("sentence.txt");
        this.drawWorld(sentence);
        BufferedReader inputFile = new BufferedReader(new FileReader(filename));
        while (inputFile.ready()) {
            List<String> visitedStates = this.logAnalyzer.loadVisitedStates(inputFile);
            List<Integer> eyePositions = this.logAnalyzer.extractValues("eyepos", visitedStates);
            List<Integer> attendedWord = this.logAnalyzer.extractValues("attWid", visitedStates);
            List<Integer> saccadeTargets = null;
            this.fixations.clear();
            this.attendeds.clear();
            this.targets.clear();
            try {
                saccadeTargets = this.logAnalyzer.extractValues("sacReqDst", visitedStates);
            }
            catch (Exception e) {
                System.out.println("sacReqDst could not be retrieved, trying sacDst");
                saccadeTargets = this.logAnalyzer.extractValues("sacDst", visitedStates);
            }
            Iterator<Integer> i = eyePositions.iterator();
            Iterator<Integer> j = attendedWord.iterator();
            Iterator<Integer> k = saccadeTargets.iterator();
            while (i.hasNext()) {
                this.fixations.add(i.next());
                this.attendeds.add(j.next());
                this.targets.add(k.next());
            }
            this.animationComplete = false;
            this.startedAnimating = false;
            this.stillAnimating = false;
            EventQueue.invokeAndWait(this);
            while (!this.animationComplete) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
        }
        inputFile.close();
    }

    public void actionPerformed(ActionEvent e) {
        this.currentTarget = 0;
        if (!this.startedAnimating) {
            this.fixation = this.fixations.iterator();
            this.attention = this.attendeds.iterator();
            this.target = this.targets.iterator();
            if (!this.fixation.hasNext()) {
                System.out.println("No fixations were found.\n");
                System.exit(-1);
            }
            this.nextFixation = this.fixation.next();
            this.nextAttention = this.attention.next();
            this.nextTarget = this.target.next();
            System.out.println("next fixation: " + this.nextFixation + " next attention = " + this.nextAttention + " next target = " + this.nextTarget);
            this.distance = this.nextFixation - this.currentFixation;
            this.startedAnimating = true;
            this.goingUp = true;
            this.stillAnimating = true;
        }
        if (this.stillAnimating) {
            int dY = 0;
            int dX = 0;
            if (this.goingUp) {
                if (this.counter == 10) {
                    this.goingDown = true;
                    this.goingUp = false;
                    this.counter = 0;
                }
                dY = -1;
                dX = this.distance * this.singleBlockWidth / (this.incrementWidth * 2);
            } else if (this.goingDown) {
                dY = 1;
                dX = this.distance * this.singleBlockWidth / (this.incrementWidth * 2);
                if (this.counter == 10) {
                    this.goingUp = true;
                    this.goingDown = false;
                    this.counter = 0;
                    if (this.fixation.hasNext()) {
                        this.currentFixation = this.nextFixation;
                        this.nextFixation = this.fixation.next();
                        this.currentAttention = this.nextAttention;
                        this.nextAttention = this.attention.next();
                        this.currentTarget = this.nextTarget;
                        this.nextTarget = this.target.next();
                        System.out.println("curFix " + this.currentFixation + " next fixation: " + this.nextFixation + " curAtt " + this.currentAttention + " next attention = " + this.nextAttention + " current target = " + this.currentTarget + "next target = " + this.nextTarget);
                        this.distance = this.nextFixation - this.currentFixation;
                        if (this.currentTarget != this.nextTarget) {
                            if (this.nextTarget == 0) {
                                if (this.currentTarget == 0) {
                                    this.saccadeTarget.setVisible(false);
                                }
                            } else {
                                this.saccadeTarget.setVisible(true);
                                int difference = this.nextTarget - this.currentTarget;
                                int eyeCenter = this.agent.getX() + Math.round((float)this.agent.getWidth() / 2.0f);
                                Rectangle r = this.saccadeTarget.getBounds();
                                r.setBounds(eyeCenter + 20 * difference - 8, (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
                                this.saccadeTarget.setBounds(r);
                            }
                        }
                        if (this.currentTarget == 0 && this.nextTarget == 0) {
                            this.saccadeTarget.setVisible(false);
                        }
                    } else {
                        System.out.println("Animation Complete");
                        this.stillAnimating = false;
                        this.animationComplete = true;
                        timer.stop();
                    }
                }
            }
            ++this.counter;
            Rectangle r = this.agent.getBounds();
            r.setBounds((int)r.getX() + dX, (int)r.getY() + dY, (int)r.getWidth(), (int)r.getHeight());
            this.agent.setBounds(r);
            this.attentionIndicator.setBounds(10 + this.getAttentionCenterXCoordinate(this.currentAttention), 90, 20, 20);
            this.repaint();
        }
    }

    public void drawWorld(String sentenceString) {
        int numDrawn = 0;
        for (int i = 0; i < sentenceString.length(); ++i) {
            JLabel jLabel1 = sentenceString.charAt(i) == ' ' ? new JLabel() : new JLabel(new ImageIcon(this.getClass().getResource("/images/water.gif")));
            this.getContentPane().add(jLabel1);
            jLabel1.setBounds(10 + 20 * numDrawn, 70, 20, 20);
            ++numDrawn;
        }
    }

    private int getAttentionCenterXCoordinate(int wordID) {
        int sum = 0;
        for (int i = 0; i < wordID; ++i) {
            sum += this.wordLengths.get(i).intValue();
        }
        if (wordID > 0) {
            sum = sum + this.wordLengths.get(wordID) / 2 - 1;
        }
        return 20 * sum;
    }
}

