/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl.maze;

import java.util.Iterator;
import net.pakl.rl.ActionSet;
import net.pakl.rl.maze.Action2D;
import net.pakl.rl.maze.MazeWorld;
import net.pakl.rl.maze.State2D;

public class Toolbox {
    public boolean allowDiagonals = false;

    public ActionSet makeSimpleMazePolicy(MazeWorld mWorld) {
        ActionSet p = new ActionSet();
        Iterator i = mWorld.stateIterator();
        while (i.hasNext()) {
            State2D s = (State2D)i.next();
            State2D newState = null;
            Action2D action = null;
            if (mWorld.isTerminalState(s)) {
                p.allowAction(s, new Action2D(0, 0));
                continue;
            }
            action = new Action2D(1, 0);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) {
                p.allowAction(s, action);
            }
            action = new Action2D(-1, 0);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) {
                p.allowAction(s, action);
            }
            action = new Action2D(0, 1);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) {
                p.allowAction(s, action);
            }
            action = new Action2D(0, -1);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) {
                p.allowAction(s, action);
            }
            if (!this.allowDiagonals) continue;
            action = new Action2D(-1, -1);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) {
                p.allowAction(s, action);
            }
            action = new Action2D(1, -1);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) {
                p.allowAction(s, action);
            }
            action = new Action2D(1, 1);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (mWorld.getStateList().contains(newState) && !mWorld.isObstacle(newState)) {
                p.allowAction(s, action);
            }
            action = new Action2D(-1, 1);
            newState = new State2D(s.getX() + action.getDeltaX(), s.getY() + action.getDeltaY());
            if (!mWorld.getStateList().contains(newState) || mWorld.isObstacle(newState)) continue;
            p.allowAction(s, action);
        }
        System.err.println(p.toText());
        return p;
    }
}

