/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl.maze;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.pakl.rl.Action;
import net.pakl.rl.State;
import net.pakl.rl.World;
import net.pakl.rl.maze.Action2D;
import net.pakl.rl.maze.State2D;

public class MazeWorld
implements World {
    Random randomNumberGenerator;
    ArrayList states = new ArrayList();
    HashSet terminalStates = new HashSet();
    ArrayList obstacles = new ArrayList();
    private int lengthX;
    private int lengthY;
    private double pObstacle;
    boolean isBuilt = false;
    private String name = "namelessWorld";
    HashMap teleporters = new HashMap();

    public int getNumberOfStates() {
        return this.states.size();
    }

    public int getSizeX() {
        return this.lengthX;
    }

    public int getSizeY() {
        return this.lengthY;
    }

    public String toText() {
        StringBuffer result = new StringBuffer("");
        for (int i = 0; i < this.lengthX; ++i) {
            for (int j = 0; j < this.lengthY; ++j) {
                if (this.teleporters.containsKey(new State2D(j, i))) {
                    result.append("T ");
                    continue;
                }
                if (this.teleporters.containsValue(new State2D(j, i))) {
                    result.append("! ");
                    continue;
                }
                if (this.isObstacle(new State2D(j, i))) {
                    result.append("X ");
                    continue;
                }
                result.append("_ ");
            }
            result.append("\n");
        }
        return result.toString();
    }

    public MazeWorld(String newName, long randomSeed) {
        this.name = newName;
        this.randomNumberGenerator = new Random(randomSeed);
        System.err.println("! World " + this.getName() + " has been created.");
    }

    public MazeWorld(String newName) {
        this.name = newName;
        this.randomNumberGenerator = new Random(1111L);
        System.err.println("! World " + this.getName() + " has been created.");
    }

    public String getName() {
        return this.name;
    }

    public boolean getIsBuilt() {
        return this.isBuilt;
    }

    public void addTeleporter(State location, State destination) {
        this.removeAnyObstacle((State2D)location);
        this.removeAnyObstacle((State2D)destination);
        this.teleporters.put(location, destination);
    }

    public State getNewState(State oldState, Action action) {
        State2D old = (State2D)oldState;
        Action2D action2D = (Action2D)action;
        State2D newState = new State2D(old.getX() + action2D.getDeltaX(), old.getY() + action2D.getDeltaY());
        if (this.teleporters.keySet().contains(newState)) {
            newState = (State2D)this.teleporters.get(newState);
        }
        if (this.teleporters.keySet().contains(oldState)) {
            newState = (State2D)this.teleporters.get(oldState);
        }
        if (!this.states.contains(newState)) {
            throw new RuntimeException("State transititioned to by Policy, " + action2D + " -> " + newState + ", does not exist");
        }
        return newState;
    }

    public int distance(State state1, State state2) {
        State2D a = (State2D)state1;
        State2D b = (State2D)state2;
        return b.getX() - a.getX() + (b.getY() - a.getY());
    }

    public void setLengths(int x, int y) {
        this.lengthX = x;
        this.lengthY = y;
        if (this.isBuilt) {
            this.build();
        }
    }

    public boolean isTerminalState(State state) {
        return this.terminalStates.contains(state);
    }

    public void makeIntoTerminalState(State2D state) {
        if (!this.terminalStates.contains(state)) {
            this.terminalStates.add(state);
        }
    }

    public void makeIntoObstacle(State2D state) {
        this.obstacles.add(state);
    }

    public void removeAnyObstacle(State2D state) {
        if (this.isObstacle(state)) {
            this.obstacles.remove(this.obstacles.indexOf(state));
        }
    }

    public boolean isObstacle(State2D state) {
        return this.obstacles.contains(state);
    }

    public HashSet getTerminalStates() {
        return this.terminalStates;
    }

    public void build() {
        this.isBuilt = true;
        for (int x = 0; x < this.getSizeX(); ++x) {
            for (int y = 0; y < this.getSizeY(); ++y) {
                State2D s = new State2D(x, y);
                this.states.add(s);
                if (!(Math.random() < this.pObstacle)) continue;
                this.makeIntoObstacle(s);
            }
        }
        System.err.println(this.states.size() + " build complete\n");
    }

    public Iterator stateIterator() {
        return this.states.iterator();
    }

    public List getStateList() {
        return this.states;
    }

    public State getStartingState() {
        return new State2D(0, 0);
    }

    public double getPObstacle() {
        return this.pObstacle;
    }

    public void setPObstacle(double pObstacle) {
        this.pObstacle = pObstacle;
    }

    public State getRandomState() {
        int i = (int)(this.randomNumberGenerator.nextDouble() * (double)this.getStateList().size());
        return (State)this.getStateList().get(i);
    }
}

