/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl.maze;

import java.io.File;
import java.io.FileInputStream;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import net.pakl.neuralnet.Perceptron;
import net.pakl.rl.ActionSet;
import net.pakl.rl.Agent;
import net.pakl.rl.PolicyExtractor;
import net.pakl.rl.ReinforcementFunction;
import net.pakl.rl.ValueFunction;
import net.pakl.rl.ValueFunctionHashMap;
import net.pakl.rl.ValueFunctionPerceptron;
import net.pakl.rl.ValueFunctionResidualAlgorithmBairdPerceptron;
import net.pakl.rl.ValueFunctionResidualAlgorithmLinear;
import net.pakl.rl.ValueFunctionResidualAlgorithmPerceptron;
import net.pakl.rl.World;
import net.pakl.rl.maze.Action2D;
import net.pakl.rl.maze.MazeWorld;
import net.pakl.rl.maze.State2D;
import net.pakl.rl.maze.Toolbox;
import tools.IsAMonitor;

public class MazeMain {
    static int mazeX;
    static int mazeY;
    static int iterationCount;
    static double learningRate;
    static double maxMin;
    static double residualWeighting;
    static double pObstacle;
    static double discountFactor;
    static double epsilon;
    static String teleporters;
    static String destinations;
    static String valueFunctionType;
    static String obstacles;
    static String terminals;
    static boolean CROSS_PRODUCT;
    public static int numHiddenUnits;
    static IsAMonitor monitor;

    public static void main(String[] args) throws Exception {
        if (args.length > 0 && args[0].equals("-help")) {
            System.out.println("-----------------------------------------------------------------");
            System.out.println("MazeMain -help");
            System.out.println("-----------------------------------------------------------------");
            System.out.println("To terminate the simulation at any point and test the agent,");
            System.out.println("create a file called 'endrun.msg' (e.g. 'touch endrun.msg').");
            System.out.println("");
            System.out.println("");
            System.exit(0);
        }
        try {
            MazeMain.loadParametersFromFile("maze.prop");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("-----------------------------------------------------------------");
            System.out.println("Error Loading Properties.  Here is a sample maze.prop file:");
            System.out.println("-----------------------------------------------------------------");
            System.out.println("mazeX = 15");
            System.out.println("mazeY = 15");
            System.out.println("iterationCount = 1000000");
            System.out.println("learningRate = 0.01");
            System.out.println("scaleInputsBy = 15");
            System.out.println("maxMin = 20");
            System.out.println("residualWeighting = 0.1");
            System.out.println("epsilon = 1.0");
            System.out.println("numHiddenUnits = 20");
            System.out.println("valueFunctionType = BairdPerceptronResidualAlgorithm");
            System.out.println("#valueFunctionType = LookupTable");
            System.out.println("pObstacle = 0.0");
            System.out.println("obstacles = 13,1 13,2 13,3 13,4 13,5 13,6 13,7 13,8 13,9 13,10 13,11 13,12 13,13 13,14");
            System.out.println("discountFactor = 1.0");
            System.exit(-1);
        }
        MazeMain.run();
    }

    public static void run() {
        StringTokenizer t;
        MazeWorld world = new MazeWorld("maze");
        Toolbox toolbox = new Toolbox();
        world.setLengths(mazeX, mazeY);
        world.setPObstacle(pObstacle);
        world.build();
        if (teleporters != null) {
            StringTokenizer teleporter = new StringTokenizer(teleporters, " ", false);
            StringTokenizer destination = new StringTokenizer(destinations, " ", false);
            while (teleporter.hasMoreTokens()) {
                State2D teleporterStart = new State2D(teleporter.nextToken());
                State2D teleporterDestination = new State2D(destination.nextToken());
                System.out.println("Teleportation link " + teleporterStart + " -> " + teleporterDestination);
                world.addTeleporter(teleporterStart, teleporterDestination);
            }
        }
        if (obstacles != null) {
            t = new StringTokenizer(obstacles, " ", false);
            while (t.hasMoreTokens()) {
                world.makeIntoObstacle(new State2D(t.nextToken()));
            }
        }
        if (terminals != null) {
            t = new StringTokenizer(terminals, " ", false);
            while (t.hasMoreTokens()) {
                world.makeIntoTerminalState(new State2D(t.nextToken()));
            }
        } else {
            System.out.println("Using default terminal state of lower right of maze.");
            world.makeIntoTerminalState(new State2D(mazeX - 1, mazeY - 1));
        }
        System.out.println(world.toText());
        ReinforcementFunction rf = new ReinforcementFunction();
        rf.setDefaultReinforcement(-1.0);
        rf.setReward(new State2D(mazeX - 1, mazeY - 1), new Action2D(0, 0), 0.0);
        toolbox.allowDiagonals = true;
        ActionSet actionSet = toolbox.makeSimpleMazePolicy(world);
        Agent agent = MazeMain.createAgent(world, rf, actionSet, discountFactor);
        agent.setEpsilon(epsilon);
        ValueFunction valueFunction = null;
        ValueFunction tempNewValueFunction = null;
        if (valueFunctionType.equalsIgnoreCase("PerceptronResidualAlgorithm")) {
            valueFunction = new ValueFunctionResidualAlgorithmPerceptron(world);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setHiddenUnits(numHiddenUnits);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setLearningRate(learningRate);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setMaxMinValue(maxMin);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setResidualWeighting(residualWeighting);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).CROSS_PRODUCT = CROSS_PRODUCT;
            tempNewValueFunction = valueFunction;
        } else if (valueFunctionType.equalsIgnoreCase("BairdPerceptronResidualAlgorithm")) {
            valueFunction = new ValueFunctionResidualAlgorithmBairdPerceptron(world);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setHiddenUnits(numHiddenUnits);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setLearningRate(learningRate);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setMaxMinValue(maxMin);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).setResidualWeighting(residualWeighting);
            ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).CROSS_PRODUCT = CROSS_PRODUCT;
            tempNewValueFunction = valueFunction;
        } else if (valueFunctionType.equalsIgnoreCase("Perceptron")) {
            valueFunction = new ValueFunctionPerceptron(world);
            ((ValueFunctionPerceptron)valueFunction).setHiddenUnits(numHiddenUnits);
            ((ValueFunctionPerceptron)valueFunction).setLearningRate(learningRate);
            ((ValueFunctionPerceptron)valueFunction).setMaxMinValue(maxMin);
            ((ValueFunctionPerceptron)valueFunction).CROSS_PRODUCT = CROSS_PRODUCT;
            tempNewValueFunction = valueFunction;
        } else if (valueFunctionType.equalsIgnoreCase("LinearApproximator")) {
            valueFunction = new ValueFunctionResidualAlgorithmLinear(world);
            ((ValueFunctionResidualAlgorithmLinear)valueFunction).setLearningRate(learningRate);
            ((ValueFunctionResidualAlgorithmLinear)valueFunction).setMaxMinValue(maxMin);
            ((ValueFunctionResidualAlgorithmLinear)valueFunction).setResidualWeighting(residualWeighting);
            tempNewValueFunction = valueFunction;
        } else {
            System.out.println("USING ValueFunctionHashMap (default)!");
            valueFunction = new ValueFunctionHashMap(world);
            tempNewValueFunction = new ValueFunctionHashMap(world);
        }
        for (int j = 0; j < iterationCount; ++j) {
            System.out.println("Iteration " + j);
            if (monitor != null) {
                monitor.updateProgress(j);
            }
            long timerStart = System.currentTimeMillis();
            agent.performValueIteration(tempNewValueFunction, valueFunction);
            ValueFunction swap = tempNewValueFunction;
            tempNewValueFunction = valueFunction;
            valueFunction = swap;
            long timerCease = System.currentTimeMillis();
            double minutes = (double)(timerCease - timerStart) * (double)(iterationCount - j) / 1000.0 / 60.0;
            double hours = minutes / 60.0;
            if (j % 100 == 0) {
                System.out.println("Iter " + j + "\tEst. Time left: " + minutes + " minutes (" + hours + " hours)\n");
                System.out.println(MazeMain.showValueFunction(valueFunction));
            }
            if (MazeMain.receivedEndRunMessage()) break;
        }
        System.out.println(MazeMain.showValueFunction(valueFunction));
        for (int i = 0; i < mazeY; ++i) {
            for (int j = 0; j < mazeX; ++j) {
                System.out.print("final " + i + "," + j + " ");
                double[] vector = new State2D(i, j).doubleRepresentation();
                for (int k = 0; k < vector.length; ++k) {
                    System.out.print(vector[k] + " ");
                }
                System.out.print(valueFunction.getValue(new State2D(i, j)));
                System.out.println("");
            }
        }
        if (valueFunction instanceof ValueFunctionResidualAlgorithmPerceptron) {
            Perceptron p = ((ValueFunctionResidualAlgorithmPerceptron)valueFunction).getNetwork();
            System.out.println(p.getConnectivity());
            System.out.println(p.getGraphviz(0.0, 1.0));
        }
        System.out.println(MazeMain.showValueFunction(valueFunction));
        PolicyExtractor policyExtractor = new PolicyExtractor();
        String policyString = policyExtractor.extractOptimalPolicy(actionSet, valueFunction, null, world, rf, discountFactor);
        List optimalActions = policyExtractor.getOptimalActions();
        System.out.println(policyString);
        System.out.println("\nAll Done.");
        if (monitor != null) {
            monitor.notifyFinished(MazeMain.showValueFunction(valueFunction) + "\n" + policyString);
        }
    }

    private static String showValueFunction(ValueFunction valueFunction) {
        String result = "vf\n";
        DecimalFormat decimalFormat = new DecimalFormat("00.00");
        for (int j = 0; j < mazeX; ++j) {
            for (int i = 0; i < mazeY; ++i) {
                String s = decimalFormat.format(valueFunction.getValue(new State2D(i, j)));
                if (s.length() < 6) {
                    s = " " + s;
                }
                result = result + s + " ";
            }
            result = result + "   %vf \n";
        }
        return result;
    }

    private static Agent createAgent(World world, ReinforcementFunction rf, ActionSet policy, double discountFactor) {
        Agent agent = new Agent("agent");
        agent.setWorld(world);
        agent.setReinforcementFunction(rf);
        agent.setPolicy(policy);
        agent.setDiscountFactor(discountFactor);
        return agent;
    }

    private static boolean receivedEndRunMessage() {
        File f = new File("endrun.msg");
        if (f.exists()) {
            System.out.println("File endrun.msg exists, stopping run.");
            return true;
        }
        return false;
    }

    private static void loadParametersFromFile(String filename) throws Exception {
        Properties properties = new Properties();
        properties.load(new FileInputStream(filename));
        MazeMain.loadParametersFromProperties(properties);
    }

    public static void loadParametersFromProperties(Properties properties) {
        System.err.println("Setting mazeX");
        mazeX = new Integer(properties.getProperty("mazeX"));
        System.err.println("Setting mazeY");
        mazeY = new Integer(properties.getProperty("mazeY"));
        System.err.println("Setting iterationCount");
        iterationCount = new Integer(properties.getProperty("iterationCount"));
        System.err.println("Setting learningRate");
        learningRate = new Double(properties.getProperty("learningRate"));
        System.err.println("Setting maxMin");
        maxMin = new Double(properties.getProperty("maxMin"));
        System.err.println("Setting residualWeighting");
        residualWeighting = new Double(properties.getProperty("residualWeighting"));
        System.err.println("Setting epsilon");
        epsilon = new Double(properties.getProperty("epsilon"));
        System.err.println("Setting pObstacle");
        pObstacle = new Double(properties.getProperty("pObstacle"));
        System.err.println("Loading discountFactor");
        discountFactor = new Double(properties.getProperty("discountFactor"));
        if (properties.getProperty("crossProduct") != null && properties.getProperty("crossProduct").equalsIgnoreCase("true")) {
            CROSS_PRODUCT = true;
        }
        if (properties.getProperty("numHiddenUnits") != null) {
            numHiddenUnits = new Integer(properties.getProperty("numHiddenUnits"));
        }
        if (properties.getProperty("teleporter") != null) {
            System.err.println("Loading discountFactor");
            teleporters = properties.getProperty("teleporter");
            System.err.println("Loading discountFactor");
            destinations = properties.getProperty("destination");
        }
        if (properties.getProperty("valueFunctionType") != null) {
            valueFunctionType = properties.getProperty("valueFunctionType");
        }
        if (properties.getProperty("obstacles") != null) {
            obstacles = properties.getProperty("obstacles");
        }
        if (properties.getProperty("terminals") != null) {
            terminals = properties.getProperty("terminals");
        }
        if (properties.getProperty("scaleInputsBy") != null) {
            State2D.scaleBy = new Double(properties.getProperty("scaleInputsBy"));
        }
    }

    static {
        valueFunctionType = "lookupTable";
        obstacles = null;
        terminals = null;
        CROSS_PRODUCT = false;
        numHiddenUnits = 10;
        monitor = null;
    }
}

