/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ZippedHashMap
extends HashMap {
    HashMap entries = new HashMap();

    public ZippedHashMap(int numStates) {
    }

    public ZippedHashMap() {
    }

    public Object put(Object key, Object value) {
        Integer zipEntryKey = new Integer(key.hashCode());
        try {
            HashMap map = null;
            try {
                byte[] data = (byte[])this.entries.get(new Integer(key.hashCode()));
                ByteArrayInputStream bi = new ByteArrayInputStream(data);
                ObjectInputStream oi = new ObjectInputStream(new GZIPInputStream(bi));
                map = (HashMap)oi.readObject();
            }
            catch (Exception e) {
                map = new HashMap();
            }
            map.put(key, value);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(new GZIPOutputStream(bo));
            oo.writeObject(map);
            oo.close();
            this.entries.put(zipEntryKey, bo.toByteArray());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object get(Object key) {
        try {
            Object result = null;
            Integer zipEntryKey = new Integer(key.hashCode());
            ByteArrayInputStream bi = new ByteArrayInputStream((byte[])this.entries.get(zipEntryKey));
            if (bi != null) {
                HashMap map = (HashMap)new ObjectInputStream(new GZIPInputStream(bi)).readObject();
                if (map == null) {
                    return null;
                }
                Object valueAssociatedWithKey = map.get(key);
                return valueAssociatedWithKey;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void test() {
        ZippedHashMap z = this;
        z.put("Hi", "Hello");
        z.put("Bye", "Goodbye");
        System.out.println(z.get("Hi") + " " + z.get("Bye"));
        System.out.println(z.get("Hi2") + " " + z.get("Bye2"));
        SimpleObject o1 = new SimpleObject(100);
        SimpleObject o2 = new SimpleObject(101);
        SimpleObject o3 = new SimpleObject(102);
        o1.setHashCode(1);
        o2.setHashCode(1);
        o3.setHashCode(1);
        z.put(o1, "one");
        z.put(o2, "two");
        z.put(o3, "three, compressed in same entry.");
        System.out.println(z.get(o1) + " " + z.get(o2) + " " + z.get(o3));
    }

    public static void main(String[] args) throws Exception {
        ZippedHashMap z = new ZippedHashMap();
        z.test();
    }

    class SimpleObject
    implements Serializable {
        private Integer data;
        private int hashCode;

        public SimpleObject(int n) {
            this.data = new Integer(n);
        }

        public void setHashCode(int n) {
            this.hashCode = n;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object otherObject) {
            if (otherObject instanceof SimpleObject) {
                return ((SimpleObject)otherObject).getValue() == this.getValue();
            }
            return false;
        }

        public int getValue() {
            return this.data;
        }
    }
}

