/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl;

public class VectorTools {
    public static double[] crossProduct(double[] v) {
        double[] result = new double[v.length * v.length];
        int k = 0;
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                result[k] = v[i] * v[j];
                ++k;
            }
        }
        return result;
    }

    public static int[] crossProduct(int[] v) {
        int[] result = new int[v.length * v.length];
        int k = 0;
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v.length; ++j) {
                result[k] = v[i] * v[j];
                ++k;
            }
        }
        return result;
    }

    public static double[] binaryComplement(double[] v) {
        double[] result = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            result[i] = v[i] == 0.0 ? -1.0 : 1.0;
        }
        return result;
    }

    public static int[] binaryComplement(int[] v) {
        int[] result = new int[v.length];
        for (int i = 0; i < v.length; ++i) {
            result[i] = v[i] == 0 ? -1 : 1;
        }
        return result;
    }

    public static String vectorToText(double[] a) {
        String result = "";
        for (int i = 0; i < a.length; ++i) {
            result = result + a[i] + " ";
        }
        return result + "";
    }

    public static double sum(double[] v) {
        double result = 0.0;
        for (int i = 0; i < v.length; ++i) {
            result += v[i];
        }
        return result;
    }

    public static double abssum(double[] v) {
        double result = 0.0;
        for (int i = 0; i < v.length; ++i) {
            result += Math.abs(v[i]);
        }
        return result;
    }

    public static double sum(double[][] v) {
        double result = 0.0;
        for (int i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[0].length; ++j) {
                result += v[i][j];
            }
        }
        return result;
    }

    public static double[] vsub(double[] v1, double[] v2) {
        double[] result = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            result[i] = v1[i] - v2[i];
        }
        return result;
    }

    public static double[] vsub(double[] v1, int[] v2) {
        double[] result = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            result[i] = v1[i] - (double)v2[i];
        }
        return result;
    }

    public static double[][] vsub(double[][] v1, double[][] v2) {
        double[][] result = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                result[i][j] = v1[i][j] - v2[i][j];
            }
        }
        return result;
    }

    public static double[] vadd(double[] v1, double[] v2) {
        double[] result = new double[v1.length];
        for (int i = 0; i < v1.length; ++i) {
            result[i] = v1[i] + v2[i];
        }
        return result;
    }

    public static double[][] vadd(double[][] v1, double[][] v2) {
        double[][] result = new double[v1.length][v1[0].length];
        for (int i = 0; i < v1.length; ++i) {
            for (int j = 0; j < v1[0].length; ++j) {
                result[i][j] = v1[i][j] + v2[i][j];
            }
        }
        return result;
    }

    public static double[] vmul(double scalar, double[] vector) {
        double[] result = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            result[i] = scalar * vector[i];
        }
        return result;
    }

    public static double[] vmul(double scalar, int[] vector) {
        double[] result = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            result[i] = scalar * (double)vector[i];
        }
        return result;
    }

    public static double vdot(double[] v1, double[] v2) {
        double result = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            result += v1[i] * v2[i];
        }
        return result;
    }

    public static double vdot(int[] v1, double[] v2) {
        double result = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            result += (double)v1[i] * v2[i];
        }
        return result;
    }

    public static double[][] vmul(double scalar, double[][] vector) {
        double[][] result = new double[vector.length][vector[0].length];
        for (int i = 0; i < vector.length; ++i) {
            for (int j = 0; j < vector[0].length; ++j) {
                result[i][j] = scalar * vector[i][j];
            }
        }
        return result;
    }

    public static double dotProduct(double[] u, double[] v) {
        if (u.length != v.length) {
            throw new RuntimeException("Vectors must be of same length for dot product.");
        }
        double result = 0.0;
        for (int i = 0; i < u.length; ++i) {
            result += u[i] * v[i];
        }
        return result;
    }

    public static double[] normalize(double[] a) {
        double[] result = new double[a.length];
        double vectorLength = Math.sqrt(VectorTools.vdot(a, a));
        if (vectorLength == 0.0) {
            return a;
        }
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] / vectorLength;
        }
        return result;
    }

    public static int[] normalize(int[] a) {
        throw new RuntimeException("Binary [integer] vectors cannot be normalized.");
    }
}

