/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.pakl.rl.IsWinnable;
import net.pakl.rl.NonLearnedStateException;
import net.pakl.rl.State;
import net.pakl.rl.ValueFunction;
import net.pakl.rl.World;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueFunctionHashMap
implements ValueFunction,
Serializable {
    static final long serialVersionUID = 5183569982779176111L;
    HashMap statesToValues = new HashMap();
    private double valueOfTerminalStates = 0.0;
    HashSet worldTerminalStates;
    private double timer = 0.0;
    boolean SAFE_MODE = true;
    boolean ZIPPED = false;
    boolean DATABASE = false;
    double valueOfOutOfBoundsStates = 0.0;
    double valueOfNonStoredStates = 0.0;
    private static final String SAVED_IDENTIFICATION = "ValueFunction Saved Object";
    World world = null;
    private String name = "valuefunction";

    public void setValueOfNonStoredStates(double x) {
        this.valueOfNonStoredStates = x;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setSafeMode(boolean b) {
        this.SAFE_MODE = b;
    }

    public ValueFunctionHashMap(World sourceWorld) {
        this.init(sourceWorld);
    }

    public ValueFunctionHashMap(World sourceWorld, boolean SAFE_MODE) {
        this.SAFE_MODE = SAFE_MODE;
        this.init(sourceWorld);
    }

    public int getSize() {
        return this.statesToValues.keySet().size();
    }

    @Override
    public void setWorld(World w) {
        this.init(w);
    }

    public void init(World sourceWorld) {
        this.world = sourceWorld;
        int counter = 0;
        if (this.SAFE_MODE) {
            try {
                System.out.println("Setting value of each state to zero.");
                Iterator statesIterator = sourceWorld.stateIterator();
                while (statesIterator.hasNext()) {
                    State thisState = (State)statesIterator.next();
                    this.statesToValues.put(thisState, new Double(0.0));
                    ++counter;
                }
                System.out.println("Set " + counter + " items to zero.");
            }
            catch (Exception e) {
                System.err.println("Had problem initializing all states of the value function.\nIf you did not define a complete list of states\nin your World, you should set SAFE_MODE to\nfalse on the value function so that it will return a\ndefault value for unstored states.");
                System.err.println("The specific error was: " + e.getMessage());
                throw new RuntimeException("Simulation terminated because value function not initialized.");
            }
        } else {
            System.out.println("ValueFunctionHashMap not in safe mode: will not throw exception if queried for non-existant state.");
        }
    }

    public void setValueOfOutOfBoundsStates(double newValueOfOutOfBoundsStates) {
        this.valueOfOutOfBoundsStates = newValueOfOutOfBoundsStates;
    }

    public void setAllowExpansionOfStateBounds(boolean trueOrFalse) {
        throw new RuntimeException("Not implemented.");
    }

    private HashMap convertListToHashMap(List list) {
        HashMap result = new HashMap(list.size());
        Iterator i = list.iterator();
        while (i.hasNext()) {
            result.put(i.next(), "");
        }
        return result;
    }

    public ValueFunctionHashMap() {
        throw new RuntimeException("You should initialize the value function with the world so that it knows what the terminal states are.");
    }

    public Iterator getKeySetIterator() {
        return this.statesToValues.keySet().iterator();
    }

    public Set<State> getKeySet() {
        return this.statesToValues.keySet();
    }

    public void clear() {
        this.statesToValues.clear();
    }

    public int size() {
        return this.statesToValues.size();
    }

    @Override
    public double getValue(State state) {
        if (this.world instanceof IsWinnable) {
            IsWinnable game = (IsWinnable)((Object)this.world);
            if (game.isWinState(state)) {
                return 1.0;
            }
            if (game.isLoseState(state)) {
                return -1.0;
            }
            if (game.isDrawState(state)) {
                return 1.0;
            }
        }
        if (this.world.isTerminalState(state)) {
            return this.valueOfTerminalStates;
        }
        Double value = (Double)this.statesToValues.get(state);
        if (value == null) {
            if (this.SAFE_MODE) {
                throw new NonLearnedStateException("\n\nQueried for non-stored state, don't have generalization ability.\nAre you testing on a state which was never trained? Check your test corpus.\nUnknown state was: " + state);
            }
            return this.valueOfNonStoredStates;
        }
        return value;
    }

    public double getTimer() {
        return this.timer;
    }

    public void resetTimer() {
        this.timer = 0.0;
    }

    public void addTimer(double time) {
        this.timer += time;
    }

    @Override
    public void setValue(State state, double newValue) {
        this.statesToValues.put(state, new Double(newValue));
    }

    public void saveTo(String filename) throws Exception {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(filename));
        out.writeObject(SAVED_IDENTIFICATION);
        out.writeObject(this.statesToValues);
        out.close();
    }

    public void loadFrom(String filename) throws Exception {
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(filename));
        String s = (String)in.readObject();
        if (!s.equals(SAVED_IDENTIFICATION)) {
            throw new RuntimeException("Error: ValueFunction.loadFrom read from a file that contained something other than a ValueFunction -- a " + s);
        }
        this.statesToValues = (HashMap)in.readObject();
        in.close();
    }

    public String toText() {
        boolean j = false;
        DecimalFormat decimalFormat = new DecimalFormat("#0.00");
        StringBuffer result = new StringBuffer("");
        for (State s : this.statesToValues.keySet()) {
            double value = (Double)this.statesToValues.get(s);
            System.out.print("vf(" + s + ") " + s.hashCode() + " = " + decimalFormat.format(value) + "\n");
        }
        return result.toString();
    }

    @Override
    public void setValueOfTerminalStates(double newValueOfTerminalStates) {
        this.valueOfTerminalStates = newValueOfTerminalStates;
    }
}

