/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;

public class HashMapFile
extends HashMap {
    HashMap cache = new HashMap();
    long uniqueID = System.currentTimeMillis();

    public HashMapFile(int numStates) {
        this();
    }

    public HashMapFile() {
    }

    public Object put(Object key, Object value) {
        String fileName = this.uniqueID + "-" + key.hashCode() + ".dat";
        try {
            HashMap map = null;
            try {
                ObjectInputStream oi = new ObjectInputStream(new FileInputStream(fileName));
                map = (HashMap)oi.readObject();
                oi.close();
            }
            catch (Exception e) {
                map = new HashMap();
            }
            map.put(key, value);
            ObjectOutputStream oo = new ObjectOutputStream(new FileOutputStream(fileName));
            oo.writeObject(map);
            oo.close();
            this.cache.put(key, map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object get(Object key) {
        try {
            String fileName = this.uniqueID + "-" + key.hashCode() + ".dat";
            HashMap map = (HashMap)new ObjectInputStream(new FileInputStream(fileName)).readObject();
            if (map == null) {
                return null;
            }
            Object valueAssociatedWithKey = map.get(key);
            return valueAssociatedWithKey;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void test() {
        HashMapFile z = this;
        z.put("Hi", "Hello");
        z.put("Bye", "Goodbye");
        System.out.println("Should give results:" + z.get("Hi") + " " + z.get("Bye"));
        System.out.println("Should give nulls:" + z.get("Hi2") + " " + z.get("Bye2"));
        SimpleObject o1 = new SimpleObject(100);
        SimpleObject o2 = new SimpleObject(101);
        SimpleObject o3 = new SimpleObject(102);
        o1.setHashCode(1);
        o2.setHashCode(1);
        o3.setHashCode(1);
        z.put(o1, "one");
        z.put(o2, "two");
        z.put(o3, "three, compressed in same entry.");
        System.out.println(z.get(o1) + " " + z.get(o2) + " " + z.get(o3));
    }

    public static void main(String[] args) throws Exception {
        HashMapFile z = new HashMapFile();
        z.test();
    }

    class SimpleObject
    implements Serializable {
        private Integer data;
        private int hashCode;

        public SimpleObject(int n) {
            this.data = new Integer(n);
        }

        public void setHashCode(int n) {
            this.hashCode = n;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object otherObject) {
            if (otherObject instanceof SimpleObject) {
                return ((SimpleObject)otherObject).getValue() == this.getValue();
            }
            return false;
        }

        public int getValue() {
            return this.data;
        }
    }
}

