/*
 * Decompiled with CFR 0.152.
 */
package net.pakl.rl;

import java.util.Iterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.pakl.rl.Agent;
import net.pakl.rl.State;
import net.pakl.rl.ValueFunction;
import net.pakl.rl.ValueFunctionHashMap;

public class AgentParallelized
extends Agent {
    protected int threadsAtATime = 2;
    static int uniqueThreadNumber = 0;

    public AgentParallelized(String newName, int numThreads) {
        super(newName);
        this.name = newName;
        this.threadsAtATime = numThreads;
        System.err.println("! Agent " + this.getName() + " has been created.");
    }

    public AgentParallelized(int numThreads) {
        this("ParalellizedAgent", numThreads);
        this.threadsAtATime = numThreads;
    }

    private synchronized int getUniqueThreadNumber() {
        return ++uniqueThreadNumber;
    }

    public ValueFunction performValueIteration(final ValueFunction newValueFunction, final ValueFunction valueFunction) {
        final Iterator stateIterator = ((ValueFunctionHashMap)valueFunction).getKeySetIterator();
        this.totalDelta = 0.0;
        uniqueThreadNumber = 0;
        ArrayBlockingQueue<Runnable> myJobQueue = new ArrayBlockingQueue<Runnable>(this.threadsAtATime);
        ThreadPoolExecutor pool = new ThreadPoolExecutor(this.threadsAtATime, this.threadsAtATime, 100L, TimeUnit.MILLISECONDS, myJobQueue, new ThreadPoolExecutor.CallerRunsPolicy());
        while (stateIterator.hasNext()) {
            pool.execute(new Runnable(){

                public void run() {
                    State currentState = null;
                    int myNumber = AgentParallelized.this.getUniqueThreadNumber();
                    long startTime = System.currentTimeMillis();
                    System.out.println(myNumber + " start");
                    for (int i = 0; i < 100000 && stateIterator.hasNext(); ++i) {
                        currentState = (State)stateIterator.next();
                        if (currentState == null) continue;
                        AgentParallelized.this.performValueIterationUpdateOnState(newValueFunction, valueFunction, currentState);
                    }
                    System.out.println(myNumber + " done, duration=" + (System.currentTimeMillis() - startTime) + "ms");
                }
            });
        }
        pool.shutdown();
        try {
            pool.awaitTermination(10000L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pool.getPoolSize() > 0) {
            throw new RuntimeException("There were still threads running and we got here.");
        }
        this.averageDelta = this.totalDelta / (double)this.world.getNumberOfStates();
        System.out.println("avgDelta = " + this.averageDelta + " maxDelta was " + this.maximumDelta + " totalDelta was " + this.totalDelta);
        return newValueFunction;
    }
}

