package net.pakl.tools;

import java.util.*;
import java.io.*;


// example input file
//
// channel 1 @ 0 = 100 Hz
// channel 1 @ 50 = 100 Hz
// channel 1 @ 100 = 200 Hz
// channel 2 @ 0 = 200 Hz

public class FormantScheduler
{
//    public static int VOICING_AMPLITUDE = 1;
    public static int VOICING_AMPLITUDE = 38;
    public static int FIRST_FORMANT_AMPLITUDE_PARALLEL = 24;
    public static int SECOND_FORMANT_AMPLITUDE_PARALLEL = 26;
    public static int THIRD_FORMANT_AMPLITUDE_PARALLEL = 28;
    public static int FOURTH_FORMANT_AMPLITUDE_PARALLEL = 30;
    public static int [] frame = new int[40];
    public FormantScheduler()
    {
    }
    
    String filename;
    int numChannels = 5;
    int granularity = 1;
    int timesteps = 200;
    double [][] frequencies; 
    double [][] amplitudes; 
    
    public void process(String filename) throws Exception
    {
        load(filename);
        interpolate();
        save(filename+".freq");
    }
    
    public void save(String filename) throws Exception
    {
        BufferedWriter b = new BufferedWriter(new FileWriter(filename));
        for (int t = 0; t < timesteps; t++)
        {
            for (int c = 0; c < numChannels; c++)
            {
                frame[c*2] = (int) Math.round(frequencies[c][t]);
                frame[FIRST_FORMANT_AMPLITUDE_PARALLEL+c*2] = (int) Math.round(amplitudes[c][t]);
            }
            frame[VOICING_AMPLITUDE] = (int) Math.round(amplitudes[0][t]);
            b.write(implode(frame)+"\n");
        }
        b.close();
    }
        
    public int findNonzero(double [] values, int startingFrom)
    {
        for (int i = startingFrom; i < values.length; i++)
        {
            if (values[i] != 0)
            {
                return i;
            }
        }
        return values.length-1;
    }
    /** Interpolates between nonzero values */
    private void interpolate()
    {
        for (int c = 0; c < numChannels; c++)
        {
            System.err.println("Channel " + c);
                int startTime = 0, endTime = 0;
                while (endTime < (timesteps-1))
                {
                    startTime = findNonzero(frequencies[c], endTime);
                    endTime = findNonzero(frequencies[c], startTime+1);

                    if ((endTime == 0) || (startTime == (timesteps-1)) || ((endTime-startTime)<=0))
                    {
                        break;
                    }
                    else
                    {
                        System.err.println(" "+frequencies[c][startTime] + "Hz @ " + startTime + "ms --> " + frequencies[c][endTime] + "Hz @ " + endTime + "ms");
                    }
                    interpolate(frequencies[c], startTime, endTime);
                    interpolate(amplitudes[c], startTime, endTime);
                }
        }
    }
    
    private void interpolate(double values[], int start, int end)
    {
        double slope = (values[end] - values[start]) / (double)(end-start);
        int steps = 0;
        for (int i = start+1; i <= (end-1); i++)
        {
            steps++;
            values[i] = values[start] + slope * steps;
        }
        
    }
    
    private void load(String filename) throws Exception
    {
        int lineNumber = 1;
        Scanner s = new Scanner(new File(filename));
        if (s.next().equals("timesteps"))
        {
            timesteps = s.nextInt();
        }
        
        frequencies = new double[numChannels][granularity * timesteps];
        amplitudes = new double[numChannels][granularity * timesteps];

        while (s.hasNext())
        {
            if (!s.next().equals("channel")) 
            { 
                throw new RuntimeException("unexpected data, line "+lineNumber+"."); 
            }
            int channelNumber = s.nextInt();
            if (!s.next().equals("@")) { throw new RuntimeException("unexpected data, line "+lineNumber+"."); }
            int time = s.nextInt();
            s.next();                   // =
            double freq = (double) s.nextInt();
            s.next();                   // Hz
            double amplitude = 100.0d;
            if (s.hasNext())
            {
                amplitude = (double) s.nextInt();
            }
            System.err.println("c="+channelNumber+" t="+time+" freq="+freq+" ampl="+amplitude);
            frequencies[channelNumber][time/granularity] = freq;
            amplitudes[channelNumber][time/granularity] = amplitude;
        }
    }
    
    public static void main(String args[]) throws Exception
    {
        String dummyFrame =     "1000 70 497 0 739 0 2772 0 3364 0 4170 0 4000 0 0 0 200 40  0 40  0 20  0  0 53 44 79 70 52 95 44 56 34 80  0 80  0  0 27 0";

        frame = explodeToInts(dummyFrame, " ");
        if (args.length == 0)
        {
            System.err.println("Pass filename as first argument");
            System.exit(1);
        }
        (new FormantScheduler()).process(args[0]);
    }
    
    public static int [] explodeToInts(String s, String delim)
    {
        StringTokenizer t = new StringTokenizer(s, delim);
        int [] result = new int[t.countTokens()];

        Scanner sc = new Scanner(s);
        int i = 0;
        while (sc.hasNextInt())
        {
            result[i] = sc.nextInt();
            i++;
        }
        return result;
    }
    
    public static String implode(int [] a)
    {
        String result = "";
        for (int i = 0; i < a.length; i++)
        {
            result = result + a[i] + " ";
        }
        return result;
    }
}
