/*
 * VoiceTrainerWordRecognizer.java
 *
 * Created on August 27, 2004, 10:31 AM
 */

package net.pakl.neuralnet;

import java.io.*;
import java.util.*;

/**
 *
 * @author  patryk
 */
public class VoiceTrainerWordRecognizer extends VoiceTrainer
{
    public static String CONFIGURATION_FILE = "wordrecognizer.prop";
    //String outputCodeList = "not set";
    


    public VoiceTrainerWordRecognizer() throws Exception
    {
        super();
    }

    
    public static void main(String args[]) throws Exception
    {
        VoiceTrainerWordRecognizer vt = new VoiceTrainerWordRecognizer();
        vt.loadProperties(CONFIGURATION_FILE);
        System.out.println("run()");
        vt.run();
        System.out.println("runProbes()");
	vt.runProbes();
    }

    public void runProbes() throws Exception
    {
	List soundPatternsInput = readSoundPatterns(stringToList(probeList), true);
	List soundPatternsOutput = readSoundPatterns(stringToList(probeList), false);
	probe(probeList, soundPatternsInput, soundPatternsOutput);
    }

    public void showProperties()
    {
        super.showProperties();
        System.out.println("outputCodeList    = " + outputCodeList);
    }
    
    private List repeatOutputForInputDuration(List inputs, List shortOutputs)
    {
        List result = new ArrayList();
        for (int i = 0; i < inputs.size(); i++)
        {
            List sequence = (List) inputs.get(i);
            double [] outputPattern = (double []) ((List) ((List) shortOutputs).get(i)).get(0); 
            Iterator j = sequence.iterator();
            ArrayList extendedSequence = new ArrayList();
            while (j.hasNext())
            {
                j.next();
                extendedSequence.add(outputPattern);
            }
            result.add(extendedSequence);
            System.out.println("Output pattern #"+i+" extended to "+extendedSequence.size()+" timesteps.");
        }
        return result;
    }
    public void run() throws Exception
    {
        System.out.println("Load inputs " + inputList);
        List soundPatternsInput = readSoundPatterns(stringToList(inputList), true);
        System.out.println("Load outputs " + outputCodeList);
        List outputsTemp = readSoundPatterns(stringToList(outputCodeList), false);
        System.out.println("Temporally spread outputs");
        List outputCodeList = repeatOutputForInputDuration(soundPatternsInput, outputsTemp);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.setTotalItems(trials);
        for (int i = 0; i < trials; i++)
        {
            System.out.print("Training Trial " + (i+1) + " of " + trials + "\n");
            stopwatch.start();
            train(soundPatternsInput, outputCodeList);

            stopwatch.stop();
            System.out.println(stopwatch.getResult() + " " + stopwatch.estimate());
	    if (saveEvery > 0)
	    {
		if ((i % saveEvery) == 0)
		{
			(new ObjectOutputStream(new FileOutputStream(srnaToSave+"-"+i))).writeObject(srna);
		}
	    }
            if (receivedEndRunMessage()) break;
        }
	if (!srnaToSave.equals(""))
	{
		(new ObjectOutputStream(new FileOutputStream(srnaToSave))).writeObject(srna);
	}
        recordInputsAndOutputs(soundPatternsInput);
    }

    private boolean receivedEndRunMessage()
    {
        File f = new File("endrun.msg");
        if (f.exists())
        {
            System.out.println("File endrun.msg exists, stopping run.");
            return true;
        }
        return false;
    }
    
}
