/*
 * VectorComparer.java
 *
 * Created on March 5, 2004, 8:47 PM
 */

package net.pakl.neuralnet;

/**
 *
 * @author  patryk
 */
public class VectorComparer
{
    
    /** Creates a new instance of VectorComparer */
    public VectorComparer()
    {
    }
    
    public static double [] normalize(double [] a)
    {
        double [] result = new double[a.length];
        double vectorLength = Math.sqrt(dot(a, a));
        if (vectorLength == 0)
        {
	    return a;
        }
        for (int i = 0; i < a.length; i++)
        {
            result[i] = a[i] / vectorLength;
        }
        return result;
    }
    
    public static double normalizedDotProduct(double [] a, double [] b)
    {
        if (a.length != b.length)
        {
            throw new RuntimeException("Vectors to compare must be the same size.");
        }
        
        double aSumSquared = dot(absVector(a), absVector(a));
        double bSumSquared = dot(absVector(b), absVector(b));
        // System.out.println("double result = " + dot(a, b) + " / Math.sqrt( " + aSumSquared + " * " + bSumSquared+ ")");
        double result = dot(a, b) / Math.sqrt(aSumSquared * bSumSquared);
        return result;
    }

    private static double[] absVector(double [] a)
    {
        double [] result = new double[a.length];
        for (int i = 0; i < a.length; i++)
        {
            result[i] = Math.abs(a[i]);
        }
        return result;
    }
    
    private static double dot(double [] a, double [] b)
    {
        double result = 0.0d;
        for (int i = 0; i < a.length; i++)
        {
            result += a[i] * b[i];
        }
        return result;
    }
    
    private static double sum(double [] a)
    {
        double sum = 0.0d;
        for (int i = 0; i < a.length; i++)
        {
            sum = sum + a[i];
        }
        return sum;
    }
    
    public static void main(String args[])
    {
        double a1[] = {0.1d, 0.1d, 0.1d, 0.1d};
        double a2[] = {0.2d, 0.2d, 0.2d, 0.2d};
        double a3[] = {0.1d, 0.3d, 0.1d, 0.3d};
        System.out.println(normalizedDotProduct(a1, a2));
        System.out.println(normalizedDotProduct(a1, a1));
        System.out.println(normalizedDotProduct(a1, a3));
        System.out.println(normalizedDotProduct(a2, a3));
    }

    public static void showVectorsInList(java.util.List doubleVectors)
    {
        for (int i = 0; i < doubleVectors.size(); i++)
        {
            showVector( (double[]) doubleVectors.get(i));
            System.out.println("");
        }
    }
    
    public static void showVector(double [] a)
    {
        for (int i = 0; i < a.length; i++)
        {
            System.out.print(a[i]+" ");
        }
    }
        
}
