package net.pakl.neuralnet;
import java.io.*;

public class SimpleRecurrentNetAverager extends SimpleRecurrentNet implements Serializable
{

    double [] preserveFactor = new double[numNeurons];  // 0 means no activity preserved (always changes), 
                                                        // 1 means activity never changes
                                                            
//    double [] previousActivity = new double[numNeurons];
    double [] previousNetInput = new double[numNeurons];
    
    /** Just like a simple recurrent network, but the activity of 
     each neuron must be running-averaged before passing on its activity
     to the next neurons.     
     * Or -- should the running averager only be used for the purposes of synaptic modification?     
     */    
    public SimpleRecurrentNetAverager(long randomSeed, int numNeurons, double learningRate, double momentumTerm, int[] layerBreaks)
    {
        super(randomSeed, numNeurons, learningRate, momentumTerm, layerBreaks);
        System.out.println("SRN-Averager 20060929-01");
    }
    
    public SimpleRecurrentNetAverager(long randomSeed, int numNeurons, double learningRate, double momentumTerm, int[] layerBreaks, double initialRandomWeightFactor)
    {
        super(randomSeed, numNeurons, learningRate, momentumTerm, layerBreaks, initialRandomWeightFactor);
        System.out.println("SRN-Averager 20060929-01");
    }
    
    /** Does not offset by BIAS neuron or anything -- so you need to know exactly which neuron is being
     * altered by this command. */
    public void setPreserveFactor(int neuron, double newFactor)
    {
        preserveFactor[neuron] = newFactor;
    }
    
    public String getTextRepresentation()
    {
        String result = "";
        result += " There are "+numContextNeurons+" context neurons.\n";
        result += " There are "+NUM_BIAS_NEURONS+" bias neurons.";
        for (int i = 0; i < this.numNeurons; i++)
        {
            for (int j = 0; j < this.layerBreaks.length; j++)
            {
                if (this.layerBreaks[j] == i) result = result + ("\n");
            }
            if (i < NUM_BIAS_NEURONS) { result = result + ("B"); } 
            else if (i < numContextNeurons+NUM_BIAS_NEURONS) { result = result + ("C"); }
            else result = result + ("N");
            result = result + ("(" + preserveFactor[i] + ") ");
        }
        return result;
    }
    
    public void resetRunningAveragers()
    {
	for (int i = 0; i < numNeurons; i++)
	{
		previousNetInput[i] = 0;
	}
    }

    public void feedforward(double[] inputPattern)
    {
        for (int i = 0; i < numNeurons; i++)
        {
            previousNetInput[i] = netInput[i];
        }
        
        // ACTIVATE THE BIAS NEURONS
        for (int i = 0; i < NUM_BIAS_NEURONS; i++)
        {
            netInput[i] = BIAS_ACTIVATION;                                  // Bias node/neuron.
        }
        
        // ACTIVATE ALL OTHER NON-BIAS NEURONS
        int inputPatternIndex = 0;
        for (int post = 0 + NUM_BIAS_NEURONS + numContextNeurons; post < numNeurons; post++)
        {
            netInput[post] = 0;

            if (inputPatternIndex < inputPattern.length) 
            { 
                netInput[post] += (1.0d-preserveFactor[post]) * inputPattern[inputPatternIndex]
                               + preserveFactor[post] * previousNetInput[post];
                activity[post] = netInput[post];
//                activity[post] = sigmoid(netInput[post]);
            }
            else
            {
                for (int pre = 0; pre < post; pre++)
                {
                    if (connected[pre][post])
                    {
                          netInput[post] = netInput[post] + (weight[pre][post] * activity[pre]);
                    }
                }

                activity[post] = sigmoid(netInput[post]);
            }
            

            inputPatternIndex++;
        }
    }

    
}
