package net.pakl.neuralnet;

import java.io.*;
import java.awt.event.*;

public class SRNApp extends javax.swing.JFrame
{
    
    /** Initializes the applet SRNApplet */
    public void init()
    {
        initComponents();
        initialize();
        this.setSize(1024,500);
        this.setVisible(true);
        this.update(this.getGraphics());  
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents()//GEN-BEGIN:initComponents
    {
        jTextField1 = new javax.swing.JTextField();
        jScrollPane1 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jLabel1 = new javax.swing.JLabel();
        jTextArea2 = new javax.swing.JTextArea();

        getContentPane().setLayout(null);

        setForeground(java.awt.Color.gray);
        getContentPane().add(jTextField1);
        jTextField1.setBounds(40, 410, 530, 20);

        jTextArea1.setEditable(false);
        jTextArea1.setFont(new java.awt.Font("Courier New", 0, 12));
        jScrollPane1.setViewportView(jTextArea1);

        getContentPane().add(jScrollPane1);
        jScrollPane1.setBounds(20, 130, 840, 270);

        jLabel1.setText(">");
        getContentPane().add(jLabel1);
        jLabel1.setBounds(10, 410, 20, 20);

        jTextArea2.setEditable(false);
        jTextArea2.setFont(new java.awt.Font("Courier New", 0, 12));
        jTextArea2.setText("------------------------------------------------------------------------------\n| Simple Recurrent Neural Network ASCII Interface Version 1.00               |\n| Copyright (C) 2004 Patryk Laurent (patryk@cnbc.cmu.edu)                    |\n|                                                                            |\n|       o--< o--< o                                                          |\n|       v    |                                                               |\n|       \\____/                                                               |\n------------------------------------------------------------------------------");
        getContentPane().add(jTextArea2);
        jTextArea2.setBounds(70, 10, 560, 120);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTextArea jTextArea1;
    private javax.swing.JTextArea jTextArea2;
    private javax.swing.JTextField jTextField1;
    // End of variables declaration//GEN-END:variables

    PipedInputStream piOut;
    PipedOutputStream poOut;
    PipedOutputStream poIn;
    PipedInputStream piIn;
    BufferedOutputStream bufferedPiIn;
    public void initialize()
    {
        try
        {

            System.err.println("\nINITIALIZE!");
            piOut  = new PipedInputStream();
            poOut = new PipedOutputStream(piOut);
            poIn  = new PipedOutputStream();
            piIn   = new PipedInputStream(poIn);
            final BufferedOutputStream bufferedPoIn = new BufferedOutputStream(poIn);
            
            System.setOut(new PrintStream(poOut, true));

            System.setIn(piIn);
            new ReaderThread(piOut, this.jTextArea1).start();
            
            SRNInterface srnInterface = new SRNInterface();

            System.err.println("\n\nSTARTED!");
            
            jTextField1.addActionListener(new java.awt.event.ActionListener()
                                    {
                                        public void actionPerformed(ActionEvent e)
                                        {
                                            try
                                            {
                                                String withLine = jTextField1.getText() + "\n";
                                                System.out.print(withLine);
                                                poIn.write(withLine.getBytes(), 0, withLine.length());
                                                jTextField1.setText("");
                                            }
                                            catch (Exception ex)
                                            {
                                                ex.printStackTrace();
                                            }
                                        }
                                    }
            );
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        addWindowListener(new java.awt.event.WindowAdapter()
        {
            public void windowClosing(java.awt.event.WindowEvent evt)
            {
                System.exit(1);
            }
        });
    }

    class ReaderThread extends Thread {
            PipedInputStream pi;
            javax.swing.JTextArea textArea;
            ReaderThread(PipedInputStream pi, javax.swing.JTextArea textArea) 
            {
                this.pi = pi;
                this.textArea = textArea;
            }
    
            public void run() 
            {
                final byte[] buf = new byte[1024];
                try {
                    while (true) 
                    {
                        final int len = pi.read(buf);
                        if (len == -1) 
                        {
                            break;
                        }
                        textArea.append(new String(buf, 0, len));

                        // Make sure the last line is always visible
                        textArea.setCaretPosition(textArea.getDocument().getLength());
    
                    }
                }
                catch (IOException e) {
                }
            }
        }
    
    
    public static void main(String args[])
    {
        SRNApp s = new SRNApp();
        s.init();
        s.show();
    }
}
