package net.pakl.neuralnet;

import java.io.*;
import java.util.*;
import java.math.*;

public class PerceptronTrainer
{

	Perceptron net;
	List inputs = new ArrayList();
	List outputs = new ArrayList();
	String inputsFileName = "inputs.txt";
	String outputsFileName = "outputs.txt";
	ArrayList items = new ArrayList();
	int trials;
	int inputLayer, hiddenLayer, secondHiddenLayer, outputLayer;
        int numBiasNeurons = 1;
	Random rng;

	int randomSeed;

	public PerceptronTrainer()
	{
		try
		{
			getProperties();
			rng = new Random(randomSeed);
			loadPatterns();
			for (int j = 0; j < inputs.size(); j++)
			{
				items.add(new Triplet(new Integer(j), inputs.get(j), outputs.get(j)));
			}
			run();
		}
		catch (Exception e)
		{
			System.out.println("An error occured, sorry. " + e.getMessage());
			e.printStackTrace();
		}
	}
	
	public void loadPatterns() throws Exception
	{
		inputs = loadListFromFile(inputsFileName);
		outputs = loadListFromFile(outputsFileName);
	}

	public List loadListFromFile(String filename) throws Exception
	{
		ArrayList result = new ArrayList();
		BufferedReader f1 = new BufferedReader(new FileReader(filename));
		while (f1.ready())
		{
			String datafilename = f1.readLine();
			
			BufferedReader f2 = new BufferedReader(new FileReader(datafilename));
			String data = f2.readLine();
			StringTokenizer t = new StringTokenizer(data, " ", false);
			double [] item = tokenizerToDoubles(t);
			result.add(item);
			f2.close();
		}
		f1.close();
		return result;
	}
	
	public void run() throws Exception
	{
		train();
		test();
                System.out.println("Writing neural network to output.obj");
                new ObjectOutputStream(new FileOutputStream("output.obj")).writeObject(net);
	}
	public void test()
	{
                showOutputLayerActivities();
                System.out.println("Hidden layer activities.");
		for (int i = 0; i < inputs.size(); i++)
		{
			net.feedforward((double[]) inputs.get(i));
			for (int j = inputLayer; j < (inputLayer + hiddenLayer); j++)
			{
				System.out.print(net.getActivity(j) + " ");
			}
			System.out.println("");
		}
                System.out.println(net.getGraphviz(0.1, 1.0));
	}

        public void showOutputLayerActivities()
        {
            int firstOutputNeuron = net.getNumNeurons() - outputLayer - 1;
            System.out.println("Output layer activities.");
            for (int i = 0; i < inputs.size(); i++)
            {
                    net.feedforward((double[]) inputs.get(i));
                    for (int j = 0; j < outputLayer; j++)
                    {
                            System.out.print(net.getActivity(firstOutputNeuron + j) + "\t");
                    }
                    System.out.println("");
            }
        }

        public void train()
	{
		Collections.shuffle(items, rng);

		for (int i = 0; i < trials; i++)
		{
			if (i % 1000 == 0) { System.out.print("Trial " +i + " "); }		
			for (int j = 0; j < inputs.size(); j++)
			{
				net.feedforward((double[])  ((Triplet)items.get(j)).get2() );
				net.backpropogate((double[]) ((Triplet)items.get(j)).get3() );
                                if (i % 1000 == 0) System.out.printf("%.3f ", net.getSumSquaredError());
			}
                        if (i % 1000 == 0) System.out.println("");
		}
		
	}	

    class Triplet
    {
       private Object a, b, c; 
       public Triplet(Object a, Object b, Object c)
       {
                this.a = a;
                this.b = b;
                this.c = c;
        }
        public Object get1() { return a; }
        public Object get2() { return b; }
        public Object get3() { return c; }
    }



	public void getProperties() throws Exception
	{
		System.out.println("Loading properties from perceptrontrainer.prop.");
		Properties p = new Properties();
		p.load(new FileInputStream("perceptrontrainer.prop"));
		System.out.println("Loading inputLayer size...");
		inputLayer = new Integer(p.getProperty("inputLayer")).intValue();
		System.out.println("hiddenLayer");
		hiddenLayer = new Integer(p.getProperty("hiddenLayer")).intValue();
		System.out.println("outputLayer");
		outputLayer = new Integer(p.getProperty("outputLayer")).intValue();
		int layerBreaks [] = null;
		System.out.println("trials");
		trials = new Integer(p.getProperty("trials")).intValue();
		System.out.println("randomSeed");
		randomSeed = new Integer(p.getProperty("randomSeed")).intValue();
		System.out.println("learningRate and momentumTerm");
                
                if (p.getProperty("numBiasNeurons") != null)
                {
                    numBiasNeurons = new Integer(p.getProperty("numBiasNeurons")).intValue();
                }
                
                if (p.getProperty("secondHiddenLayer") != null)
                {
                    secondHiddenLayer = new Integer(p.getProperty("secondHiddenLayer")).intValue();
                    layerBreaks = new int[4];
                    layerBreaks[0] = inputLayer;
                    layerBreaks[1] = inputLayer+hiddenLayer;
                    layerBreaks[2] = inputLayer+hiddenLayer+secondHiddenLayer;
                    layerBreaks[3] = inputLayer+hiddenLayer+secondHiddenLayer+outputLayer;
                    net = new Perceptron(randomSeed,
                            inputLayer + hiddenLayer + secondHiddenLayer + outputLayer,
                            new Double (p.getProperty("learningRate")).doubleValue(),
                            new Double (p.getProperty("momentumTerm")).doubleValue(),
                            layerBreaks, numBiasNeurons);
                }
                else
                {
                    layerBreaks = new int[3];
                    layerBreaks[0] = inputLayer;
                    layerBreaks[1] = inputLayer+hiddenLayer;
                    layerBreaks[2] = inputLayer+hiddenLayer+outputLayer;
                    net = new Perceptron(randomSeed,
                            inputLayer + hiddenLayer + outputLayer,
                            new Double (p.getProperty("learningRate")).doubleValue(),
                            new Double (p.getProperty("momentumTerm")).doubleValue(),
                            layerBreaks, numBiasNeurons);
                }
                System.out.print("Layer breaks: ");
                for (int i = 0; i < layerBreaks.length; i++)
                {
                    System.out.print(layerBreaks[i] + " ");
                }
                System.out.println("");

                

		if (p.getProperty("randomInitialScale") != null)
		{
			double initialRandomScale = new Double(p.getProperty("randomInitialScale"));
			net.reinitializeRandomWeightsWith(initialRandomScale);
		}
                if (new File("input.obj").exists())
                {
                    System.out.println("Loading perceptron from input.obj file.");
                    net = (Perceptron) new ObjectInputStream(new FileInputStream("input.obj")).readObject();
                }
                else
                {
                    System.out.println("No input.obj perceptron to load in.");
                }
			
	}
    protected double [] tokenizerToDoubles(StringTokenizer t)
    {
        double [] result = new double[t.countTokens()];
        int i = 0;
        while (t.hasMoreTokens())
        {
            result[i] = new Double(t.nextToken()).doubleValue();
            i++;
        }
        return result;
    }    

	
	public static void main(String args[])
	{
		PerceptronTrainer trainer = new PerceptronTrainer();
	}
}
