/*
 * PerceptronTest.java
 *
 * Created on February 25, 2004, 2:17 PM
 */

package net.pakl.neuralnet;

/**
 *
 * @author  patryk
 */
public class PerceptronTest
{
    
    public PerceptronTest()
    {
    }
    
    public static void main(String[] args)
    {
//        double [][] inputs = {  {0.1, 0.2, 0.3} }; 
//        double [][] outputs = { {0.1, 0.3, 0.5} };
        double [][] inputs = {  {0.1, 0.2, 0.3}, 
                                {0.3, 0.4, 0.5},
                                {0.6, 0.7, 0.8}
                            };
        double [][] outputs = { {0.1, 0.3, 0.5},
                                {0.2, 0.4, 0.6},
                                {0.4, 0.7, 0.9}
        
        };
        double learningRate = 0.05;
        double momentumTerm = 0.0;
        int [] layerBreaks = {3, 5, 8};
       
        Perceptron net = new Perceptron(123456, 8, learningRate, momentumTerm, layerBreaks);

        // for (int i = 0; i < outputs.length; i++) { outputs[i] = VectorComparer.normalize(outputs[i]); }
        trainNetwork(net, inputs, outputs, 55000);
        testNetwork(net, inputs, outputs);
    }

    private static void trainNetwork(Perceptron net, double[][] inputList, double[][] targetOutputList, int trials)
    {
        for (int i = 0; i < trials; i++)
        {
            for (int j = 0; j < inputList.length; j++)
            {
                net.feedforward(inputList[j]);
                net.backpropogate(targetOutputList[j]);
            }
            if (i % 1000 == 0) System.out.println("Training trial " + i + " Total Error: " + net.getTotalError());
        }
        //System.out.println(net.getConnectivity());
    }

    private static void testNetwork(Perceptron net, double[][] inputList, double[][] expectedOutputList)
    {
        for (int j = 0; j < inputList.length; j++)
        {
            net.feedforward(inputList[j]);
            System.out.print("goal : "); showVector(expectedOutputList[j]);
            System.out.print("net  : "); showOutput(net);
            System.out.println("\nNormalized Dot = " + VectorComparer.normalizedDotProduct(expectedOutputList[j],  getOutput(net)));
        }
    }
    
    private static double[] getOutput(Perceptron net)
    {
        double result[] = new double[8-5];
        for (int i = 5; i < 8; i++)
        {
            result[i-5] = net.getActivity(i);
        }
        return result;
    }
    
    private static void showVector(double [] a)
    {
        for (int i = 0; i < a.length; i++)
        {
            System.out.print(a[i]+" ");
        }
    }

    private static void showOutput(Perceptron net)
    {
        for (int i = 5; i < 8; i++)
        {
            System.out.print(net.getActivity(i) + " ");
        }
    }
}
