package net.pakl.neuralnet;

public class PerceptronPatrykThesis extends Perceptron
{
    int numUnitsBeforeContextUnits;
    int numContextUnits;
    public PerceptronPatrykThesis(long randomSeed, int numInputUnits, int numContextUnits, int numHiddenUnits, double learningRate, double momentumTerm)
    {
        int [] layerBreaks = new int[3];
        layerBreaks[0] = numInputUnits+numContextUnits;
        layerBreaks[1] = numInputUnits+numContextUnits+numHiddenUnits;
        layerBreaks[2] = numInputUnits+numContextUnits+numHiddenUnits+1;
        this.NUM_BIAS_NEURONS = 1;
        
        this.numContextUnits = numContextUnits;
        this.numUnitsBeforeContextUnits = NUM_BIAS_NEURONS + numInputUnits;
        
        constructPerceptron(randomSeed, numInputUnits+numContextUnits+numHiddenUnits+1, learningRate, momentumTerm, layerBreaks);
    }
    
    protected double sigmoid(double x)
    {
            return (2.0d / (1+Math.exp(-2.0d * x))) - 1.0d;
    }

    protected double sigmoidDerivative(double x)
    {
            return (1.0d - Math.pow(sigmoid(x), 2.0d));
    }
    
    public double [][] getOutputDerivativeAgainstWeights()
    {
        return getOutputNetInputDerivativeAgainstWeights();
    }

    public double [][] getOutputNetInputDerivativeAgainstWeights()
    {
            double [][] derivative = new double[numNeurons][numNeurons];
            for (int post = 0; post < numNeurons; post++)
            {
                    for (int pre = 0; pre < numNeurons; pre++)
                    {
                            if (inLayer(1,pre)) // hidden to output
                            {
                                int hidden = pre;
                                int output = post;
                            	derivative[hidden][output] = activity[hidden];
                            }
                            if (inLayer(0, pre)) // input to hidden
                            {
                                int input = pre;
                                int hidden = post;
                                int output = this.getNumNeurons()-1;
                                derivative[input][hidden] = weight[hidden][output] * sigmoidDerivative(netInput[hidden]) * activity[input];
                            }
                    }
            }
            return derivative;
    }

    public void copyHiddenExcitationToContextUnits()
    {
        // -------------------------------------------------------
        // ACTIVATE ALL CONTEXT UNITS BASED ON FIRST HIDDEN LAYER
        // -------------------------------------------------------
        int hiddenLayerIndex = layerBreaks[0];
        for (int contextUnit = numUnitsBeforeContextUnits; contextUnit < numContextUnits; contextUnit++)
        {
            activity[contextUnit] = activity[hiddenLayerIndex];
            hiddenLayerIndex++;
        }
    }
    public void clearContextUnits()
    {
        for (int contextUnit = numUnitsBeforeContextUnits; contextUnit < numContextUnits; contextUnit++)
        {
            activity[contextUnit] = 0;
        }
    }
    
    
}
