package net.pakl.neuralnet;

public class PerceptronBairdThesis extends Perceptron
{
    
    public PerceptronBairdThesis(long randomSeed, int numInputUnits, int numHiddenUnits, double learningRate, double momentumTerm)
    {
        int [] layerBreaks = new int[3];
        layerBreaks[0] = numInputUnits;
        layerBreaks[1] = numInputUnits+numHiddenUnits;
        layerBreaks[2] = numInputUnits+numHiddenUnits+1;
        this.NUM_BIAS_NEURONS = 1;
        constructPerceptron(randomSeed, numInputUnits+numHiddenUnits+1, learningRate, momentumTerm, layerBreaks);
    }
    /** The sigmoid function here is the hyperbolic tangent, which is a rescaled logisitic function, and its form can be found in Haykin, page 160. */
    protected double sigmoid(double x)
    {
            return (2.0d / (1+Math.exp(-2.0d * x))) - 1.0d;
    }

    protected double sigmoidDerivative(double x)
    {
            return (1.0d - Math.pow(sigmoid(x), 2.0d));
    }
    
    public double [][] getOutputDerivativeAgainstWeights()
    {
           double [][] derivative = new double[numNeurons][numNeurons];
            for (int post = 0; post < numNeurons; post++)
            {
                    for (int pre = 0; pre < numNeurons; pre++)
                    {
                            if (inLayer(1,pre)) // hidden to output
                            {
                                int hidden = pre;
                                int output = post;
                            	derivative[hidden][output] = activity[hidden];
                            }
                            if (inLayer(0, pre)) // input to hidden
                            {
                                int input = pre;
                                int hidden = post;
                                int output = this.getNumNeurons()-1;
                                derivative[input][hidden] = weight[hidden][output] * sigmoidDerivative(netInput[hidden]) * activity[input];
                            }
                    }
            }
            return derivative;
    }

}
